<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Supplier link
* @package TenderSystem
* @subpackage organisation
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
$required[1]['classification'] = "1";
$required[1]['permission'] = "2";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// instantiate the xml object
	$new_xml = new xml;
	// errors 
	if(is_array($params['error'])) {
		if ($params['display'] == "main") {
			// generate main xml 
			$xml = $new_xml->xml_generator("left","main_supplier",$params['error'],"",$user,$cfg);
		} else {
			// generate left xml 
		$xml = $new_xml->xml_generator("left","left_supplier",$params['error'],"",$user,$cfg);
		}
	} else {
		require($cfg['file'].'modules/organisation/class/supplier.class.php');
		require($cfg['file'].'modules/generic/class/file.class.php');
		if($user['classification'] != "3") {
			$params['organisationid'] = $user['organisation'];
		}
		// instantiate object
		$new_organisation = new supplier;
		$new_file = new file;
		// get organisations
		$xml_params['organisation'] = $new_organisation->search($params,$cfg,$conn);
		// if organisations are loaded
		if ($xml_params['organisation']) {
			// get branches
			if( $params['organisationid']) {
				$params['searchinfo']['organisationid'] = $params['organisationid'];
				// instantiate object
				$new_branch = new branch;
				// get user info 
				$xml_params['branch'] = $new_branch->search($params,$cfg,$conn);
				// if branches are loaded get users
				if ($xml_params['branch']) {
					if( $params['branchid']) {
						$params['searchinfo']['branchid'] = $params['branchid'];
					}
					// instantiate object
					$new_user = new user;
					// get user info 
					$xml_params['users'] = $new_user->search($params,$cfg,$conn);
				}
			}
		}
		$xml_params['module'] = $params['admin'];
		if($params['searchinfo']['organisationid']) {
			$xml_params['organisationid'] = $params['searchinfo']['organisationid'];
		}
		if($params['searchinfo']['branchid']) {
			$xml_params['branchid'] = $params['searchinfo']['branchid'];
		}
		// join errors
		if(!empty($new_organisation->error)) {
			$errors = array_merge($errors,$new_organisation->error);
		}
		if(!empty($new_branch->error)) {
			$errors += array_merge($errors,$new_branch->error);
		}
		if(!empty($new_user->error)) {
			$errors += array_merge($errors,$new_user->error);
		}
		$new_file->link_api_find("organisation","left_supplier",$xml_params,$user,$cfg,$conn);
		if ($params['display'] == "main") {
			// generate xml
			$xml = $new_xml->xml_generator("organisation","main_supplier",$errors,$xml_params,$user,$cfg);
		} else {
			// generate xml
			$xml = $new_xml->xml_generator("organisation","left_supplier",$errors,$xml_params,$user,$cfg);
		}
	}
}
?>