<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Profile
* @package TenderSystem
* @subpackage organisation
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = "all";
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	require($cfg['file'].'modules/area/class/area.class.php');
	require($cfg['file'].'modules/category/class/category.class.php');
	require($cfg['file'].'modules/generic/class/file.class.php');
	require($cfg['file'].'modules/password/class/password.class.php');
	require($cfg['file'].'modules/generic/class/message.class.php');
	require($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	// instantiate object
	$new_organisation = new organisation;
	$new_area = new area;
	$new_category = new category;
	$new_password = new password;
	$new_file = new file;
	if(!$params['id']) {
		$params['id'] = $user['organisation'];
	}
	$xml_params['id'] = $params['id'];
	// check approval
	if($user['classification'] == "3" && $user['permission'] != "2") {
		// only super administrator is allowed to delete organisation
	 	unset($params['update']['status']);
	}
	// check if editable 
	if($user['classification'] == "3") {
	 	$xml_params['editable'] = "1";
	} else {
		$xml_params['editable'] = "0";
	}
	// add attachment
	if ($xml_params['editable'] && $params['logo']) {
		$params['update']['attachment'] = $new_file->file_upload($params['logo'],$user['id'],$cfg,$conn);
	}
	// get organisation profile
	$xml_params['organisationinfo'][0] = $new_organisation->get_profile($params,$cfg,$conn);
	// search params to find users for the organisation 
	$params['searchinfo']['organisationid'] = $xml_params['organisationinfo'][0]['organisationid'];
	$params['searchinfo']['extrainfo'] = "1";				
	// instantiate object
	$new_users = new user;
	// get user info 
	$users_for_org = $new_users->search($params,$cfg,$conn);
	$xml_params['organisationinfo'][0]['users'] = $users_for_org;
	// update organisation info 
	if($params['update'] && !isset($params['error'])) {
		// check permissions
		if ($xml_params['editable']) {
		  	// not allowed to changed organisation
			unset($params['update']['organisation']);
		  	// ensure that not deleting own organisation
		  	if ($xml_params['organisationinfo'][0]['status'] === "0") {
		  		// organisation already deleted
		  		$errors[] = "363";
		  	} elseif ($params['update']['status'] === "0") {
		  		if ($user['organisation'] == $params['id']) {
					// unset update
					unset($params['update']['status']);
			  		// Can not delete own organisation
					$errors[] = "223";
		  		} else {
		  			// set the user that deleted as well as date
		  			$params['update']['deleted_by'] = $user['id'];
		  			$new_database = new database;
					$new_database->setTime("deleted",$params['update'],"",$cfg);
		  		}
		  	}
		  	// create where clause 
			$params['where'] = " id = ".$params['id']." ";
			if($new_organisation->update_organisation($params,$cfg,$conn)) {
				if($params['update']['status'] != "0") {
					$xml_params['updated'] = "1";
					// repopulate the organisation info
					$xml_params['organisationinfo'][0] = $new_organisation->get_profile($params,$cfg,$conn);
					// search params to find users for the organisation 
					$params['searchinfo']['organisationid'] = $xml_params['organisationinfo'][0]['organisationid'];
					$params['searchinfo']['extrainfo'] = "1";				
					//	instantiate object
					$new_users = new user;
					// get user info 
					$users_for_org = $new_users->search($params,$cfg,$conn);
					$xml_params['organisationinfo'][0]['users'] = $users_for_org;	
				} else {
					$xml_params['deleted'] = "1";
					$xml_params['editable'] = "0";
				}
				// approving organisation
				if($params['update']['status'] == "1") {
					$user_info = $new_organisation->get_rep_info($params['id'],$cfg,$conn);
					$new_password->send_password($user_info,$user['id'],$cfg,$conn);
					// join errors
					if($new_password->error) {
						$errors = $errors + $new_password->error;
					}
				}
			}
		} else {
			// unauthorised to edit fields
			$errors[] = "52";
		}
	}
	// determine if not administrator
	if ($user['classification'] != "3") { 
		// determine if viewing own organisation
		if ($user['organisation'] != $xml_params['organisationinfo'][0]['organisationid']) {
			// ensure that suppliers can only see companies and vice versa
			if ($xml_params['organisationinfo'][0]['classification'] == "3" || $xml_params['organisationinfo'][0]['classification'] == $user['classification']) {
				// not allowed to view information
				unset($xml_params);
				$errors[] = "359";
				// generate xml 
				$xml = $new_xml->xml_generator("organisation","error",$errors,$xml_params,$user,$cfg);
			} else {
				// strip all service fees
				unset($xml_params['organisationinfo'][0]['transaction_min']);
				unset($xml_params['organisationinfo'][0]['transaction_fee']);
				unset($xml_params['organisationinfo'][0]['user_fee']);
				unset($xml_params['organisationinfo'][0]['sms_fee']);
			}
		} else {
			// only display service fee to organisation administrators
			if ($user['permission'] == "1") {
				// strip all service fees
				unset($xml_params['organisationinfo'][0]['transaction_min']);
				unset($xml_params['organisationinfo'][0]['transaction_fee']);
				unset($xml_params['organisationinfo'][0]['user_fee']);
				unset($xml_params['organisationinfo'][0]['sms_fee']);
			}	
		}
	}
	// continue
	if ($xml_params) {
		// check needs of suppliers
		if ($xml_params['editable'] && $xml_params['organisationinfo'][0]['classification'] == "1") {
			// check area needs
			$info['searchinfo']['organisationid'] = $xml_params['organisationinfo'][0]['organisationid'];
			if(!$new_area->search($info,$cfg,$conn)) {
				$xml_params['needarea'] = "1";
			}
			require($cfg['file'].'modules/organisation/class/supplier.class.php');
			$new_supplier = new supplier;
			// check company panel
			if(!$new_supplier->search_panel($info['searchinfo']['organisationid'],$cfg,$conn)) {
				$xml_params['needcompany'] = "1";
			}
		} elseif ($xml_params['organisationinfo'][0]['classification'] == "2" && ($xml_params['editable'] || ($user['organisation'] == $xml_params['organisationinfo'][0]['organisationid'] && $user['permission'] > 2)) ){
			require($cfg['file'].'modules/organisation/class/company.class.php');
			$new_company = new company;
			// check supplier needs
			if(!$new_company->search_panel($xml_params['organisationinfo'][0]['organisationid'],$cfg,$conn)) {
				$xml_params['needsupplier'] = "1";
			}
		}
		if(!empty($new_organisation->error)) {
			$errors = array_merge($errors,$new_organisation->error);
		}
		if(!empty($params['error'])) {
			$errors = array_merge($errors,$params['error']);
		}
		// look for addition fields
		$new_file->link_api_find("organisation","profile",$xml_params,$user,$cfg,$conn);
		// look for organisation setup links
		$new_file->link_api_find("organisation","setup",$xml_params,$user,$cfg,$conn);
		// generate xml
		$xml = $new_xml->xml_generator("organisation","profile",$errors,$xml_params,$user,$cfg);
	}	
}
?>