<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Show supplier areas
* @package TenderSystem
* @subpackage organisation
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "all";
$required[0]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// include files
	require($cfg['file'].'modules/generic/class/file.class.php');
	require($cfg['file'].'modules/area/class/area.class.php');
	require($cfg['file'].'modules/organisation/class/supplier.class.php');
	$new_area = new area;
	$new_organisation = new supplier;
	$new_file = new file;
	if(!$params['organisationid']) {
		$params['organisationid'] = $user['organisation'];
	}
	// get states
	$xml_params['state'] = $new_area->search_state($params,$cfg,$conn);
	// get areas
	$xml_params['area'] = $new_area->search($params,$cfg,$conn);
	// get selected areas
	$info['searchinfo']['organisationid'] = $params['organisationid'];
	$xml_params['selectedarea'] = $new_area->search($info,$cfg,$conn);
	// check if editable 
	if($user['classification'] == "3" || ($user['classification'] == "1" && $user['organisation'] == $params['organisationid'])) {
	 	$xml_params['editable'] = "1";
	} else {
		$xml_params['editable'] = "0";
	} 
	if(empty($new_area->error) && $xml_params['editable'] && $params['change']) {
		if(is_array($params['check'])) {
			$check = $params['check'];	
		} else {
			$check = array();
		}
		$old_check = array();
		if (is_array($xml_params['selectedarea'])) {
			foreach($xml_params['selectedarea'] as $selectedarea) {
				$old_check[$selectedarea['areaid']] = $selectedarea['areasupplierid'];
			}
		}
		
		// was not checked but is now checked
		foreach($check as $key => $value) {
			if(!$old_check[$key]) {
				if($new_area->create_area_supplier($key,$params['organisationid'],$user['id'],$cfg,$conn)) {
					$xml_params['updated'] = "1";
				}
			}
		}
		
		// was checked but is now not checked
		foreach($old_check as $key => $value) {
			if(!$check[$key]) {
				if($new_area->delete_area_supplier($value,$user['id'],$cfg,$conn)) {
					$xml_params['updated'] = "1";
				}
			}
		}
		// get selected areas again
		$info['searchinfo']['organisationid'] = $params['organisationid'];
		$xml_params['selectedarea'] = $new_area->search($info,$cfg,$conn);
		// check in need organisation still
		if(!$new_organisation->search_panel($params['organisationid'],$cfg,$conn)) {
			$xml_params['needcompany'] = "1";
		}
		
		// look for organisation setup links
		$xml_params['organisationinfo'][0]['classification'] = "1";
		$xml_params['organisationinfo'][0]['organisationid'] = $params['organisationid'];
		$new_file->link_api_find("organisation","setup",$xml_params,$user,$cfg,$conn);
	}
	$xml_params['organisationid'] = $params['organisationid'];
	// generate xml
	$xml = $new_xml->xml_generator("organisation","show_area",$new_area->error,$xml_params,$user,$cfg);
}
?>