<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Organisation class
* @package TenderSystem
* @subpackage organisation
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class organisation {
	// paramaters
	var $user;
	var $organisation;
	// errors 
	var $error;	

	/**
	 * Inserts a Organisation into the database
	 * 
	 * @param array organisation Organisation information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param integer returns ID of Organisation Or FALSE on failure  
	 */
	function create_organisation($organisation,$cfg,$conn){
		$this->organisation = $organisation;
		if (!$this->organisation['name']){
			// missing organisation name
			$this->error[] = "86";
		}
		if (!$this->organisation['rep_user_id']){
			// Missing user id
			$this->error[] = "209";
		}
		if (!$this->organisation['rep_position']){
			// missing position
			$this->error[] = "93";
		}
		if(!$this->organisation['created_by']) {
			// missing created by
			$this->error[] = "239";
		}
		if(!empty($this->error)){
			// Error in Organisation class 
			$this->error[] = "97";
			return FALSE;
		}
		$new_database = new database;
		$table_name = "~organisation";
		// no id 
		if(!$this->organisation['id']) {
			// generate an id 
			$this->organisation['id'] = $new_database->get_next_id($table_name,$cfg,$conn);
		}
		// set created time
		$new_database->setTime("created",$this->organisation,"",$cfg);
		$new_database->parse_sql($table_name,$cfg);
		// create sql string 
		$conn->AutoExecute($table_name,$this->organisation,"INSERT");
      	if ($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
      		// Error occurred while inserting into Database
			$this->error[] = "1064";
			// response
			return FALSE;
    	} 
		// resturn the id
		return $this->organisation['id'];
	}

	/**
	 * Get the logo associated when the Organisation
	 * 
	 * @param integer id Organisation ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed returns attachment of FALSE on error  
	 */
	function get_logo($id,$cfg,$conn){
		$this->user['id'] = $id;
		// Check if main parameters exist 
		if (!$this->user['id']){
			// missing organisation id 
			$this->error[] = "78";
		}
		// errors 
		if(!empty($this->error)){
			// Error in Organisation class 
			$this->error[] = "97";
			return FALSE;
		}
		$sqlstr = "SELECT ~attachment.id, ~attachment.authentication  ";
		$sqlstr.= "FROM ~organisation, ~attachment ";
		$sqlstr.= "WHERE ~organisation.id = '".$this->user['id']."' ";
		$sqlstr.= "AND ~organisation.attachment = ~attachment.id ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$row = $conn->GetRow($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} elseif(!$row) {
			// Log does not exist
			$this->error[] = "316";
			// Error in Organisation class 
			$this->error[] = "97";
			// response
			return FALSE;
		} 
		$new_file = new file;
       	$response = $new_file->file_display($row,$cfg,$conn);
       	if(!empty($new_file->error)) {
       		$this->error = array_merge($this->error,$new_file->error);
       	}
		// return the file
		return $response;
	}
	
	/**
	 * Get the Organisation name
	 * 
	 * @param integer id Organisation ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed The Name of the Organisation or FALSE on error  
	 */
	function get_name($id,$cfg,$conn){
		if(!is_numeric($id)) {
			$this->user = $id;
		} else {
			$this->user['id'] = $id;
		}
		// Check if main parameters exist 
		if (!$this->user['id']){
			// missing organisation id 
			$this->error[] = "78";
		}
		// errors 
		if(!empty($this->error)){
			// Error in Organisation class 
			$this->error[] = "97";
			return FALSE;
		}
		$sqlstr = "SELECT name ";
		$sqlstr.= "FROM ~organisation ";
		$sqlstr.= "WHERE ~organisation.id = '".$this->user['id']."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	/**
	 * Get the Organisation profile
	 * 
	 * @param integer id Organisation ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed A array with the organisation info or FALSE on error  
	 */
	function get_profile($id,$cfg,$conn){
		if(!is_numeric($id)) {
			$this->user = $id;
		} else {
			$this->user['id'] = $id;
		}
		// Check if main parameters exist 
		if (!$this->user['id']){
			// missing organisation id 
			$this->error[] = "78";
		}
		// errors 
		if(!empty($this->error)){
			// Error in Organisation class 
			$this->error[] = "97";
			return FALSE;
		}
		$sqlstr = "SELECT ~organisation.id AS organisationid, ~organisation.name AS organisationname, ~organisation.classification,";
		$sqlstr.= "~organisation.transaction_min, ~organisation.registered_name, ~organisation.transaction_fee, ";
		$sqlstr.= "~organisation.user_fee, ~organisation.sms_fee, ~organisation.status, ";
		$sqlstr.= "~organisation.rating, ~organisation.created_date, ~organisation.created_time, ";
		$sqlstr.= "~organisation.registration_number, ~organisation.vat_number, ";
		$sqlstr.= "~organisation.created_by, ~organisation.rep_user_id,";
		$sqlstr.= "~attachment.id AS attachment, ~attachment.authentication, ~attachment.name AS picname ";
		$sqlstr.= "FROM ~organisation LEFT JOIN ~attachment ON ~organisation.attachment = ~attachment.id ";
		$sqlstr.= "WHERE ~organisation.id = '".$this->user['id']."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$row = $conn->GetRow($sqlstr,"",TRUE);
		if($row === FALSE) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} elseif(!$row) {
			// Organisation does not exist
			$this->error[] = "80";
			// Error in Organisation class 
			$this->error[] = "97";
			// response
			return FALSE;
		} 
		// change time in proper format
		$new_database->convertSingleTime($row,$cfg);
		$new_user = new user;
		// get the rep info
		$rep = $new_user->get_info($row['rep_user_id'],$cfg,$conn);
		if(!$rep) {
			if(!empty($new_user->error)) {
				$this->error = array_merge($this->error,$new_user->error);
			}
			// Error in Organisation class 
			$this->error[] = "97";
			// response
			return FALSE;
		}
		$row['repid'] = $rep['id'];
		$row['repname'] = $rep['name'];
		$row['repsurname'] = $rep['surname'];
		$row['repstatus'] = $rep['status'];
		$row['repemail'] = $rep['email'];
		$row['repphone_work'] = $rep['phone_work'];
		$row['repphone_prefix'] = $rep['phone_prefix'];
		// get the creator info
		$creator = $new_user->get_info($row['created_by'],$cfg,$conn);
		if(!$creator) {
			if(!empty($new_user->error)) {
				$this->error = $new_user->error;
			}
			// Error in Organisation class 
			$this->error[] = "97";
			// response
			return FALSE;
		}
		$row['creatorid'] = $creator['id'];
		$row['creatorname'] = $creator['name'];
		$row['creatorsurname'] = $creator['surname'];
		return $row;
	}
	
	/**
	 * Get the Organisation profile
	 * 
	 * @param integer id Organisation ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed A array with the organisation info or FALSE on error  
	 */
	function get_rep_info($id,$cfg,$conn){
		if(!is_numeric($id)) {
			$this->user = $id;
		} else {
			$this->user['id'] = $id;
		}
		// Check if main parameters exist 
		if (!$this->user['id']){
			// missing organisation id 
			$this->error[] = "78";
		}
		// errors 
		if(!empty($this->error)){
			// Error in Organisation class 
			$this->error[] = "97";
			return FALSE;
		}
		$sqlstr = "SELECT ~organisation.rep_user_id ";
		$sqlstr.= "FROM ~organisation ";
		$sqlstr.= "WHERE ~organisation.id = '".$this->user['id']."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		$new_user = new user;
		// get the rep info
		$rep = $new_user->get_info($one,$cfg,$conn);
		if(!$rep) {
			if(!empty($new_user->error)) {
				$this->error = array_merge($this->error,$new_user->error);
			}
			// Error in Organisation class 
			$this->error[] = "97";
			// response
			return FALSE;
		}
		return $rep;
	}
	
	/**
	 * Search for organisations
	 * 
	 * @param array params Search Information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed A array with the organisations or FALSE on error  
	 */
	function search($params,$cfg,$conn) {
		$this->organisation = $params;
		// sqlstr
		$sqlstr = "SELECT ~organisation.id AS organisationid, ~organisation.name AS organisationname, ~organisation.status, ";
		$sqlstr.= "~organisation.classification ";
		if($this->organisation['searchinfo']['extrainfo']) {
			$sqlstr.= ", ~organisation.rep_user_id ";
		}
		if($this->organisation['searchinfo']['supplierid'] || $this->organisation['searchinfo']['organisationid']) {
			$sqlstr.= ", ~organisation_supplier.id AS orgsupplierid ";
		}
		$sqlstr.= "FROM ~organisation ";
		// include ~organisation_supplier information
		if($this->organisation['searchinfo']['supplierid'] || $this->organisation['searchinfo']['organisationid']) {
			$sqlstr.= ", ~organisation_supplier ";
		}
		// state and ~area information
		if(($this->organisation['searchinfo']['state'] || $this->organisation['searchinfo']['area']) && $this->organisation['searchinfo']['organisationid']) {
			$sqlstr.= ", ~area, ~area_state state, ~area_supplier ";
		}
		if($this->organisation['searchinfo']['organisationstatus']) {
			$sqlstr.= "WHERE ~organisation.status = '".$this->organisation['searchinfo']['organisationstatus']."' ";
		} else {
			$sqlstr.= "WHERE ~organisation.status = '1' ";
		}
		// include ~organisation_supplier information
		if($this->organisation['searchinfo']['supplierid']) {
			$sqlstr.= "AND ~organisation.id = ~organisation_supplier.organisation ";
			$sqlstr.= "AND ~organisation_supplier.status = '1' ";
			$sqlstr.= "AND ~organisation_supplier.supplier = ".$this->organisation['searchinfo']['supplierid']."  ";
		}
		if($this->organisation['searchinfo']['organisationid']) {
			$sqlstr.= "AND ~organisation.id = ~organisation_supplier.supplier ";
			$sqlstr.= "AND ~organisation_supplier.status = '1' ";
			$sqlstr.= "AND ~organisation_supplier.organisation = ".$this->organisation['searchinfo']['organisationid']."  ";
		}
		if(($this->organisation['searchinfo']['state'] || $this->organisation['searchinfo']['area']) && $this->organisation['searchinfo']['organisationid']) {
			$sqlstr.= "AND ~organisation.id = ~area_supplier.supplier ";
			$sqlstr.= "AND ~area_supplier.area = ~area.id ";
			$sqlstr.= "AND ~area.state = state.id ";
			$sqlstr.= "AND ~area_supplier.status = '1' ";
			$sqlstr.= "AND ~area.status = '1' ";
			$sqlstr.= "AND state.status = '1' ";
		}
		if($this->organisation['searchinfo']['state'] && $this->organisation['searchinfo']['organisationid']) {
			$sqlstr.= "AND state.id = ".$this->organisation['searchinfo']['state']." ";
		}
		if($this->organisation['searchinfo']['area'] && $this->organisation['searchinfo']['organisationid']) {
			$sqlstr.= "AND ~area.id = ".$this->organisation['searchinfo']['area']." ";
		}
		if ($this->organisation['searchinfo']['searchvalue']) {
			$sqlstr.= "AND upper(~organisation.name) LIKE '%".strtoupper($this->organisation['searchinfo']['searchvalue'])."%' ";
		}
		if ($this->organisation['searchinfo']['organisationname']) {
			$sqlstr.= "AND ~organisation.name = '".$this->organisation['searchinfo']['organisationname']."' ";
		}
		if($this->organisation['searchinfo']['classification']) {
			$sqlstr.= "AND ~organisation.classification = ".$this->organisation['searchinfo']['classification']." ";
		}
		if($this->organisation['searchinfo']['organisation']) {
			$sqlstr.= "AND ~organisation.id = ".$this->organisation['searchinfo']['organisation']." ";
		}
		if(is_array($this->organisation['searchinfo']['organisationids'])) {
			if(count($this->organisation['searchinfo']['organisationids']) > 1) {
				$sqlstr.= "AND ( ~organisation.id = ".$this->organisation['searchinfo']['organisationids'][0]." ";
				for($i = 1; $i < count($this->organisation['searchinfo']['organisationids']); $i++) {
					$sqlstr.= "OR ~organisation.id = ".$this->organisation['searchinfo']['organisationids'][$i]." ";
				}
				$sqlstr.= ") ";
			} elseif(count($this->tender['searchinfo']['tenderids']) == 1) {
				$sqlstr.= "AND ~organisation.id = ".$this->organisation['searchinfo']['organisationids'][0]." ";
			}
		}
		$sqlstr.= "GROUP BY ~organisation.id, ~organisation.name, ~organisation.status, ~organisation.classification ";
		if($this->organisation['searchinfo']['extrainfo']) {
			$sqlstr.= ", ~organisation.rep_user_id ";
		}
		if($this->organisation['searchinfo']['supplierid'] || $this->organisation['searchinfo']['organisationid']) {
			$sqlstr.= ", ~organisation_supplier.id ";
		}
		$sqlstr.= "ORDER BY ~organisation.name ASC, ~organisation.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		if($this->organisation['searchinfo']['extrainfo']) {
			// get rep info
			$new_users = new user;
			foreach($all as $key => $value) {
				$usersinfo = $new_users->get_info($value['rep_user_id'],$cfg,$conn);
				$all[$key]['repname'] = $usersinfo['name'];
				$all[$key]['repsurname'] = $usersinfo['surname'];
				$all[$key]['repemail'] = $usersinfo['email'];
				$all[$key]['repphone_prefix'] = $usersinfo['phone_prefix'];
				$all[$key]['repphone_work'] = $usersinfo['phone_work'];
				$all[$key]['repphone_mobile'] = $usersinfo['phone_mobile'];
			}
		}
		return $all;
	}
	
	/**
	 * Update Organisation information
	 * 
	 * @param array update the update Information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param boolean TRUE on success, FALSE on failure  
	 */
	function update_organisation($update,$cfg,$conn) {
		// Check if main parameters exist 
		if (!$update['where']){
			// missing where clause
			$this->error[] = "231";
		}
		$new_database = new database;
		if(!$new_database->update_table("~organisation",$update['update'],$update['where'],$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in Organisation Class
			$this->error[] = "97";
			return FALSE;
		} 
      	return TRUE;
	}
	
	/**
	 * Sets the Log of an Organisation
	 * 
	 * @param array logo The file information
	 * @param integer userid The ID of the user
	 * @param integer organisation The ID of the Organisation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 * 
	 * @return boolean TRUE on success or FALSE on error
	 */
	function set_logo($logo,$userid,$organisation,$cfg,$conn) {
		$new_file = new file;
		// insert the file
		$update['attachment'] = $new_file->file_upload($logo,$userid,$cfg,$conn);
		if($new_file->error) {
			// set errors
			$this->error = $new_file->error;
			// Error in Organisation class 
			$this->error[] = "97";
			// response
			return FALSE;
		}
		$new_database = new database;
		// table name
		$table_name = "~organisation";
		$new_database->parse_sql($table_name,$cfg);
		$where = " id = ".$organisation;
		// insert it
		$conn->AutoExecute($table_name,$update,"UPDATE",$where);
	    if ($conn->ErrorMsg()) {
	    	// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while updating information on database
			$this->error[] = "1066";
			// response
			return FALSE;
      	}
      	// response
		return TRUE;
	}

	/**
	 * Create a link between a company and supplier
	 * 
	 * @param array insert the update Information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param boolean TRUE on success, FALSE on failure  
	 */
	function create_organisation_supplier($insert,$cfg,$conn){
		$this->organisation = $insert;
		if (!$this->organisation['organisation']){
			// Missing organisation id
			$this->error[] = "78";
		}
		if (!$this->organisation['supplier']){
			// Missing organisation id
			$this->error[] = "78";
		}
		if(!empty($this->error)){
			// Error in organisation class
			$this->error[] = "97";
			return FALSE;
		}
		$new_database = new database;
		$table_name = "~organisation_supplier";
		if(!$this->organisation['id']) {
			// generate an id 
			$this->organisation['id'] = $new_database->get_next_id($table_name,$cfg,$conn);
		}
		// set created time
		$new_database->setTime("created",$this->organisation,"",$cfg);
		$new_database->parse_sql($table_name,$cfg);
		// extcute sql insert
		$conn->AutoExecute($table_name,$this->organisation,"INSERT");
		if ($conn->ErrorMsg()) {
			$new_error = new error;
				$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
				$new_error->log("SQL","critical",$error_text,$cfg);
				// Error occurred while inserting into Database
				$this->error[] = "1064";
				// response
				return FALSE;
		} 
		// resturn the id
		return TRUE;
	}

	/**
	 * delete a link between a company and supplier
	 * 
	 * @param integer id The Link ID
	 * @param integer usersid The users ID of the deleter
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param boolean TRUE on success, FALSE on failure  
	 */
	function delete_organisation_supplier($id,$usersid,$cfg,$conn) {
		if (!$id){
			// Missing organisation supplier id
			$this->error[] = "319";
		}
		if (!$usersid){
			// Missing user id
			$this->error[] = "209";
		}
		if(!empty($this->error)){
			// Error in organisation class
			$this->error[] = "97";
			return FALSE;
		}
		$update['status'] = "0";
		$update['deleted_by'] = $usersid;
		$where = " id = ".$id." ";
		$new_database = new database;
		// set deleted time
		$new_database->setTime("deleted",$update,"",$cfg);
		if(!$new_database->update_table("~organisation_supplier",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in Organisation Class
			$this->error[] = "97";
			return FALSE;
		} 
      	return TRUE;
	}
	
	/**
	 * Get the Organisation information
	 * 
	 * @param integer id Organisation ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed A array with the organisation info or FALSE on error  
	 */
	function get_info($id,$cfg,$conn) {
		if(is_numeric($id)) {
			$this->user['id'] = $id;
		} else {
			$this->user = $id;
		}
		// Check if main parameters exist 
		if (!$this->user['id']){
			// Missing organisation id
			$this->error[] = "78";
		}
		// errors 
		if(!empty($this->error)){
			// Error in Organisation Class
			$this->error[] = "97";
			return FALSE;
		}
		$sqlstr = "SELECT * ";
		$sqlstr.= "FROM ~organisation ";
		$sqlstr.= "WHERE ~organisation.id = ".$this->user['id']." "; 
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$row = $conn->GetRow($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $row;
	}
	
	/**
	 * search for tenders
	 * 
	 * @param integer value The Tender ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_approval_organisation_count($cfg,$conn) {
		$sqlstr = "SELECT COUNT(~organisation.id) ";
		// FROM
		$sqlstr.= "FROM ~organisation ";
		// WHERE
		$sqlstr.= "WHERE  ~organisation.status = 2 ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
}
?>