<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Supplier class
* @package TenderSystem
* @subpackage organisation
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class supplier extends organisation {
	
	function supplier() {
		// allow php5 to work
		$this->error = array();	
	}
	
	/**
	 * Search for company on panel
	 * 
	 * @param integer supplier Supplier Organisation ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed A array with the suppliers or FALSE on error  
	 */
	function search_panel($supplier,$cfg,$conn) {
		// sqlstr
		$sqlstr = "SELECT DISTINCT ~organisation.id AS organisationid, ~organisation.name AS organisationname, ~organisation.status, ";
		$sqlstr.= "~organisation_supplier.id, upper(~organisation.name) AS ign, ~organisation_supplier.status ";
		$sqlstr.= "FROM ~organisation, ~organisation_supplier ";
		$sqlstr.= "WHERE ~organisation.status = '1' ";
		$sqlstr.= "AND ~organisation.id = ~organisation_supplier.organisation ";
		$sqlstr.= "AND ~organisation_supplier.status = '1' ";
		$sqlstr.= "AND ~organisation_supplier.supplier = ".$supplier."  ";
		$sqlstr.= "ORDER BY upper(~organisation.name) ASC, ~organisation.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $all;
	}
}
?>