<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Company overview
* @package TenderSystem
* @subpackage overview
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = array("2","3");
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	require_once($cfg['file'].'modules/branch/class/branch.class.php');
	require_once($cfg['file'].'modules/organisation/class/organisation.class.php');
	require_once($cfg['file'].'modules/user/class/user.class.php');
	require_once($cfg['file'].'modules/report/class/report.class.php');
	require_once($cfg['file'].'modules/overview/class/user_profile.class.php');	

	if (!$params['startdate']) {
		$xml_params['daysago3'] = date("Y-m-d",ts_time($cfg) - 259200);
		$params['startdate'] = $xml_params['daysago3'];
		$xml_params['today'] = date("Y-m-d");
		$params['enddate'] = $xml_params['today'];
	} else {
		$xml_params['daysago3'] = date("Y-m-d", strtotime($params['startdate']));
		$xml_params['today'] = date("Y-m-d", strtotime($params['enddate']));
	}	
	$grand_total_uncompleted_rfqs = "0";
	$grand_total_uncompleted_rfqs_value = "0"; 
	$grand_total_items_awarded = "0";
	$grand_total_items_awarded_value = "0";
	$grand_totalrfqs = "0";  
	$grand_totalrfqs_closed = "0";
	$grand_totalrfqs_open = "0";
	$grand_totalitems = "0";
	$grand_total_items_value = "0";
	$grand_total_pos = "0";
	$grand_total_cancelled_pos = "0";		
	$grand_total_noquote = "0";
	$grand_total_quote = "0";
	$grand_total_saving = "0";
	$k = 0;
	// if organisation id exists, show only that organisation
	if($params['organisationid']) {
		$organisation[0] = $params['organisationid'];
	} else { //else show all organisations
		// instantiate object
		$new_organisation = new organisation;
		// get organisations
		$info['searchinfo']['classification'] = "2";
		$org = $new_organisation->search($info,$cfg,$conn);
		$n = 0;
		foreach($org as $org_info) {
			$organisation[$n] = $org_info['organisationid'];
			$n++;					
		}
	}	
	foreach($organisation as $organisation_id) {
		// totals for organisation
		$org_total_uncompleted_rfqs = "0";
		$org_total_uncompleted_rfqs_value = "0"; 
		$org_total_items_awarded = "0";
		$org_total_items_awarded_value = "0";
		$org_totalrfqs = "0";  
		$org_totalrfqs_closed = "0";
		$org_totalrfqs_open = "0";
		$org_totalitems = "0";
		$org_total_items_value = "0";
		$org_total_pos = "0";
		$org_total_cancelled_pos = "0";
		$org_total_noquote = "0";
		$org_total_quote = "0";
		$org_total_saving = "0";
				
		// instantiate object		
		$new_organisation = new organisation;
		if (count($organisation) == 1) {
			$xml_params['organisation'][$k]['subscriber_organisationid'] = $organisation_id;
		}
		// get name of organisaiton
		$xml_params['organisation'][$k]['organisationname'] = $new_organisation->get_name($organisation_id,$cfg,$conn);
		$org_params['searchinfo']['organisationid'] = $organisation_id;
		// instantiate object
		$new_branch = new branch;
		// get user info 
		$branches_info = $new_branch->search($org_params,$cfg,$conn);
		// if branches are loaded get users
		if ($branches_info) {
			$i = 0;
			foreach($branches_info as $branch_info) {
				//totals for branch
				$total_uncompleted_rfqs = "0";
				$total_uncompleted_rfqs_value = "0"; 
				$total_items_awarded = "0";
				$total_items_awarded_value = "0";
				$totalrfqs = "0";  
				$totalrfqs_closed = "0";
				$totalrfqs_open = "0";
				$totalitems = "0";
				$total_items_value = "0";
				$total_pos = "0";
				$total_cancelled_pos = "0";
				$total_noquote = "0";
				$total_quote = "0";
				$total_saving = "0";
				// search params to find users for a branch 
				$params['searchinfo']['organisationid'] = $organisation_id;
				$params['searchinfo']['branchid'] = $branch_info['branchid'];		
				$params['searchinfo']['extrainfo'] = "1";				
				// instantiate object
				$new_user = new user;
				// get user info 
				$users_info = $new_user->search($params,$cfg,$conn);
				$xml_params['organisation'][$k]['branch'][$i]['name'] = $branch_info['branchname'];
				$j = 0;
				// instantiate object
				$user_profile = new user_profile;
				foreach($users_info as $user_info) {
					$params['usersid'] = $user_info['usersid'];
					$params['organisationid'] = $organisation_id;
					$params['branchid'] = $branch_info['branchid'];
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['id'] = $user_info['usersid'];
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['name'] = $user_info['name']." ".$user_info['surname'];
					// get total number and value for tender items 
					$tender_items = $user_profile->get_total_items($params,$cfg,$conn);
					$items_value = 0;
			        // get total value for tender items
					if ($tender_items) {
						// get total number for tender items		
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items'] = count($tender_items);
						$totalitems += count($tender_items);
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_value'] = "0.00";
						foreach($tender_items as $tender_info) {
							if ($tender_info) {
								$items_value += $tender_info;
								$total_items_value += $tender_info;
							}						
						}	  
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_value'] = sprintf("%01.2f", $items_value); 	
					} else {						
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items'] = "0";
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_value'] = "0.00";						
					}
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['count'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['value'] = "0.00";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded_value'] = "0.00";						
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_rfqs_closed'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_rfqs_open'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_orders'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['cancelled_orders'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['conversion_rate'] = "0";		
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['savings'] = "0.00";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['savingspercentage'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['projected'] = "0.00";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['average'] = "0.00";					
					if (count($tender_items) > 0) {
						// get number of uncompleted RFQs for each user
						$tenders = $user_profile->get_uncompleted_rfqs($params,$cfg,$conn);
				        // get total value for uncompleted RFQs
				        $uncompleted_tenders_value = 0;			        
						if ($tenders) {
							// get total number for uncompleted RFQs		
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['count'] = count($tenders);
							$total_uncompleted_rfqs += count($tenders);
							foreach($tenders as $tender_info) {
								if ($tender_info) {
									$uncompleted_tenders_value += $tender_info;
									$total_uncompleted_rfqs_value += $tender_info;
								} 
							}	  
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['value'] = sprintf("%01.2f", $uncompleted_tenders_value); 
						} else {						
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['count'] = "0";
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['value'] = "0.00";
						} 
						
						// get total number and value for tender items 
						$tender_items_awarded = $user_profile->get_total_items_awarded($params,$cfg,$conn);
						$items_awarded_value = 0;			        				 
				        // get total value for tender items awarded
						if ($tender_items_awarded) {
							// get total number for tender items awarded		
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded'] = count($tender_items_awarded);
							$total_items_awarded += count($tender_items_awarded);
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded_value'] = "0.00";
							foreach($tender_items_awarded as $tender_info) {
								if ($tender_info['sum']) {
									$items_awarded_value += $tender_info['sum'];
									$total_items_awarded_value += $tender_info['sum'];
								}						
							}
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded_value'] = sprintf("%01.2f", $items_awarded_value); 	  
						} else {						
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded'] = "0";
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded_value'] = "0.00";						
						} 								 
						// get total RFQs, conversion rate and average RFQ value for each user
						$params1['organisationid'] = $organisation_id;
						$params1['branchid'] = $branch_info['branchid'];
						$params1['usersid'] = $user_info['usersid'];
						$params1['startdate'] = $params['startdate'];
						$params1['enddate'] = $params['enddate'];
						$params1['status'] = "closed";
						$total_closed = $user_profile->get_total_rfqs($params1,$cfg,$conn);
						if ($total_closed) {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_rfqs_closed'] = count($total_closed);
							$totalrfqs_closed += count($total_closed);  
						} else {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_rfqs_closed'] = "0";
						}					
						$params1['status'] = "open";
						$total_open = $user_profile->get_total_rfqs($params1,$cfg,$conn);
						if ($total_open) {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_rfqs_open'] = count($total_open);
							$totalrfqs_open += count($total_open);  
						} else {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_rfqs_open'] = "0";
						}				
						$params1['status'] = "1";
						$orders = $user_profile->get_total_purchase_orders($params1, $cfg, $conn);
						if ($orders) {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_orders'] = count($orders);
							$total_pos += count($orders);
						} else {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_orders'] = "0";
						}
						$params1['status'] = "2";
						$cancelled_orders = $user_profile->get_total_purchase_orders($params1, $cfg, $conn);
						if ($cancelled_orders) {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['cancelled_orders'] = count($cancelled_orders);
							$total_cancelled_pos += count($cancelled_orders);
						} else {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['cancelled_orders'] = "0";
						}		
						$rate = $user_profile->get_conversion_rate($params1, $cfg, $conn);
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['conversion_rate'] = round($rate[$organisation_id][1], 2);					
						$average = $user_profile->get_average_rfq($params1, $cfg, $conn);
						if ($average) {						
							$average_value = round($average[$organisation_id][1], 2);
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['average'] = sprintf("%01.2f", $average_value);
						} else {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['average'] = "0.00";
						}
					}
					//calculate savings
					$new_report = new report;
					$rparams['searchinfo']['organisationid'] = $organisation_id;
					$rparams['searchinfo']['branchid'] = $branch_info['branchid'];
					$rparams['searchinfo']['usersid'] = $user_info['usersid'];
					$rparams['searchinfo']['startdate'] = $params['startdate'];
					$rparams['searchinfo']['enddate'] = $params['enddate'];
					$user_noquote = "0"; //noquote amount for each user
					$saving = "0"; // savings for each user
					$quote = "0"; // quotes  for each user
					$close_tender = $new_report->search_close($rparams,$cfg,$conn);
					for($t = 0; $t < count($close_tender); $t++) {
						// check quote
						if($close_tender[$t]['quote'] <= 0) {
							// total noquote price
							$user_noquote += $close_tender[$t]['bestprice'];
							$total_noquote += $close_tender[$t]['bestprice'];
							$org_total_noquote += $close_tender[$t]['bestprice'];
							$grand_total_noquote += $close_tender[$t]['bestprice'];							
						} elseif($close_tender[$t]['quote'] < $close_tender[$t]['bestprice']) {
							// total noquote price
							$user_noquote += $close_tender[$t]['bestprice'];
							$total_noquote += $close_tender[$t]['bestprice'];
							$org_total_noquote += $close_tender[$t]['bestprice'];
							$grand_total_noquote += $close_tender[$t]['bestprice'];
						} else {
							$quote += $close_tender[$t]['quote'];
							$saving += $close_tender[$t]['saving'];
							$total_quote += $close_tender[$t]['quote'];
							$total_saving += $close_tender[$t]['saving'];
							$org_total_quote += $close_tender[$t]['quote'];
							$org_total_saving += $close_tender[$t]['saving'];
							$grand_total_quote += $close_tender[$t]['quote'];
							$grand_total_saving += $close_tender[$t]['saving'];							
						}												
					}
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['savings'] = sprintf("%01.2f", $saving);
					if($quote > 0) { 
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['savingspercentage'] = round(($saving/$quote) * 100,2);
					} else {
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['savingspercentage'] = "0";
					}
					$sf = $xml_params['organisation'][$k]['branch'][$i]['users'][$j]['savingspercentage']/100;
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['projected'] = $user_noquote  * (1 - 1/(1+$sf)) + $saving;					
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['projected'] = sprintf("%01.2f", $xml_params['organisation'][$k]['branch'][$i]['users'][$j]['projected']);
					
					$user_information = new user;
					$user_report_info = $user_information->get_info($user_info['usersid'],$cfg,$conn);
					if ($user_report_info['emailreport']) {
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['report_setting'] = $user_report_info['emailreport']; 
					} else {
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['report_setting'] = "n";
					}					
					if ($user_report_info['uncompletedreport']) {
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['uncompleted_report_setting'] = $user_report_info['uncompletedreport'];
					} else { 
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['uncompleted_report_setting'] = "n";
					}												
					$j++;
				}
				// get total RFQs, conversion rate and average RFQ value for each branch
				$xml_params['organisation'][$k]['branch'][$i]['total_uncompleted'] = $total_uncompleted_rfqs;   
				$xml_params['organisation'][$k]['branch'][$i]['total_uncompleted_value'] = sprintf("%01.2f", $total_uncompleted_rfqs_value);
				$xml_params['organisation'][$k]['branch'][$i]['total_rfqs_closed'] = $totalrfqs_closed;
				$xml_params['organisation'][$k]['branch'][$i]['total_rfqs_open'] = $totalrfqs_open;				   
				$xml_params['organisation'][$k]['branch'][$i]['total_items'] = $totalitems;
				$xml_params['organisation'][$k]['branch'][$i]['total_items_value'] = sprintf("%01.2f", $total_items_value);
				$xml_params['organisation'][$k]['branch'][$i]['total_items_awarded'] = $total_items_awarded;
				$xml_params['organisation'][$k]['branch'][$i]['total_items_awarded_value'] = sprintf("%01.2f", $total_items_awarded_value);
				$xml_params['organisation'][$k]['branch'][$i]['total_orders'] = $total_pos;
				$xml_params['organisation'][$k]['branch'][$i]['total_cancelled_orders'] = $total_cancelled_pos;
				$xml_params['organisation'][$k]['branch'][$i]['savings'] = sprintf("%01.2f", $total_saving);
				if($total_quote) {
					$xml_params['organisation'][$k]['branch'][$i]['savingspercentage'] = round(($total_saving/$total_quote) * 100,2);
				} else {
					$xml_params['organisation'][$k]['branch'][$i]['savingspercentage'] = "0";
				}
				$sf = $xml_params['organisation'][$k]['branch'][$i]['savingspercentage']/100;
				$xml_params['organisation'][$k]['branch'][$i]['projected'] = $total_noquote  * (1 - 1/(1+$sf)) + $total_saving;					
				$xml_params['organisation'][$k]['branch'][$i]['projected'] = sprintf("%01.2f", $xml_params['organisation'][$k]['branch'][$i]['projected']);	
				// totals for organisation
				$org_total_uncompleted_rfqs += $total_uncompleted_rfqs;
				$org_total_uncompleted_rfqs_value += $total_uncompleted_rfqs_value; 
				$org_total_items_awarded += $total_items_awarded;
				$org_total_items_awarded_value += $total_items_awarded_value;				  
				$org_totalrfqs_closed += $totalrfqs_closed;
				$org_totalrfqs_open += $totalrfqs_open;
				$org_totalitems += $totalitems;
				$org_total_items_value += $total_items_value;
				$org_total_pos += $total_pos;
				$org_total_cancelled_pos += $total_cancelled_pos;
				
				if (($total_items_awarded > 0) && ($totalitems > 0)) {
					$xml_params['organisation'][$k]['branch'][$i]['conversion_rate'] = round(($total_items_awarded/$totalitems)*100, 2);
				} else {
					$xml_params['organisation'][$k]['branch'][$i]['conversion_rate'] = "0";
				}
				if ($totalitems > 0) {
					$branch_average = round(($total_items_value/$totalitems), 2);
					$average_value = sprintf("%01.2f", $branch_average);
					$xml_params['organisation'][$k]['branch'][$i]['average'] = $average_value;					
				} else {
					$xml_params['organisation'][$k]['branch'][$i]['average'] = "0.00";
				}				
				$i++;		
			}
			// get total RFQs, conversion rate and average RFQ value for organisation
			$xml_params['organisation'][$k]['total_uncompleted'] = $org_total_uncompleted_rfqs;
			$xml_params['organisation'][$k]['total_uncompleted_value'] = sprintf("%01.2f", $org_total_uncompleted_rfqs_value); 
			$xml_params['organisation'][$k]['total_items_awarded'] = $org_total_items_awarded;  
			$xml_params['organisation'][$k]['total_items_awarded_value'] = sprintf("%01.2f", $org_total_items_awarded_value); 			  
			$xml_params['organisation'][$k]['total_rfqs_closed'] = $org_totalrfqs_closed;
			$xml_params['organisation'][$k]['total_rfqs_open'] = $org_totalrfqs_open;
			$xml_params['organisation'][$k]['total_items'] = $org_totalitems;
			$xml_params['organisation'][$k]['total_items_value'] = sprintf("%01.2f", $org_total_items_value);
			$xml_params['organisation'][$k]['total_orders'] = $org_total_pos;
			$xml_params['organisation'][$k]['cancelled_orders'] = $org_total_cancelled_pos;
			$xml_params['organisation'][$k]['savings'] = sprintf("%01.2f", $org_total_saving);
			if($org_total_quote > 0) {
				$xml_params['organisation'][$k]['savingspercentage'] = round(($org_total_saving/$org_total_quote) * 100,2);
			}
			$sf = $xml_params['organisation'][$k]['savingspercentage']/100;
			$xml_params['organisation'][$k]['projected'] = $org_total_noquote  * (1 - 1/(1+$sf)) + $org_total_saving;					
			$xml_params['organisation'][$k]['projected'] = sprintf("%01.2f", $xml_params['organisation'][$k]['projected']);
			if (($org_total_items_awarded > 0) && ($org_totalitems > 0)) {
				$xml_params['organisation'][$k]['conversion_rate'] = round(($org_total_items_awarded/$org_totalitems)*100, 2);
			} else {
				$xml_params['organisation'][$k]['conversion_rate'] = "0";
			}
			if ($org_totalitems > 0) {
				$org_average = round(($org_total_items_value/$org_totalitems), 2);
				$xml_params['organisation'][$k]['average'] = sprintf("%01.2f", $org_average); 
			} else {				
				$xml_params['organisation'][$k]['average'] = "0.00";
			}
			// grand totals
			$grand_total_uncompleted_rfqs += $org_total_uncompleted_rfqs;
			$grand_total_uncompleted_rfqs_value += $org_total_uncompleted_rfqs_value; 
			$grand_total_items_awarded += $org_total_items_awarded;
			$grand_total_items_awarded_value += $org_total_items_awarded_value;
			$grand_totalrfqs_closed += $org_totalrfqs_closed;
			$grand_totalrfqs_open += $org_totalrfqs_open;
			$grand_totalitems += $org_totalitems;
			$grand_total_items_value += $org_total_items_value;
			$grand_total_pos += $org_total_pos;
			$grand_total_cancelled_pos += $org_total_cancelled_pos;
			
			$xml_params['startdate'] = $params['startdate'];
			$xml_params['enddate'] = $params['enddate'];
			$k++;
		}	
	} 
	if (count($organisation) > 1) {
		$xml_params['total_uncompleted'] = $grand_total_uncompleted_rfqs;
		$xml_params['total_uncompleted_value'] = sprintf("%01.2f", $grand_total_uncompleted_rfqs_value); 
		$xml_params['total_items_awarded'] = $grand_total_items_awarded;  
		$xml_params['total_items_awarded_value'] = sprintf("%01.2f", $grand_total_items_awarded_value); 			  
		$xml_params['total_rfqs_closed'] = $grand_totalrfqs_closed;
		$xml_params['total_rfqs_open'] = $grand_totalrfqs_open;
		$xml_params['total_items'] = $grand_totalitems;
		$xml_params['total_items_value'] = sprintf("%01.2f", $grand_total_items_value);
		$xml_params['total_orders'] = $grand_total_pos;
		$xml_params['cancelled_orders'] = $grand_total_cancelled_pos;		
		$xml_params['savings'] = sprintf("%01.2f", $grand_total_saving);
		if($grand_total_quote > 0) {
			$xml_params['savingspercentage'] = round($grand_total_saving/$grand_total_quote * 100,2);
		} else {
			$xml_params['savingspercentage'] = "0";
		}
		$sf = $xml_params['savingspercentage']/100;
		$xml_params['projected'] = $grand_total_noquote  * (1 - 1/(1+$sf)) + $grand_total_saving;					
		$xml_params['projected'] = sprintf("%01.2f", $xml_params['projected']);
					
		if (($grand_total_items_awarded > 0) && ($grand_totalitems > 0)) {
			$xml_params['conversion_rate'] = round(($grand_total_items_awarded/$grand_totalitems)*100, 2);
		} else {
			$xml_params['conversion_rate'] = "0";
		}
		if ($grand_totalitems > 0) {
			$grand_total_average = round(($grand_total_items_value/$grand_totalitems), 2);
			$xml_params['average'] = sprintf("%01.2f", $grand_total_average); 
		} else {				
			$xml_params['average'] = "0.00";
		}					
	}
	//require_once($cfg['file'].'modules/settings/config.inc.php');
	$xml = $new_xml->xml_generator("overview","show_overview",$errors,$xml_params,$user,$cfg);		
}
?>