<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Company overview
* @package TenderSystem
* @subpackage overview
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = array("2","3");
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	require_once($cfg['file'].'modules/branch/class/branch.class.php');
	require_once($cfg['file'].'modules/organisation/class/organisation.class.php');
	require_once($cfg['file'].'modules/user/class/user.class.php');
	require_once($cfg['file'].'modules/overview/class/user_profile.class.php');	

	if (!$params['startdate']) {
		$xml_params['daysago3'] = date("Y-m-d",ts_time($cfg) - 259200);
		$params['startdate'] = $xml_params['daysago3'];
		$xml_params['today'] = date("Y-m-d");
		$params['enddate'] = $xml_params['today'];
	} else {
		$xml_params['daysago3'] = date("Y-m-d", strtotime($params['startdate']));
		$xml_params['today'] = date("Y-m-d", strtotime($params['enddate']));
	}	
	$grand_rfqs_received = 0;
	$grand_quotes = 0;
	$grand_quote_value = 0;
	$grand_quote_ratio = 0;
	$grand_total_pos = 0;
	$grand_total_cancelled_pos = 0;
	$grand_total_items_awarded = 0;
	$grand_total_items_awarded_value = 0;
	$grand_total_uncompleted = 0;
	$grand_total_feedback_requests = 0;
	$grand_total_feedback_responses = 0;		
	$k = 0;
	// if organisation id exists, show only that organisation
	if($params['organisationid']) {
		$organisation[0] = $params['organisationid'];
	} else { //else show all organisations
		// instantiate object
		$new_organisation = new organisation;
		// get organisations
		$info['searchinfo']['classification'] = "1";
		$org = $new_organisation->search($info,$cfg,$conn);
		$n = 0;
		foreach($org as $org_info) {
			$organisation[$n] = $org_info['organisationid'];
			$n++;					
		}
	}	
	foreach($organisation as $organisation_id) {
		// totals for organisation
		$org_rfqs_received = 0;
		$org_quotes = 0;
		$org_quote_value = 0;
		$org_quote_ratio = 0;
		$org_total_pos = 0;
		$org_total_cancelled_pos = 0;
		$org_total_items_awarded = 0;
		$org_total_items_awarded_value = 0;
		$org_total_uncompleted = 0;
		$org_total_feedback_requests = 0;
		$org_total_feedback_responses = 0;
		// instantiate object		
		$new_organisation = new organisation;
		if (count($organisation) == 1) {
			$xml_params['organisation'][$k]['subscriber_organisationid'] = $organisation_id;
		}
		// get name of organisaiton
		$xml_params['organisation'][$k]['organisationname'] = $new_organisation->get_name($organisation_id,$cfg,$conn);
		$org_params['searchinfo']['organisationid'] = $organisation_id;
		// instantiate object
		$new_branch = new branch;
		// get user info 
		$branches_info = $new_branch->search($org_params,$cfg,$conn);
		// if branches are loaded get users
		if ($branches_info) {
			$i = 0;
			foreach($branches_info as $branch_info) {
				//totals for branch
				$rfqs_received = 0;
				$quotes = 0;
				$quote_value = 0;
				$quote_ratio = 0;
				$total_pos = 0;
				$total_cancelled_pos = 0;
				$total_items_awarded = 0;
				$total_items_awarded_value = 0;
				$total_uncompleted = 0;
				$total_feedback_requests = 0;
				$total_feedback_responses = 0;
				// search params to find users for a branch 
				$params['searchinfo']['organisationid'] = $organisation_id;
				$params['searchinfo']['branchid'] = $branch_info['branchid'];		
				$params['searchinfo']['extrainfo'] = "1";
				// instantiate object
				$new_user = new user;
				// get user info 
				$users_info = $new_user->search($params,$cfg,$conn);
				$xml_params['organisation'][$k]['branch'][$i]['name'] = $branch_info['branchname'];
				$j = 0;
				// instantiate object
				$user_profile = new user_profile;
				foreach($users_info as $user_info) {
					$params['usersid'] = $user_info['usersid'];
					$params['organisationid'] = $organisation_id;
					$params['branchid'] = $branch_info['branchid'];
					$params['startdate'] = $params['startdate'];
					$params['enddate'] = $params['enddate'];
					
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['count'] = "0";   
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quotes'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quote_value'] = "0.00";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quote_ratio'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded_value'] = "0.00";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_orders'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['cancelled_orders'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['conversion_rate'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['uncompleted_rfqs'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['feedback_requests'] = "0";
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['feedback_responses'] = "0";	
					
			 		// get id, name and number of total RFQs for each user
					$requests = $user_profile->get_rfqs_for_agent($params,$cfg,$conn);
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['id'] = $user_info['usersid'];
					$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['name'] = $user_info['name']." ".$user_info['surname'];
			        // get total value for uncompleted RFQs			        
					if ($requests) {
						// get total number of RFQs		
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['count'] = count($requests);
						$rfqs_received += count($requests);
					} else {						
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['count'] = "0";
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['value'] = "0.00";
					} 
					
					// get total number and value for tender quotes 
					$tender_quotes = $user_profile->get_total_quotes($params,$cfg,$conn);
			        // get total value for tender items
					if ($tender_quotes) {
						// get total number for tender items		
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quotes'] = count($tender_quotes);
						$quotes += count($tender_quotes);
						// calculate quote ratio
						if($xml_params['organisation'][$k]['branch'][$i]['users'][$j]['count'] > 0)	{
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quote_ratio'] = round($xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quotes'] / $xml_params['organisation'][$k]['branch'][$i]['users'][$j]['count'], 2); 
						} else {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quote_ratio'] = "0";
						}						
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quotes_value'] = "0.00";						
						foreach($tender_quotes as $tender_info) {
							if ($tender_info) {
								$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quotes_value'] += $tender_info;
								$quote_value += $tender_info;
							}						
						}						
					} else {						
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quotes'] = "0";
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quotes_value'] = "0.00";
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quote_ratio'] = "0";
					} 	
					if($xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quotes'] > 0) {
						// get total number and value for tender items 
						$tender_items_awarded = $user_profile->get_awarded_for_agent($params,$cfg,$conn);			        				 
				        // get total value for tender items awarded
						if ($tender_items_awarded) {
							// get total number for tender items awarded		
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded'] = count($tender_items_awarded);
							$total_items_awarded += count($tender_items_awarded);
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded_value'] = "0.00";						
							foreach($tender_items_awarded as $tender_info) {
								if ($tender_info['price']) {
									$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded_value'] += $tender_info['price'];
									$total_items_awarded_value += $tender_info['price'];
								}						
							}	  
						} else {						
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded'] = "0";
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded_value'] = "0.00";						
						}
					}	 								 
					if($xml_params['organisation'][$k]['branch'][$i]['users'][$j]['count'] > 0) {
						$uncompleted = $user_profile->get_uncompleted_for_agent($params,$cfg,$conn);	
						if ($uncompleted) {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['uncompleted_rfqs'] = count($uncompleted);
							$total_uncompleted += count($uncompleted);  
						} else {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['uncompleted_rfqs'] = "0";
						}
						$params['status'] = "1";
						$orders = $user_profile->get_purchase_orders_for_agent($params,$cfg,$conn);
						if ($orders) {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_orders'] = count($orders);
							$total_pos += count($orders);
						} else {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_orders'] = "0";
						}
						$params['status'] = "2";
						$cancelled_orders = $user_profile->get_purchase_orders_for_agent($params,$cfg,$conn);
						if ($cancelled_orders) {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['cancelled_orders'] = count($cancelled_orders);
							$total_cancelled_pos += count($cancelled_orders);
						} else {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['cancelled_orders'] = "0";
						}			
											
						if($xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quotes'] > 0) {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['conversion_rate'] = round(($xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded']/$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quotes'])*100 , 2);
						} else {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['conversion_rate'] = "0";
						}					
								
						$feedback_requests = $user_profile->get_feedback_requests_for_agent($params,$cfg,$conn);	
						if ($feedback_requests) {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['feedback_requests'] = count($feedback_requests);
							$total_feedback_requests += count($feedback_requests);  
						} else {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['feedback_requests'] = "0";
						}
						$feedback_responses = $user_profile->get_feedback_response_for_agent($params,$cfg,$conn);	
						if ($feedback_responses) {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['feedback_responses'] = count($feedback_responses);
							$total_feedback_responses += count($feedback_responses);  
						} else {
							$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['feedback_responses'] = "0";
						}
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quotes_value'] = sprintf("%01.2f", $xml_params['organisation'][$k]['branch'][$i]['users'][$j]['quotes_value']);
						$xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded_value'] =  sprintf("%01.2f", $xml_params['organisation'][$k]['branch'][$i]['users'][$j]['total_items_awarded_value']);
					}							
					$j++;
				}
				if($j > 0) {
					// get total RFQs, conversion rate and average RFQ value for each branch
					// set totals for branch				
					$xml_params['organisation'][$k]['branch'][$i]['total_rfqs_received'] = $rfqs_received;   
					$xml_params['organisation'][$k]['branch'][$i]['total_quotes'] = $quotes;
					$xml_params['organisation'][$k]['branch'][$i]['total_quote_value'] = sprintf("%01.2f", $quote_value);
					if($rfqs_received > 0)	{
						$xml_params['organisation'][$k]['branch'][$i]['total_quote_ratio'] = round(($quotes/$rfqs_received),2); 
					} else {
						$xml_params['organisation'][$k]['branch'][$i]['total_quote_ratio'] = "0";
					}				
					$xml_params['organisation'][$k]['branch'][$i]['total_items_awarded'] = $total_items_awarded;
					$xml_params['organisation'][$k]['branch'][$i]['total_items_awarded_value'] = sprintf("%01.2f", $total_items_awarded_value);
					$xml_params['organisation'][$k]['branch'][$i]['total_orders'] = $total_pos;
					$xml_params['organisation'][$k]['branch'][$i]['total_cancelled_orders'] = $total_cancelled_pos;
					if($quotes > 0) {
						$xml_params['organisation'][$k]['branch'][$i]['total_conversion_rate'] = round(($total_items_awarded/$quotes)*100,2);
					} else {
						$xml_params['organisation'][$k]['branch'][$i]['total_conversion_rate'] = "0";
					}
					$xml_params['organisation'][$k]['branch'][$i]['total_uncompleted'] = $total_uncompleted;
					$xml_params['organisation'][$k]['branch'][$i]['total_feedback_requests'] = $total_feedback_requests;
					$xml_params['organisation'][$k]['branch'][$i]['total_feedback_responses'] = $total_feedback_responses;
				} else {
					unset($xml_params['organisation'][$k]['branch'][$i]['name']);
					unset($xml_params['organisation'][$k]['branch'][$i]);
				}				
				// totals for organisation
				$org_rfqs_received += $rfqs_received;
				$org_quotes += $quotes;
				$org_quote_value += $quote_value;
				$org_quote_ratio += $quote_ratio;
				$org_total_pos += $total_pos;
				$org_total_cancelled_pos += $total_cancelled_pos;
				$org_total_items_awarded += $total_items_awarded;
				$org_total_items_awarded_value += $total_items_awarded_value;
				$org_total_uncompleted += $total_uncompleted;
				$org_total_feedback_requests += $total_feedback_requests;
				$org_total_feedback_responses += $total_feedback_responses;
				
				$i++;	
			}
			
			// get total RFQs, conversion rate and average RFQ value for organisation
			//set totals for organisation
			$xml_params['organisation'][$k]['total_rfqs_received'] = $org_rfqs_received;   
			$xml_params['organisation'][$k]['total_quotes'] = $org_quotes;
			$xml_params['organisation'][$k]['total_quote_value'] = sprintf("%01.2f", $org_quote_value);
			if($org_rfqs_received > 0)	{
				$xml_params['organisation'][$k]['total_quote_ratio'] = round(($org_quotes/$org_rfqs_received),2); 
			} else {
				$xml_params['organisation'][$k]['total_quote_ratio'] = "0";
			}				
			$xml_params['organisation'][$k]['total_items_awarded'] = $org_total_items_awarded;
			$xml_params['organisation'][$k]['total_items_awarded_value'] = sprintf("%01.2f", $org_total_items_awarded_value);
			$xml_params['organisation'][$k]['total_orders'] = $org_total_pos;
			$xml_params['organisation'][$k]['total_cancelled_orders'] = $org_total_cancelled_pos;
			if($org_quotes > 0) {
				$xml_params['organisation'][$k]['total_conversion_rate'] = round(($org_total_items_awarded/$org_quotes)*100,2);
			} else {
				$xml_params['organisation'][$k]['total_conversion_rate'] = "0";
			}
			$xml_params['organisation'][$k]['total_uncompleted'] = $org_total_uncompleted;
			$xml_params['organisation'][$k]['total_feedback_requests'] = $org_total_feedback_requests;
			$xml_params['organisation'][$k]['total_feedback_responses'] = $org_total_feedback_responses;
			// grand totals
			$grand_rfqs_received += $org_rfqs_received;
			$grand_quotes += $org_quotes;
			$grand_quote_value += $org_quote_value;
			$grand_quote_ratio += $org_quote_ratio;
			$grand_total_pos += $org_total_pos;
			$grand_total_cancelled_pos = $org_total_cancelled_pos;
			$grand_total_items_awarded = $org_total_items_awarded;
			$grand_total_items_awarded_value = $org_total_items_awarded_value;
			$grand_total_uncompleted = $org_total_uncompleted;
			$grand_total_feedback_requests = $org_total_feedback_requests;
			$grand_total_feedback_responses = $org_total_feedback_requests;		
			/*$rate = $user_profile->get_conversion_rate($params3, $cfg, $conn);
			$xml_params['organisation'][$k]['conversion_rate'] = round($rate[$organisation_id][1], 2);
			//$xml_params['organisation'][$k]['conversion_rate'] = 0;
			$average = $user_profile->get_average_rfq($params3, $cfg, $conn);
			if ($average) {
				$xml_params['organisation'][$k]['average'] = round($average[$organisation_id][1], 2);
			} else {
				$xml_params['organisation'][$k]['average'] = "0";
			}*/
			$xml_params['startdate'] = $params['startdate'];
			$xml_params['enddate'] = $params['enddate'];
			$k++;
		}	
	} 
	if (count($organisation) > 1) {
		$xml_params['total_rfqs_received'] = $grand_rfqs_received;   
		$xml_params['total_quotes'] = $grand_quotes;
		$xml_params['total_quote_value'] = sprintf("%01.2f", $grand_quote_value);
		if($grand_rfqs_received > 0)	{
			$xml_params['total_quote_ratio'] = round(($grand_quotes/$grand_rfqs_received),2); 
		} else {
			$xml_params['total_quote_ratio'] = "0";
		}				
		$xml_params['total_items_awarded'] = $grand_total_items_awarded;
		$xml_params['total_items_awarded_value'] = sprintf("%01.2f", $grand_total_items_awarded_value);
		$xml_params['total_orders'] = $grand_total_pos;
		$xml_params['total_cancelled_orders'] = $grand_total_cancelled_pos;
		if($grand_quotes > 0) {
			$xml_params['total_conversion_rate'] = round(($grand_total_items_awarded/$grand_quotes)*100,2);
		} else {
			$xml_params['total_conversion_rate'] = "0";
		}
		$xml_params['total_uncompleted'] = $grand_total_uncompleted;
		$xml_params['total_feedback_requests'] = $grand_total_feedback_requests;
		$xml_params['total_feedback_responses'] = $grand_total_feedback_responses;
	}	
	$xml = $new_xml->xml_generator("overview","show_supplier_overview",$errors,$xml_params,$user,$cfg);		
}
?>