<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Change password
* @package TenderSystem
* @subpackage password
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// load required files
include($cfg['file'].'modules/password/class/password.class.php');
$new_password = new password();
// if offsite login
if ($params['offsite']) {
	$xml_params['offsite'] = "true";				
}
if($cfg['password']['change']) {
	// determine if username and new password are the same
	if ($new_password->hash_password($user['username'],$cfg) == $params['new_password']) {
		// Username and password may not be the same
		$error[] = "32";
		// generate xml 
		$xml = $new_xml->xml_generator("password","change",$error,$xml_params,$user,$cfg);
	} elseif ($params['current_password'] == $params['new_password']) {
		// Old and new password may not be the same
		$error[] = "7";
		// generate xml 
		$xml = $new_xml->xml_generator("password","change",$error,$xml_params,$user,$cfg);
	} else {
		$params['id'] = $user['id'];
		// login the user
		$validate_password = $new_password->validate_hashed_password($user['id'],$params['current_password'],$cfg,$conn);
		// error handling
		if (!$validate_password) {
			$xml = $new_xml->xml_generator("password","change","22",$xml_params,$user,$cfg);
		} else {
			// incorrect information provided by user
			if (is_array($new_password->error)) {
				// generate xml 
				$xml = $new_xml->xml_generator("password","change",$new_password->error,$xml_params,$user,$cfg);
			} else {
				// change the password
				$change_password = $new_password->change_password($params,$cfg,$conn);
				// error handling
				if (!$change_password) {
					// instantiate the error class
					$new_error = new error;
					// display the error
					$xml = $new_xml->xml_generator("password","change",$new_password->error,$xml_params,$user,$cfg);
				} else {
					// display that password changed successfully through error
					$error_code = "309";
					// set that must be refreshed
					$xml_params['refresh'] = "true";
					// generate xml 
					$xml = $new_xml->xml_generator("generic","success",$error_code,$xml_params,$user,$cfg);
				}
			}
		}
	}
} else {
	// generate xml 
	$xml = $new_xml->xml_generator("password","error","e12","",$user,$cfg);
}
?>