<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Delete purchase order
* @package TenderSystem
* @subpackage procure
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = "3";
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_update.class.php');
	require($cfg['file'].'modules/generic/class/message.class.php');
	require($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	$xml_params['localdisplay'] = $cfg['local']['display'];
	// instantiate object
	$new_update = new procure_update;
	$new_users = new user;
	// get tender info 
	$xml_params['tenderinfo'][0] = $new_update->get_profile($params,$cfg,$conn);
	// check if can be delete 
	if($xml_params['tenderinfo'][0]['status'] < 5) {
		// delete
		$info['status'] = "0";
		$info['error'] = "Deleted";
		$where = "id = ".$params['id'];
		$new_update->update_tender($info,$where,$cfg,$conn);
		// get tender info again
		$xml_params['tenderinfo'][0] = $new_update->get_profile($params,$cfg,$conn);
		if($params['notify']){
			unset($sinfo);
			$extender =  $new_update->get_profile($user['id'],$cfg,$conn);
			$sinfo['searchinfo']['tenderid'] = $params['id'];
			$tender = $new_update->search($sinfo,$cfg,$conn);
			$parties[] = $new_users->get_profile($tender[0]['usersid'],$cfg,$conn);
			if($request = $new_update->search_tender_request($sinfo,$cfg,$conn)) {
				foreach($request as $key => $value) {
					$parties[] = $new_users->get_profile($value['usersid'],$cfg,$conn);
				}
			}
			$info['template'] = "procure_delete";
			$info['message'] = $params['message'];
			$new_update->notify_parties($parties,$tender[0],$extender,$cfg,$conn,$info);
		}
		// generate xml
		// join errors
		if(!empty($new_users->error)) {
			$errors = array_merge($errors,$new_users->error);
		}
		if(!empty($new_tender->error)) {
			$errors = array_merge($errors,$new_tender->error);
		}
		if(!empty($new_report->error)) {
			$errors = array_merge($errros,$new_report->error);
		}
		$xml = $new_xml->xml_generator("procure","profile",$errors,$xml_params,$user,$cfg);
	} else {
		// incorrect status
		$errors[] = "304";
		// generate xml
		$xml = $new_xml->xml_generator("procure","profile",$errors,$xml_params,$user,$cfg);
	}
}
?>