<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Item profile
* @package TenderSystem
* @subpackage procure
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = array("2","3");
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif(is_array($params['error'])) {
	// generate xml 
	$xml = $new_xml->xml_generator("tender","item_profile",$params['error'],"",$user,$cfg);
} else {
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_update.class.php');
	require($cfg['file'].'modules/generic/class/message.class.php');
	require($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	$xml_params['tenderbudget'] = $cfg['tender']['budget'];
	// instantiate object
	$new_update = new procure_update;
	$new_users = new user;
	// get tender info 
	$xml_params['tenderiteminfo'][0] = $new_update->get_item_profile($params,$cfg,$conn);
	// get qoutes
	$params['searchinfo']['tenderitemid'] = $params['id'];
	$xml_params['tenderiteminfo'][0]['quote_response'] = $new_update->search_quote_info($params,$cfg,$conn);
	// check if editable 
	if($user['classification'] == "3" && $xml_params['tenderiteminfo'][0]['status'] > 1) {
	 	$xml_params['editable'] = "1";
	} else {
		$xml_params['editable'] = "0";
	} 
	// update organisation info 
	if($params['info'] && $params['id']) {
		// check permissions
		if (!$xml_params['editable']) {
			// Insufficient authority 
			$params['error'][] = "1067";
			// generate xml
			$xml = $new_xml->xml_generator("procure","profile",$params['error'],$xml_params,$user,$cfg);
		} 
		// check tender status
		elseif($xml_params['tenderiteminfo'][0]['status'] != "2") {
			// Tender has incorrect status
			$params['error'][] = "304";
			// generate xml
			$xml = $new_xml->xml_generator("procure","profile",$params['error'],$xml_params,$user,$cfg);
		}
		// update tender time
		else {
			if($params['info']['budget']) {
				$info['update']['budget'] = $params['info']['budget'];
			}
			$info['update']['brand'] = $params['info']['brand'];
			$info['update']['model'] = $params['info']['model'];
			$info['update']['description'] = $params['info']['description'];
			$info['update']['quote'] = $params['info']['quote'];
			$info['where'] = " id = ".$params['id']." ";
			if($new_update->update_tender_item($info['update'],$info['where'],$cfg,$conn)) {
				$xml_params['updated'] = "1";
			}
			// get tender info again
			$xml_params['tenderiteminfo'][0] = $new_update->get_item_profile($params,$cfg,$conn);
			// check if you should notify parties
			if($params['info']['notify']){
				unset($sinfo);
				if($extender =  $new_users->get_profile($user['id'],$cfg,$conn)) {
					$sinfo['searchinfo']['tenderitemid'] = $id['id'] = $params['id'];
					if($tenderitem = $new_update->get_item_profile($id,$cfg,$conn)){
						$id['id'] = $tenderitem['usersid'];
						if($parties[] = $new_users->get_profile($id,$cfg,$conn)) {
							if($request = $new_update->search_tender_request($sinfo,$cfg,$conn)) {
								foreach($request as $key => $value) {
									$id['id'] = $value['usersid'];
									$parties[] = $new_users->get_profile($id,$cfg,$conn);
								}
							}
							$minfo['template'] = "procure_item_change";
							$minfo['message'] = $params['info']['message'];
							$minfo['requote'] = $params['info']['invalidatequotes'];
							$new_update->notify_parties($parties,$tenderitem,$extender,$cfg,$conn,$minfo);
						}
					}
				}
			}
			// check if quotes should be invalidated
			if($params['info']['invalidatequotes']){
				unset($info);
				$info['update']['status'] = "0";
				$info['update']['error'] = "Invalidated by Item";
				$info['where'] = " status = 2 AND tender_item = ".$params['id']." ";
				$new_update->update_tender_quote($info['update'],$info['where'],$cfg,$conn);
			}
			// generate xml
			// join errros
			if(!empty($new_users->error)) {
				$errors = array_merge($errors,$new_users->error);
			}
			if(!empty($new_update->error)) {
				$errors = array_merge($errors,$new_update->error);
			}
			$xml = $new_xml->xml_generator("procure","item_profile",$errors,$xml_params,$user,$cfg);
		}
	} else {
		// generate xml
		$xml = $new_xml->xml_generator("procure","item_profile",$new_update->error,$xml_params,$user,$cfg);
	}
}
?>