<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Profile
* @package TenderSystem
* @subpackage procure
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = array("2","3");
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif(is_array($params['error'])) {
	// generate xml 
	$xml = $new_xml->xml_generator("tender","profile",$params['error'],"",$user,$cfg);
} else {
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_update.class.php');
	require($cfg['file'].'modules/generic/class/message.class.php');
	require($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	$xml_params['localdisplay'] = $cfg['local']['display'];
	// instantiate object
	$new_update = new procure_update;
	$new_users = new user;
	// get tender info 
	$xml_params['tenderinfo'][0] = $new_update->get_profile($params,$cfg,$conn);
	$xml_params['today'] = date("Y-m-d");
	$xml_params['hour'] = date("H");
	$xml_params['min'] = date("i");
	// check if editable 
	if($user['classification'] == "3" && $xml_params['tenderinfo'][0]['status'] >= 0) {
	 	$xml_params['editable'] = "1";
	} else {
		$xml_params['editable'] = "0";
	} 
	// update organisation info 
	if($params['info']['extendunit'] && $params['id']) {
		// check permissions
		if (!$xml_params['editable']) {
			// Insufficient authority 
			$params['error'][] = "1067";
			// generate xml
			$xml = $new_xml->xml_generator("tender","profile",$params['error'],$xml_params,$user,$cfg);
		} 
		// check tender status
		elseif($xml_params['tenderinfo'][0]['status'] != "4" && $xml_params['tenderinfo'][0]['status'] != "2"  && $xml_params['tenderinfo'][0]['status'] != "0") {
			// Tender has incorrect status
			$params['error'][] = "304";
			// generate xml
			$xml = $new_xml->xml_generator("procure","profile",$params['error'],$xml_params,$user,$cfg);
		}
		// update tender time
		else {
		  	// create where clause
			if($params['info']['extendunit'] == "day") {
				$info['time'] = ts_time($cfg) + $params['info']['extendtime']*86400;
				$time = $new_update->get_closure($info,$cfg);
			} elseif($params['info']['extendunit'] == "hour") {
				$info['time'] = ts_time($cfg) + $params['info']['extendtime']*3600;
				$time = $new_update->get_closure($info,$cfg);
			} elseif($params['info']['extendunit'] == "minute") {
				$info['time'] = ts_time($cfg) + $params['info']['extendtime']*60;
				$time = $new_update->get_closure($info,$cfg);
			} elseif($params['info']['extendunit'] == "date") {
				$year = substr($params['info']['tenderdate'],0,4);
				$month = substr($params['info']['tenderdate'],5,2);
				$day = substr($params['info']['tenderdate'],8,2);
				$hour = $params['info']['hour'];
				$min = $params['info']['min'];
				$info['time'] = mktime ($hour, $min, "0", $month, $day, $year);  
				$time = $new_update->get_closure($info,$cfg);
			} else {
				$time = ts_time($cfg);
			}
			$update_tender['close_date'] = date("Y-m-d",$time);
			$update_tender['close_time'] = date("H:i:s",$time);
			$where = " id = ".$params['id']." ";
			$xml_params['updated'] = "1";
			if($new_update->update_tender($update_tender,$where,$cfg,$conn) && ($xml_params['tenderinfo'][0]['status'] == "4" || $xml_params['tenderinfo'][0]['status'] == "0")) {
				unset($update_tender);
				// lock tender
				$update_tender['status'] = "1";
				$where = "id = ".$params['id'];
				if($new_update->update_tender($update_tender,$where,$cfg,$conn)) {
					// get all tender items to update
					$sinfo['searchinfo']['tenderid'] = $params['id'];
					//$sinfo['searchinfo']['tenderstatus'] = "4";
					if($tender_item = $new_update->search_tender_item($sinfo,$cfg,$conn)) {
						$update['status'] = "2";
						// update each tender item
						foreach($tender_item as $key => $value) {
							$where = "id = ".$value['id']." AND status = 4 OR status = 0 ";
							if($new_update->update_tender_item($update,$where,$cfg,$conn)) {
								 // update quotes
								$where = " tender_item = ".$value['id']." AND status = 4 ";
								$new_update->update_tender_quote($update,$where,$cfg,$conn);
							}
						}
					}
					// open tender
					$update_tender['status'] = "2";
					$where = "id = ".$params['id'];
					$new_update->update_tender($update_tender,$where,$cfg,$conn);
				}
			}
			// get tender info again
			$xml_params['tenderinfo'][0] = $new_update->get_profile($params,$cfg,$conn);
			if($params['info']['notify']){
				unset($sinfo);
				// the user extending the time
				$extender =  $new_users->get_profile($user['id'],$cfg,$conn);
				// get the tender information
				$sinfo['searchinfo']['tenderid'] = $params['id'];
				$tender = $new_update->search($sinfo,$cfg,$conn);
				if($params['info']['notify'] == "all" || $params['info']['notify'] == "subscriber") {
					// notify the subscriber of the tender
					$parties[$tender[0]['usersid']] = $new_users->get_profile($tender[0]['usersid'],$cfg,$conn);
				}
				if($params['info']['notify'] == "all") {
					// find all the agents that are requested to tender
					if($request = $new_update->search_tender_request($sinfo,$cfg,$conn)) {
						// all all agents profiles
						foreach($request as $key => $value) {
							$parties[$value['usersid']] = $new_users->get_profile($value['usersid'],$cfg,$conn);
						}
					}
				} elseif($params['info']['notify'] == "notresponded") {
					// find all the agents that are requested to tender
					if($request = $new_update->search_no_response_tender_request($sinfo,$cfg,$conn)) {
						// all all agents profiles
						foreach($request as $key => $value) {
							$parties[$value['usersid']] = $new_users->get_profile($value['usersid'],$cfg,$conn);
						}
					}
				}
				// the email template to use
				$minfo['template'] = "procure_time_extend";
				// set additional message
				$minfo['message'] = $params['info']['message'];
				$new_update->notify_parties($parties,$tender[0],$extender,$cfg,$conn,$minfo);
			}
			// generate xml
			if(!empty($new_users->error)) {
				$errors = array_merge($errors,$new_users->error);
			}
			if(!empty($new_update->error)) {
				$errors = array_merge($errors,$new_update->error);
			}
			$xml = $new_xml->xml_generator("procure","profile",$errors,$xml_params,$user,$cfg);
		}
	} else {
		// generate xml
		$xml = $new_xml->xml_generator("procure","profile",$new_update->error,$xml_params,$user,$cfg);
	}
}
?>