<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Purchase order
* @package TenderSystem
* @subpackage procure
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// load settings
include($cfg['file'].'modules/tender/config.inc.php');
// instantiate the xml object
$new_xml = new xml;
// load required files
require($cfg['file'].'modules/procure/class/procure.class.php');
require($cfg['file'].'modules/procure/class/procure_update.class.php');
require($cfg['file'].'modules/generic/class/file.class.php');
$new_procure = new procure_update;
$new_file = new file;
$new_users = new user;
$purchase_order = $new_procure->get_purchase_order_email($params,$cfg,$conn);
// error handling
if (!$purchase_order['body']) {
	$xml_params['invalid'] = "1";
	// generate xml 
	$xml = $new_xml->xml_generator("procure","purchase_order",$new_procure->error,$xml_params,$params,$cfg);
} else {
	$xml_params['invalid'] = "0";
	if($params['online']) {
		$xml_params['online'] = "1";
	}
	$xml_params['purchase_order'][] = str_replace("width=\"660\"","width=\"100%\"",$purchase_order);
	$xml_params['url'] = $cfg['url']."index.php";
	$user = $new_users->get_info($purchase_order['agentid'],$cfg,$conn);
	// look for addition fields
	$new_file->link_api_find("procure","purchase_order",$xml_params,$user,$cfg,$conn);
	// generate xml 
	$xml = $new_xml->xml_generator("procure","purchase_order","",$xml_params,$params,$cfg);
}
?>