<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Quote profile
* @package TenderSystem
* @subpackage procure
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// user
$required[1]['classification'] = "2";
$required[1]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// include procure settings
	include($cfg['file'].'modules/procure/config.inc.php');
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_update.class.php');
	require($cfg['file'].'modules/generic/class/message.class.php');
	require($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	$xml_params['localdisplay'] = $cfg['local']['display'];
	// instantiate object
	$new_update = new procure_update;
	$new_users = new user;
	// check if editable 
	if($user['classification'] == "3") {
	 	$xml_params['editable'] = "1";
	} else{
		if($user['classification'] == "2") {
			if($user['permission'] == "1") {
				// limit to quotes of own tenders
				$params['usersid'] = $user['id'];
			} elseif($user['permission'] == "2") {
				// limit to quotes of the branch tenders
				$params['branchid'] = $user['branch'];
			}
		} elseif($user['classification'] == "1") {
			// limit to quotes of the suppliers organisation
			$params['supplierid'] = $user['organisation'];	
		}
		$xml_params['editable'] = "0";
	} 
	// get tender info 
	$xml_params['tenderquoteinfo'][0] = $new_update->get_quote_profile($params,$cfg,$conn);
	// update organisation info 
	if($params['info'] && $params['id']) {
		// check permissions
		if (!$xml_params['editable']) {
			// Insufficient authority 
			$params['error'][] = "1067";
			// generate xml
			$xml = $new_xml->xml_generator("procure","quote_profile",$params['error'],$xml_params,$user,$cfg);
		} 
		// check tender status
		elseif($xml_params['tenderquoteinfo'][0]['status'] != "2" && $xml_params['tenderquoteinfo'][0]['status'] != "4") {
			// Tender has incorrect status
			$params['error'][] = "304";
			// generate xml
			$xml = $new_xml->xml_generator("procure","quote_profile",$params['error'],$xml_params,$user,$cfg);
		}
		// update tender time
		else {
			if($params['info']['brand']) {
				$info['update']['brand'] = $params['info']['brand'];
			}
			if($params['info']['model']) {
				$info['update']['model'] = $params['info']['model'];
			}
			if($params['info']['stock']) {
				$info['update']['stock'] = $params['info']['stock'];
			}
			if($params['info']['description']) {
				$info['update']['description'] = $params['info']['description'];
			}
			if($params['info']['price']) {
				$info['update']['price'] = $params['info']['price'];
			}
			if($params['info']['valid_until']) {
				$info['update']['valid_until'] = $params['info']['valid_until'];
			}
			// adding a late quote
			if($params['info']['classification']) {
				$info['update']['classification'] = $params['info']['classification'];
				$info['update']['error'] = "";
				$info['update']['status'] = "4";
			}
			$info['where'] = " id = ".$params['id']." ";
			if(!empty($info['update']) && $new_update->update_tender_quote($info['update'],$info['where'],$cfg,$conn)) {
				$xml_params['updated'] = "1";
				if($xml_params['tenderquoteinfo'][0]['status'] == "4" || $info['update']['status'] == "4") {
					$new_update->calculate_position($xml_params['tenderquoteinfo'][0]['tenderitemid'],$cfg,$conn);
				}
			}
			if($params['info']['delete']){
				unset($info);
				$info['update']['status'] = "0";
				$info['update']['error'] = "Deleted (".$xml_params['tenderquoteinfo'][0]['error'].")";
				$info['where'] = "id = ".$params['id']." ";
				$new_update->update_tender_quote($info['update'],$info['where'],$cfg,$conn);
			}
			// get tender info again
			$xml_params['tenderquoteinfo'][0] = $new_update->get_quote_profile($params,$cfg,$conn);
			if($params['info']['notify']){
				unset($sinfo);
				$id['id'] = $user['id'];
				if($extender =  $new_users->get_profile($id,$cfg,$conn)) {
					$id['id'] = $xml_params['tenderquoteinfo'][0]['usersid'];
					$parties[] = $new_users->get_profile($id,$cfg,$conn);
					$minfo['template'] = "procure_quote_change";
					$minfo['message'] = $params['info']['message'];
					$minfo['requote'] = $params['info']['delete'];
					$new_update->notify_parties($parties,$xml_params['tenderquoteinfo'][0],$extender,$cfg,$conn,$minfo);
				}
			}
			// generate xml
			if(!empty($new_users->error)) {
				$errors = array_merge($errors,$new_users->error);
			}
			if(!empty($new_update->error)) {
				$errors = array_merge($errors,$new_update->error);
			}
			$xml = $new_xml->xml_generator("procure","quote_profile",$errors,$xml_params,$user,$cfg);
		}
	} else {
		// generate xml
		$xml = $new_xml->xml_generator("procure","quote_profile",$new_update->error,$xml_params,$user,$cfg);
	}
}
?>