<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Selected Quote profiles
* @package TenderSystem
* @subpackage procure
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// user
$required[1]['classification'] = "2";
$required[1]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// include procure settings
	include($cfg['file'].'modules/procure/config.inc.php');
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_update.class.php');
	require($cfg['file'].'modules/generic/class/message.class.php');
	require($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	$xml_params['localdisplay'] = $cfg['local']['display'];
	// instantiate object
	$new_update = new procure_update;
	$new_users = new user;
	// get id for each tender quote selected
	if ($params['check']) {
		$keys = array_keys($params['check']);
	} //get id for each tender quote displayed
	elseif ($params['info']) {
		$i = 0;
		foreach($params['info']['brand'] as $key => $params_info) {
			$keys[$i] = $key;
			$i++;
		} 
	}	
   	// get info for each tender quote selected or displayed
    $i = 0;
    foreach($keys as $quoteid) {
		//check if editable
		$editable = false; 
		if($user['classification'] == "3") {
		 	$editable = true;
		} else{
			if($user['classification'] == "2") {
				if($user['permission'] == "1") {
					// limit to quotes of own tenders
					$params['usersid'] = $user['id'];
				} elseif($user['permission'] == "2") {
					// limit to quotes of the branch tenders
					$params['branchid'] = $user['branch'];
				}
			} elseif($user['classification'] == "1") {
				// limit to quotes of the suppliers organisation
				$params['supplierid'] = $user['organisation'];	
			}
			$editable = false;			
		} 
		$params['id'] = $quoteid;
		$xml_params['tenderquoteinfo'][$i] = $new_update->get_quote_profile($params,$cfg,$conn);
		$xml_params['tenderquoteinfo'][$i]['editable'] = $editable;
		if ($editable) {  
			$xml_params['editable'] = "1";
		}		
		$i++;
    }    
    //if submitting changes
    if ($params['info']) {
   		if($params['info']['brand']) {
	   		$i = 0;
			foreach($params['info']['brand'] as $key => $params_info) {
		    	$tenderquote[$i]['id'] = $key;
	  			$tenderquote[$i]['brand'] = $params_info;
				$i++;   		
			}
   		}
		if($params['info']['model']) {
			$i = 0;
			foreach($params['info']['model'] as $params_info) {
				$tenderquote[$i]['model'] = $params_info;
				$i++;		
			}
		}
		if($params['info']['description']) {
			$i = 0;	
			foreach($params['info']['description'] as $params_info) {		
				$tenderquote[$i]['description'] = $params_info;
				$i++;		
			}
		}
		if($params['info']['price']) {
			$i = 0;
			foreach($params['info']['price'] as $params_info) {		
				$tenderquote[$i]['price'] = $params_info;
				$i++;		
			}
		}
		if($params['info']['stock']) {
			$i = 0;			
			foreach($params['info']['stock'] as $params_info) {		
				$tenderquote[$i]['stock'] = $params_info;
				$i++;
			}
		}
		if($params['info']['date']) {
			$i = 0;
			foreach($params['info']['date'] as $params_info) {		
				$tenderquote[$i]['valid_until'] = $params_info;
				$i++;
			}
		}
		if($params['info']['classification']) {
			$i = 0;	
			foreach($params['info']['classification'] as $params_info) {		
				$tenderquote[$i]['classification'] = $params_info;
				$i++;
			}
		}
		if($params['info']['delete']) {
			$i = 0;	
			foreach($params['info']['delete'] as $params_info) {		
				$tenderquote[$i]['delete'] = $params_info;
				$i++;
			}
		}
 		if($params['info']['notify']) {
	 		$i = 0;	
			foreach($params['info']['notify'] as $params_info) {		
				$tenderquote[$i]['notify'] = $params_info;
				$i++;
			}
 		}
 		if($params['info']['message']) {
			$i = 0;	
			foreach($params['info']['message'] as $params_info) {
				$tenderquote[$i]['message'] = $params_info;
				$i++;
			}  		
 		}
		$i = 0;
	    foreach($tenderquote as $quote_info) {
			// update organisation info 
			// check permissions
			if (!$xml_params['tenderquoteinfo'][$i]['editable']) {
				// Insufficient authority 
				$params['error'][0] = "1067";
				$errors = array_merge($errors, $params['error']);
				$i++;
			} 
			// check tender status
			elseif($xml_params['tenderquoteinfo'][$i]['status'] != "2" && $xml_params['tenderquoteinfo'][$i]['status'] != "4") {
				// Tender has incorrect status
				$params['error'][0] = "304";
				$errors = array_merge($errors, $params['error']);
				$i++;
			}
			// update tender time
			else {
				if($quote_info['brand']) {
					$info['update']['brand'] = $quote_info['brand'];
				}
				if($quote_info['model']) {
					$info['update']['model'] = $quote_info['model'];
				}
				if($quote_info['stock']) {
					$info['update']['stock'] = $quote_info['stock'];
				}
				if($quote_info['description']) {
					$info['update']['description'] = $quote_info['description'];
				}
				if($quote_info['price']) {
					$info['update']['price'] = $quote_info['price'];
				}
				if($quote_info['valid_until']) {
					$info['update']['valid_until'] = $quote_info['valid_until'];
				}
				// adding a late quote
				if($quote_info['classification']) {
					$info['update']['classification'] = $quote_info['classification'];
					$info['update']['error'] = "";
					$info['update']['status'] = "4";
				}
				$info['where'] = " id = ".$quote_info['id']." ";
				if(!empty($info['update']) && $new_update->update_tender_quote($info['update'],$info['where'],$cfg,$conn)) {
					$xml_params['updated'] = "1";					
					if($xml_params['tenderquoteinfo'][$i]['status'] == "4" || $info['update']['status'] == "4") {
						$new_update->calculate_position($xml_params['tenderquoteinfo'][$i]['tenderitemid'],$cfg,$conn);
					}
				}
				if($quote_info['delete']){
					unset($info);
					$info['update']['status'] = "0";
					$info['update']['error'] = "Deleted (".$xml_params['tenderquoteinfo'][$i]['error'].")";
					$info['where'] = "id = ".$quote_info['id']." ";
					$new_update->update_tender_quote($info['update'],$info['where'],$cfg,$conn);
				}
				// get tender info again
				$params['id'] = $quote_info['id'];
				$editable = $xml_params['tenderquoteinfo'][$i]['editable'];
				$xml_params['tenderquoteinfo'][$i] = $new_update->get_quote_profile($params,$cfg,$conn);
				$xml_params['tenderquoteinfo'][$i]['editable'] = $editable;
				$xml_params['tenderquoteinfo'][$i]['updated'] = $xml_params['updated'];
				if ($editable) {  
					$xml_params['editable'] = "1";
				}
				if($quote_info['info']['notify']){
					unset($sinfo);
					$id['id'] = $user['id'];
					if($extender =  $new_users->get_profile($id,$cfg,$conn)) {
						$id['id'] = $xml_params['tenderquoteinfo'][$i]['usersid'];
						$parties[] = $new_users->get_profile($id,$cfg,$conn);
						$minfo['template'] = "procure_quote_change";
						$minfo['message'] = $quote_info['message'];
						$minfo['requote'] = $quote_info['delete'];
						$new_update->notify_parties($parties,$xml_params['tenderquoteinfo'][$i],$extender,$cfg,$conn,$minfo);
					}
				}
				// generate xml
				if(!empty($new_users->error)) {
					$errors = array_merge($errors,$new_users->error);
				}
				if(!empty($new_update->error)) {
					$errors = array_merge($errors,$new_update->error);
				}
	            $i++;	
			}
	    }		
    }
}
// generate xml
$xml = $new_xml->xml_generator("procure","selected_quote_profile",$errors,$xml_params,$user,$cfg);
?>
