<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Show purchase order
* @package TenderSystem
* @subpackage procure
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = "all";
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	require($cfg['file'].'modules/procure/class/procure.class.php');
	require($cfg['file'].'modules/procure/class/procure_update.class.php');
	if(!$params['searchinfo']['display']) {
		$params['searchinfo']['display'] = "0";
	}
	if($user['classification'] == "2") {
		if($user['permission'] == "1") {
			// limit to purchase_orders of own tenders
			$params['usersid'] = $user['id'];
		} elseif($user['permission'] == "2") {
			// limit to purchase_orders of the branch tenders
			$params['branchid'] = $user['branch'];
		}
	} elseif($user['classification'] == "1") {
		// limit to purchase_orders of suppliers organisation
		$params['supplierid'] = $user['organisation'];	
	}
	// instantiate object
	$new_update = new procure_update;
	// get organisations
	$xml_params['purchase_order'] = $new_update->search_purchase_order_info($params,$cfg,$conn);
	$xml_params['display'] = $params['searchinfo']['display'];
	$xml_params['tenderid'] = $params['searchinfo']['tenderid'];
	$xml_params['tenderitemid'] = $params['searchinfo']['tenderitemid'];
	$xml_params['id'] = $params['searchinfo']['purchaseorderid'];
	if(count($xml_params['purchase_order']) == $cfg['procure']['tenderadmin']['log'] ) {
		$xml_params['more'] = "1";
	}
	// generate xml
	$xml = $new_xml->xml_generator( "procure", "show_purchase_order",$new_report->error,$xml_params,$user,$cfg);
}

?>