<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appeasubscriberr in the distribution.                  |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Procure approve class
* @package TenderSystem
* @subpackage procure
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class procure_approve extends procure {
	// set paramaters
	var $user;
	var $tender;
	var $requester;
	var $deliver;
	var $supplier;
	var $agent;
	var $response;
	var $error;
	
		/**
	 * Search for tenders that need approval
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders or FALSE on error
	 */
	function get_approval_tender_count($classification,$cfg,$conn) {
		$sqlstr = "SELECT COUNT(~tender.id) ";
		// FROM
		$sqlstr.= "FROM ~tender, ~area, ~users, ~organisation ";
		// WHERE
		$sqlstr.= "WHERE ~tender.area = ~area.id ";
		$sqlstr.= "AND ~tender.user_id = ~users.id ";
		$sqlstr.= "AND ~users.organisation = ~organisation.id ";
		$sqlstr.= "AND ~tender.status = '1' ";
		$sqlstr.= "AND ~tender.classification = '".$classification."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	/**
	 * Search for tenders that need approval
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders or FALSE on error
	 */
	function search_approve_tender($params,$classification,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT ~tender.id AS tenderid, ~tender.rfq_number, ~tender.rfq_reference, ";
		$sqlstr.= "~tender.created_date, ~tender.created_time, ~tender.status, ";
		$sqlstr.= "~area.name AS areaname, ~area.id AS areaid, ";
		$sqlstr.= "~area_state.name AS statename, ~area.id AS stateid, ";
		$sqlstr.= "~organisation.id AS organisation, ";
		$sqlstr.= "~tender.close_date, ~tender.close_time, ";
		$sqlstr.= "~users.name, ~users.surname, ~users.id AS usersid, ";
		$sqlstr.= "~users.email, ";
		$sqlstr.= "~organisation.name AS organisationname, ~organisation.id AS organisationid ";
		// FROM
		$sqlstr.= "FROM ~tender, ~area, ~users, ~organisation, ~area_state ";
		// WHERE
		$sqlstr.= "WHERE ~tender.rfq_number LIKE '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND ~area.state = ~area_state.id ";
		$sqlstr.= "AND ~tender.user_id = ~users.id ";
		$sqlstr.= "AND ~users.organisation = ~organisation.id ";
		$sqlstr.= "AND ~tender.status = '1' ";
		$sqlstr.= "AND ~tender.classification = '".$classification."' ";
		if($this->tender['searchinfo']['tenderid']) {
			$sqlstr.= "AND ~tender.id = ".$this->tender['searchinfo']['tenderid']." ";
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~area.id = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['stateid']) {
			$sqlstr.= "AND ~area.state = ".$this->tender['searchinfo']['stateid']." ";
		}
		// ORDER BY
		$sqlstr.= " ORDER BY ~tender.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		return $all;
	}
	
	/**
	 * Search for tenders items need approval
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders or FALSE on error
	 */
	function search_approve_tender_item($tender_id,$cfg,$conn) {
		// SELECT
		$sqlstr = "SELECT ~tender_item.id, ~tender_item.brand, ~tender_item.model, ";
		$sqlstr.= "~tender_item.description, ~tender_item.quote, ~tender_item.budget, ";
		$sqlstr.= "~tender_item.classification, ";
		$sqlstr.= "~category_sub.name AS category_subname, ~category.name AS categoryname ";
		// FROM
		$sqlstr.= "FROM ~tender_item, ~category_sub, ~category ";
		// WHERE
		$sqlstr.= "WHERE ~tender_item.status = '1' ";
		$sqlstr.= "AND ~tender_item.category_sub = ~category_sub.id ";
		$sqlstr.= "AND ~category_sub.category = ~category.id ";
		if($tender_id) {
			$sqlstr.= "AND ~tender_item.tender = '".$tender_id."' ";
		}
		// ORDER BY
		$sqlstr.= " ORDER BY ~tender_item.classification ASC, ~tender_item.category_sub ASC, ~tender_item.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// response
		return $all;
	}
	
	/**
	 * Get the user profile of the tender requestor
	 *
	 * @param integer tender The tender ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param boolean user info success  or FALSE on error  
	 */
	function get_tender_requestor($tender,$cfg,$conn) {
		$sqlstr = "SELECT ~users.id "; 
		// FROM
		$sqlstr.= "FROM ~tender, ~users ";
		// WHERE
		$sqlstr.= "WHERE ~tender.created_by = ~users.id ";
		$sqlstr.= "AND ~tender.id = ".$tender;
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		$new_user = new user;
		return $new_user->get_profile($one,$cfg,$conn);	
	}
	
	/**
	 * Get the user profile of the tender user
	 *
	 * @param integer tender The tender ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param boolean user info success or FALSE on error  
	 */
	function get_tender_subscriber($tender,$cfg,$conn) {
		$sqlstr = "SELECT ~users.id "; 
		// FROM
		$sqlstr.= "FROM ~tender, ~users ";
		// WHERE
		$sqlstr.= "WHERE ~tender.user_id = ~users.id ";
		$sqlstr.= "AND ~tender.id = ".$tender;
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		$new_user = new user;
		return $new_user->get_profile($one,$cfg,$conn);	
	}
}
?>