<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Procure update class
* @package TenderSystem
* @subpackage procure
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class procure_update extends procure {
	// set paramaters
	var $user;
	var $tender;
	var $requester;
	var $deliver;
	var $supplier;
	var $agent;
	var $response;
	var $error;
	
	function procure_update() {
		// allow to work on php5
		$this->error = array();
	}
	
	/**
	 * search for tenders
	 * 
	 * @param integer value The Tender ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT DISTINCT ~tender.id AS tenderid, ~tender.rfq_number, ~tender.rfq_reference, ";
		$sqlstr.= "~tender.status, ~tender.area AS tenderarea, ~tender.transport, ";
		$sqlstr.= "~tender.status, ~tender.created_date, ~tender.created_time, ";
		$sqlstr.= "~tender.close_date, ~tender.close_time, ~tender.classification, ";
		$sqlstr.= "~area.name AS areaname, ";
		$sqlstr.= "~area_state.name AS statename, ";
		$sqlstr.= "~users.id AS usersid, ";
		$sqlstr.= "~organisation.id AS organisationid ";
		// FROM
		$sqlstr.= "FROM ~tender, ~area, ~users, ~organisation, ~area_state ";
		if($this->tender['searchinfo']['supplierid']) {
			$sqlstr.= ", ~area_supplier ";
		}
		// WHERE
		$sqlstr.= "WHERE ~tender.area = ~area.id ";
		$sqlstr.= "AND ~tender.user_id = ~users.id ";
 		$sqlstr.= "AND (~users.status = 1 OR ~users.status = 2) ";
 		$sqlstr.= "AND ~users.organisation = ~organisation.id ";
 		$sqlstr.= "AND ~organisation.status = '1' ";
 		$sqlstr.= "AND ~area.state = ~area_state.id ";
		if($this->tender['searchinfo']['tenderid']) {
			$sqlstr.= "AND ~tender.id = ".$this->tender['searchinfo']['tenderid']." ";
		}
		if(is_array($this->tender['searchinfo']['tenderids'])) {
			if(count($this->tender['searchinfo']['tenderids']) > 1) {
				$sqlstr.= "AND ( ~tender.id = ".$this->tender['searchinfo']['tenderids'][0]." ";
				for($i = 1; $i < count($this->tender['searchinfo']['tenderids']); $i++) {
					$sqlstr.= "OR ~tender.id = ".$this->tender['searchinfo']['tenderids'][$i]." ";
				}
				$sqlstr.= ") ";
			} elseif(count($this->tender['searchinfo']['tenderids']) == 1) {
				$sqlstr.= "AND ~tender.id = ".$this->tender['searchinfo']['tenderids'][0]." ";
			}
		}
		if($this->tender['searchinfo']['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->tender['searchinfo']['usersid']." ";
		}
		if($this->tender['searchinfo']['branchid']) {
			$sqlstr.= "AND ~users.branch = ".$this->tender['searchinfo']['branchid']." ";
		}
		if($this->tender['searchinfo']['organisationid']) {
			$sqlstr.= "AND ~users.organisation = ".$this->tender['searchinfo']['organisationid']." ";
		}
		if($this->tender['searchinfo']['tenderstatus'] || $this->tender['searchinfo']['tenderstatus'] === "0") {
			$sqlstr.= "AND ~tender.status = ".$this->tender['searchinfo']['tenderstatus']." ";
		}
		if($this->tender['searchinfo']['supplierid']) {
			$sqlstr.= "AND ~area_supplier.area =  ~tender.area ";
			$sqlstr.= "AND ~area_supplier.supplier =  ".$this->tender['searchinfo']['supplierid']." ";
		}
		// ORDER BY
		$sqlstr.= "ORDER BY ~tender.close_date DESC, ~tender.close_time DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		// get user info
		$new_users = new user;
		foreach($all as $key => $value) {
			$users_info = $new_users->get_info($value['usersid'],$cfg,$conn);
			$all[$key]['name'] = $users_info['name'];
			$all[$key]['surname'] = $users_info['surname'];
			$all[$key]['phone_prefix'] = $users_info['phone_prefix'];
			$all[$key]['email'] = $users_info['email'];
			$all[$key]['phone_work'] = $users_info['phone_work'];
		}
		// get organisation info
		$new_organisation = new organisation;
		foreach($all as $key => $value) {
			$organisation_info = $new_organisation->get_info($value['organisationid'],$cfg,$conn);
			$all[$key]['organisationname'] = $organisation_info['name'];
		}
		return $all;
	}


	/**
	 * search for tender request
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_tender_request($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT DISTINCT ~tender_request.user_id as usersid ";
		// FROM
		$sqlstr.= "FROM ~tender_request, ~tender, ~tender_item ";
		// WHERE
		$sqlstr.= "WHERE ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_request.status = 1 ";
		if($this->tender['searchinfo']['tenderstatus']) {
			$sqlstr.= "AND ~tender.status = '".$this->tender['searchinfo']['tenderstatus']."' ";
			$sqlstr.= "AND ~tender_item.status = '".$this->tender['searchinfo']['tenderstatus']."' ";
		}
		if($this->tender['searchinfo']['tenderid']) {
			$sqlstr.= "AND ~tender.id = '".$this->tender['searchinfo']['tenderid']."' ";
		}
		if($this->tender['searchinfo']['tenderitemid']) {
			$sqlstr.= "AND ~tender_item.id = '".$this->tender['searchinfo']['tenderitemid']."' ";
		}
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// response
		return $all;
	}
	
	/**
	 * search for tender request
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_no_response_tender_request($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT DISTINCT ~tender_request.user_id as usersid, ~tender_quote.id ";
		// FROM
		$sqlstr.= "FROM ~tender_request LEFT JOIN ~tender_quote ";
		$sqlstr.= "                     ON ~tender_quote.status != '0' ";
		$sqlstr.= "                     AND ~tender_quote.tender_item = ~tender_request.tender_item ";
		$sqlstr.= "                     AND ~tender_quote.user_id = ~tender_request.user_id ";
		$sqlstr.= ", ~tender, ~tender_item ";
		// WHERE
		$sqlstr.= "WHERE ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_request.status = 1 ";
		$sqlstr.= "AND ~tender_quote.id IS NULL ";
		if($this->tender['searchinfo']['tenderstatus']) {
			$sqlstr.= "AND ~tender.status = '".$this->tender['searchinfo']['tenderstatus']."' ";
			$sqlstr.= "AND ~tender_item.status = '".$this->tender['searchinfo']['tenderstatus']."' ";
		}
		if($this->tender['searchinfo']['tenderid']) {
			$sqlstr.= "AND ~tender.id = '".$this->tender['searchinfo']['tenderid']."' ";
		}
		if($this->tender['searchinfo']['tenderitemid']) {
			$sqlstr.= "AND ~tender_item.id = '".$this->tender['searchinfo']['tenderitemid']."' ";
		}
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// response
		return $all;
	}

	/**
	 * search for tender quote information
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_quote_info($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT ~tender_quote.id, ~tender_quote.method, ~tender_quote.status, ";
		$sqlstr.= "~tender_quote.price, ~tender_quote.brand, ~tender_quote.model, ";
		$sqlstr.= "~tender_quote.description, ~tender.rfq_number, ~tender_quote.price,  ";
		$sqlstr.= "~tender_quote.created_date, ~tender_quote.created_time, ~tender_quote.error,";
		$sqlstr.= "~tender_quote.classification, ~tender_quote.valid_until, ~tender_quote.quote_message, ";
		$sqlstr.= "~tender_quote.quote_position,  ";
		$sqlstr.= "~tender.id AS tenderid, ~tender.classification AS tenderclassification, ~tender.close_date, ";
		$sqlstr.= "~tender.close_time,  ";
		$sqlstr.= "~tender_item.id AS tenderitemid, ~tender_item.classification AS itemclassification, ";
		$sqlstr.= "~tender_quote.user_id AS agentid,  ";
		$sqlstr.= "~organisation.id as organisationid ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_quote, ~users request, ~users subscriber, ~organisation ";
		// WHERE
		$sqlstr.= "WHERE ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender.user_id = request.id ";
		$sqlstr.= "AND ~tender_quote.user_id = subscriber.id ";
		$sqlstr.= "AND ~organisation.id = subscriber.organisation ";
		if($this->tender['searchinfo']['tenderquotestatus'] || $this->tender['searchinfo']['tenderquotestatus'] === "0") {
			$sqlstr.= "AND ~tender_quote.status = '".$this->tender['searchinfo']['tenderquotestatus']."' ";
		}
		if($this->tender['searchinfo']['tenderid']) {
			$sqlstr.= "AND ~tender.id = '".$this->tender['searchinfo']['tenderid']."' ";
		}
		if($this->tender['searchinfo']['tenderitemid']) {
			$sqlstr.= "AND ~tender_item.id = '".$this->tender['searchinfo']['tenderitemid']."' ";
		}
		if($this->tender['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->tender['usersid']." ";
		}
		if($this->tender['branchid']) {
			$sqlstr.= "AND request.branch = ".$this->tender['branchid']." ";
		}
		if($this->tender['userorg']) {
			$sqlstr.= "AND request.organisation = ".$this->tender['userorg']." ";
		}
		if($this->tender['supplierid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->tender['supplierid']." ";
		}
		// ORDER BY
		$sqlstr.= "ORDER BY ~tender_quote.id DESC, ~tender_item.id DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$result = $conn->SelectLimit($sqlstr,$cfg['procure']['tenderadmin']['log'] ,$cfg['procure']['tenderadmin']['log'] *$params['searchinfo']['display']);
		if($result) {
			$all = $result->GetRows();
		}
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		if (is_array($all) && count($all) > 0) {
			$new_users = new user;
			// wordwrap description
			foreach($all as $key => $value) {
				$users_info = $new_users->get_info($value['agentid'],$cfg,$conn);
				$all[$key]['name'] = $users_info['name'];
				$all[$key]['surname'] = $users_info['surname'];
				$all[$key]['description'] = wordwrap($value['description']);
			}
		}
		$new_database->convertTime($all,$cfg);
		return $all;
	}


	/**
	 * search for tender item information
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_tender_item($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT DISTINCT ~tender_item.id, ~tender_item.classification, ~tender_item.brand, ";
		$sqlstr.= "~tender_item.model, ~tender_item.description, ~tender_item.tender, ";
		$sqlstr.= "~category_sub.name AS category_subname,   ";
		$sqlstr.= "~tender_item.quote, ~tender_item.budget, ~tender_item.status ";
		// FROM
		$sqlstr.= "FROM ~tender_item, ~category_sub, ~tender_request ";
		// WHERE
		$sqlstr.= "WHERE ~tender_item.category_sub = ~category_sub.id ";
		$sqlstr.= "AND ~category_sub.status = '1' ";
		$sqlstr.= "AND ~tender_item.id = ~tender_request.tender_item ";
		$sqlstr.= "AND ~tender_request.status = '1' ";
		if($this->tender['searchinfo']['tenderstatus']) {
			$sqlstr.= "AND ~tender_item.status = '".$this->tender['searchinfo']['tenderstatus']."' ";
		}
		if($this->tender['searchinfo']['tenderid']) {
			$sqlstr.= "AND ~tender_item.tender = '".$this->tender['searchinfo']['tenderid']."' ";
		}
		if($this->tender['searchinfo']['tenderitemid']) {
			$sqlstr.= "AND ~tender_item.id = '".$this->tender['searchinfo']['tenderitemid']."' ";
		}
		if($this->tender['searchinfo']['agentid']) {
			$sqlstr.= "AND ~tender_request.user_id = '".$this->tender['searchinfo']['agentid']."' ";
		}
		if($this->tender['searchinfo']['usersid']) {
			$sqlstr.= "AND ~tender_request.user_id = '".$this->tender['searchinfo']['agentid']."' ";
		}
		// ORDER BY
		$sqlstr.= "ORDER BY ~tender_item.tender ASC, ~tender_item.classification ASC, ~tender_item.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $all;
	}
	
	/**
	 * get tender profile
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_profile($params,$cfg,$conn){
		if(is_numeric($params)) {
			$this->tender['id'] = $params;
		} else {
			$this->tender = $params;
		}
		// Check if main parameters exist 
		if (!$this->tender['id']){
			// missing tender id
			$this->error[] = "259";
		}
		// errors 
		if(!empty($this->error)){
			// error in tender class 
			$this->error[] = "315";
			return FALSE;
		}
		$sqlstr = "SELECT ~tender.id, ~tender.rfq_number, ~tender.rfq_reference,";
		$sqlstr.= "~tender.classification, ~tender.attachment, ~tender.error,";
		$sqlstr.= "~tender.close_date, ~tender.close_time, ~tender.created_date, ";
		$sqlstr.= "~tender.created_by, ~tender.created_time, ~tender.user_id, ";
		$sqlstr.= "~tender.transport, ~tender.status, ";
		$sqlstr.= "~area.name AS areaname,";
		$sqlstr.= "state.name AS statename, ";
		$sqlstr.= "COUNT(DISTINCT ~purchase_order.id) AS order_count,  ";
		$sqlstr.= "COUNT(DISTINCT ~tender_quote.id) AS quote_count, ";
		$sqlstr.= "COUNT(DISTINCT ~tender_item.id) AS item_count ";
		$sqlstr.= "FROM ((~tender LEFT JOIN ~tender_item ";
		$sqlstr.= " 	ON ~tender_item.tender = ~tender.id AND ~tender_item.status != 0) LEFT JOIN ~tender_quote ";
		$sqlstr.= "		ON ~tender_quote.tender_item = ~tender_item.id AND ~tender_quote.status != 0) LEFT JOIN ~purchase_order ";
		$sqlstr.= " 	ON ~tender.id = ~purchase_order.tender AND ~purchase_order.status = '1', ";
		$sqlstr.= "~area, ~area_state state ";
		$sqlstr.= "WHERE ~tender.id = '".$this->tender['id']."' ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND ~area.state = state.id ";
		$sqlstr.= "AND ~area.state = state.id ";
		$sqlstr.= "GROUP BY ~tender.id, ~tender.rfq_number, ~tender.rfq_reference,";
		$sqlstr.= "~tender.classification, ~tender.attachment, ~tender.error,";
		$sqlstr.= "~tender.close_date, ~tender.close_time, ~tender.created_date, ";
		$sqlstr.= "~tender.created_by, ~tender.created_time, ~tender.user_id, ";
		$sqlstr.= "~tender.transport, ~tender.status, ";
		$sqlstr.= "~area.name, state.name ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$row = $conn->GetRow($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg()." SQL:".$sqlstr;
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} elseif(!$row) {
			// tender does not exist
			$this->error[] = "225";
			// error in tender class 
			$this->error[] = "315";
			// response
			return FALSE;
		}
		$new_database->convertSingleTime($row,$cfg);
		// get users info
		$new_user = new user;
		// get the subscriber info
		$subscriber = $new_user->get_info($row['user_id'],$cfg,$conn);
		if(!$subscriber) {
			if(!empty($new_user->error)) {
				$this->error = array_merge($this->error,$new_user->error);
			}
			// Error in Organisation class 
			$this->error[] = "315";
			// response
			return FALSE;
		}
		$row['usersid'] = $subscriber['id'];
		$row['name'] = $subscriber['name'];
		$row['surname'] = $subscriber['surname'];
		$row['email'] = $subscriber['email'];
		$row['organisation'] = $subscriber['organisation'];
		// get the creators info
		$creator = $new_user->get_info($row['created_by'],$cfg,$conn);
		if(!$creator) {
			if(!empty($new_user->error)) {
				$this->error = array_merge($this->error,$new_user->error);
			}
			// Error in report class 
			$this->error[] = "315";
			// response
			return FALSE;
		}
		$row['creatorid'] = $creator['id'];
		$row['creatorsurname'] = $creator['name'];
		$row['creatorname'] = $creator['surname'];
		// get Client Information
		$sqlstr = "SELECT title, id_number, surname, ";
		$sqlstr.= "phone_prefix, phone_work, phone_fax, ";
		$sqlstr.= "phone_mobile, email, address ";
		$sqlstr.= "FROM ~tender_client ";
		$sqlstr.= "WHERE ~tender_client.tender = '".$this->tender['id']."' ";
		$sqlstr.= "ORDER BY  ~tender_client.id DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$extra_info = $conn->GetRow($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
		}
		foreach($extra_info as $key => $value) {
			$row['client_'.$key] = $value;
		}
		// get all the invitations
		$sqlstr = "SELECT DISTINCT ~users.id AS usersid, ~users.organisation AS supplierid, ";
		$sqlstr.= "~tender_request.method, ~tender_request.request_message ";
		$sqlstr.= "FROM ~users, ~tender_request, ~tender_item   ";
		$sqlstr.= "WHERE ~tender_item.tender = '".$this->tender['id']."' ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.user_id = ~users.id ";
		$sqlstr.= "AND (~users.preference = 'n' OR ~users.preference = 'm' OR  ~tender_request.request_message IS NOT NULL)";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$agents = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} else {
			if(is_array($agents)) {
				$new_organisation = new organisation;
				foreach ($agents as $key => $value) {
					$users_info = $new_user->get_info($value['usersid'],$cfg,$conn);
					$org_info = $new_organisation->get_info($value['supplierid'],$cfg,$conn);
					$users_info['suppliername'] = $org_info['name'];
					$users_info['method'] = $value['method'];
					$users_info['request_message'] = $value['request_message'];
					$row['agent'][] = $users_info;
				}
			}
		}
		// return info
		return $row;
	}

	/**
	 * get tender item profile
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_item_profile($params,$cfg,$conn){
		$this->tender = $params;
		// Check if main parameters exist 
		if (!$this->tender['id']){
			// missing tender id
			$this->error[] = "259";
		}
		// errors 
		if(!empty($this->error)){
			return FALSE;
		}
		$sqlstr = "SELECT ~tender_item.id,  ~tender_item.classification, ~tender_item.status,  ";
		$sqlstr.= "~tender_item.brand, ~tender_item.model, ~tender_item.description, ";
		$sqlstr.= "~tender_item.budget, ~tender_item.quote, ~tender_item.transaction_fee, ";
		$sqlstr.= "~tender_item.error, ";
		$sqlstr.= "~tender.id AS tenderid, ~tender.rfq_number, ~tender.rfq_reference, ";
		$sqlstr.= "~tender.user_id AS usersid, ~tender.close_date, ~tender.close_time, ";
		$sqlstr.= "~tender.status AS tenderstatus, ~tender.classification AS tenderclassification,";
		$sqlstr.= "~area.name AS areaname, ";
		$sqlstr.= "state.name AS statename, ";
		$sqlstr.= "~category.name AS categoryname,";
		$sqlstr.= "~category_sub.name AS category_subname, ";
		$sqlstr.= "~tender_item_complete.status AS complete_status, ~tender_item_complete.tender_quote, ~tender_item_complete.created_date AS complete_date, ";
		$sqlstr.= "~tender_item_complete.created_time AS complete_time, ~tender_item_complete.purchase_order, ";
		$sqlstr.= "COUNT(~tender_quote.id) AS received, ";
		$sqlstr.= "COUNT(~tender_request.id) AS sent ";
		$sqlstr.= "FROM ~tender, ~area, ~area_state state,";
		$sqlstr.= "		((~tender_item LEFT JOIN";
		$sqlstr.= "		~tender_item_complete ";
		$sqlstr.= " 	ON ~tender_item_complete.tender_item = ~tender_item.id) LEFT JOIN ";
		$sqlstr.= "		~tender_request ON ~tender_item.id = ~tender_request.tender_item) LEFT JOIN ";
		$sqlstr.= "		~tender_quote ON ~tender_quote.tender_item = ~tender_item.id AND ~tender_quote.status > 0, ";
		$sqlstr.= "		~category, ~category_sub, ~users ";
		$sqlstr.= "WHERE ~tender_item.id = '".$this->tender['id']."' ";
		$sqlstr.= "AND ~tender.id = ~tender_item.tender ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND ~area.state = state.id ";
		$sqlstr.= "AND ~tender_item.category_sub = ~category_sub.id ";
		$sqlstr.= "AND ~category_sub.category = ~category.id ";
		$sqlstr.= "AND ~tender.user_id = ~users.id ";
		$sqlstr.= "GROUP BY ~tender_item.id,  ~tender_item.classification, ~tender_item.status,  ";
		$sqlstr.= "~tender_item.brand, ~tender_item.model, ~tender_item.description, ";
		$sqlstr.= "~tender_item.budget, ~tender_item.quote, ~tender_item.transaction_fee,";
		$sqlstr.= "~tender_item.error, ~tender.id, ~tender.rfq_number, ";
		$sqlstr.= "~tender.rfq_reference, ~tender.user_id, ~tender.close_date, ";
		$sqlstr.= "~tender.close_time, ~tender.status, ~area.name, ~tender.classification, "; 
		$sqlstr.= "state.name, ~category.name, ~category_sub.name, ";
		$sqlstr.= "~tender_item_complete.status, ~tender_item_complete.tender_quote, ~tender_item_complete.created_date, ";
		$sqlstr.= "~tender_item_complete.created_time, ~tender_item_complete.purchase_order ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$row = $conn->GetRow($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} elseif(!$row) {
			// tender does not exist
			$this->error[] = "225";
			// response
			return FALSE;
		} 
		$new_database->convertSingleTime($row,$cfg);
		$new_users = new user;
		$new_organisation = new organisation;
		$users_info = $new_users->get_info($row['usersid'],$cfg,$conn);
		$row['name'] = $users_info['name'];
		$row['surname'] = $users_info['surname'];
		$row['email'] = $users_info['email'];
		// get all the invitations
		$sqlstr = "SELECT DISTINCT ~users.id AS usersid, ~users.organisation AS supplierid, ";
		$sqlstr.= "~tender_request.method, ~tender_request.request_message ";
		$sqlstr.= "FROM ~users, ~tender_request   ";
		$sqlstr.= "WHERE ~tender_request.tender_item = '".$this->tender['id']."' ";
		$sqlstr.= "AND ~tender_request.user_id = ~users.id ";
		$sqlstr.= "AND (~users.preference = 'n' OR ~users.preference = 'm' OR  ~tender_request.request_message IS NOT NULL)";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$agents = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} else {
			if(is_array($agents)) {
				foreach ($agents as $key => $value) {
					$users_info = $new_users->get_info($value['usersid'],$cfg,$conn);
					$org_info = $new_organisation->get_info($value['supplierid'],$cfg,$conn);
					$users_info['suppliername'] = $org_info['name'];
					$users_info['method'] = $value['method'];
					$users_info['request_message'] = $value['request_message'];
					$row['agent'][] = $users_info;
				}
			}
		}
		if($row['status'] == "6") {
			$sqlstr = "SELECT ~tender_item_complete.user_id AS forid,  ~tender_item_complete.reason, ~tender_item_complete.status AS complete_status, ";
			$sqlstr.= "~tender_item_complete.created_by AS byid, ~tender_item_complete.cash, ~tender_item_complete.nontender,";
			$sqlstr.= "~tender_quote.quote_position, ";
			$sqlstr.= "~purchase_order.authentication  ";
			$sqlstr.= "FROM ~tender_item, ";
			$sqlstr.= "		(~tender_item_complete LEFT JOIN ";
			$sqlstr.= "		~purchase_order ON ";
			$sqlstr.= "		~tender_item_complete.purchase_order = ~purchase_order.id) LEFT JOIN ";
			$sqlstr.= "		~tender_quote ON ";
			$sqlstr.= "		~tender_item_complete.tender_quote = ~tender_quote.tender_item ";
			$sqlstr.= "WHERE ~tender_item.id = '".$this->tender['id']."' ";
			$sqlstr.= "AND ~tender_item.id = ~tender_item_complete.tender_item ";
			$new_database = new database;
			$new_database->parse_sql($sqlstr,$cfg);
			$extra_info = $conn->GetRow($sqlstr,"",TRUE);
			if($conn->ErrorMsg()) {
				// instantiate the error class and log
				$new_error = new error;
				$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
				$new_error->log("SQL","critical",$error_text,$cfg);
				// error occurred while querying into database 
				$this->error[] = "1065";
				// response
				return FALSE;
			} 
			// get user info
			$users_info = $new_users->get_info($extra_info['forid'],$cfg,$conn);
			$row['forname'] = $users_info['name'];
			$row['forsurname'] = $users_info['surname'];
			$users_info = $new_users->get_info($extra_info['byid'],$cfg,$conn);
			$row['byname'] = $users_info['name'];
			$row['bysurname'] = $users_info['surname'];
			foreach ($extra_info as $key => $value) {
				$row[$key] = $value;
			}
		}
		return $row;
	}

	/**
	 * get tender quote profile
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_quote_profile($params,$cfg,$conn){
		$this->tender = $params;
		// Check if main parameters exist 
		if (!$this->tender['id']){
			// missing tender id
			$this->error[] = "259";
		}
		// errors 
		if(!empty($this->error)){
			// error in tender class 
			$this->error[] = "315";
			return FALSE;
		}
		$sqlstr = "SELECT ~tender_quote.id, ~tender_quote.status, ~tender_quote.method, ";
		$sqlstr.= "~tender_quote.brand, ~tender_quote.model, ~tender_quote.description, ";
		$sqlstr.= "~tender_quote.price, ~tender_quote.stock, ~tender_quote.valid_until, ";
		$sqlstr.= "~tender_quote.created_date, ~tender_quote.created_time, ~tender_quote.quote_position, ";
		$sqlstr.= "~tender_quote.user_id AS usersid, ~tender.close_date, ~tender.close_time,";
		$sqlstr.= "~tender_quote.error, ~tender_quote.classification AS quoteclass, ";
		$sqlstr.= "~tender_item.id AS tenderitemid, ~tender_item.classification, ~tender_item.status AS itemstatus, ";
		$sqlstr.= "~tender_item.brand AS itembrand, ~tender_item.model AS itemmodel, ~tender_item.description AS itemdescription, ";
		$sqlstr.= "~tender_item_complete.status AS complete_status, ~tender_item_complete.tender_quote, ";
		$sqlstr.= "~tender_item_complete.created_date AS complete_date, ~tender_item_complete.created_time AS complete_time, ";
		$sqlstr.= "~tender.id AS tenderid, ~tender.rfq_number, ~tender.rfq_reference,";
		$sqlstr.= "~tender.status AS tenderstatus, ~tender.classification AS tenderclassification, ";
		$sqlstr.= "~area.name as areaname, ";
		$sqlstr.= "state.name AS statename,  ";
		$sqlstr.= "~category.name AS categoryname, ";
		$sqlstr.= "~category_sub.name AS category_subname, ";
		$sqlstr.= "~tender.created_by AS creatorid ";
		$sqlstr.= "FROM ~tender_quote, ~tender, ~area, ";
		$sqlstr.= "~tender_item LEFT JOIN ~tender_item_complete ";
		$sqlstr.= "		ON ~tender_item_complete.tender_item = ~tender_item.id ";
		$sqlstr.= "		AND ~tender_item_complete.status != '0', ";
		$sqlstr.= "~area_state state, ~category, ~category_sub, ";
		$sqlstr.= "~users agent, ~users creator, ~users request ";
		$sqlstr.= "WHERE ~tender_quote.id = '".$this->tender['id']."' ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender.id = ~tender_item.tender ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND ~area.state = state.id ";
		$sqlstr.= "AND ~tender_item.category_sub = ~category_sub.id ";
		$sqlstr.= "AND ~category_sub.category = ~category.id ";
		$sqlstr.= "AND ~tender_quote.user_id = agent.id ";
		$sqlstr.= "AND ~tender.user_id = request.id ";
		if($this->tender['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->tender['usersid']." ";
		}
		if($this->tender['branchid']) {
			$sqlstr.= "AND request.branch = ".$this->tender['branchid']." ";
		}
		if($this->tender['supplierid']) {
			$sqlstr.= "AND agent.organisation = ".$this->tender['supplierid']." ";
		}
		$sqlstr.= "AND (~tender_quote.created_by = creator.id OR ~tender_quote.created_by = '0') ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$row = $conn->GetRow($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} elseif(!$row) {
			// tender does not exist
			$this->error[] = "225";
			// response
			return FALSE;
		}
		$new_database->convertSingleTime($row,$cfg);
		$row['itemdescription'] = wordwrap($row['itemdescription']);
		//get user info
		$new_users = new user;
		$users_info = $new_users->get_info($row['usersid'],$cfg,$conn);
		$row['name'] = $users_info['name'];
		$row['surname'] = $users_info['surname'];
		$row['email'] = $users_info['email'];
		$users_info = $new_users->get_info($row['creatorid'],$cfg,$conn);
		$row['creatorname'] = $users_info['name'];
		$row['creatorsurname'] = $users_info['surname'];
		return $row;
	}

	/**
	 * get purchase order
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_purchase_order_email($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT ~purchase_order.id, ~message_schedule.subject, ~message_schedule.body, ";
		$sqlstr.= "subscriber.id AS usersid, agent.id AS agentid, ~purchase_order.status, ";
		$sqlstr.= "~purchase_order.created_date, ~purchase_order.created_time, ~purchase_order.canceled_reason  ";
		// FROM
		$sqlstr.= "FROM ~purchase_order, ~message_schedule, ~users subscriber, ~users agent ";
		// WHERE
		$sqlstr.= "WHERE ~purchase_order.agent_message = ~message_schedule.id ";
		$sqlstr.= "AND ~purchase_order.user_id = subscriber.id ";
		$sqlstr.= "AND ~purchase_order.agent = agent.id ";
		$sqlstr.= "AND ~purchase_order.authentication = '".$this->tender['authentication']."' ";
		$sqlstr.= "AND ~purchase_order.tender = '".$this->tender['tenderid']."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		// get the first row of SQL results
		$row = $conn->GetRow($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} elseif(!$row) {
			return $row;
		}
		// get subscriber info
		$new_users = new user;
		$users_info = $new_users->get_info($row['usersid'],$cfg,$conn);
		$row['name'] = $users_info['name'];
		$row['surname'] = $users_info['surname'];
		$row['email'] = $users_info['email'];
		// get agent info
		$users_info = $new_users->get_profile($row['agentid'],$cfg,$conn);
		$row['agentname'] = $users_info['name'];
		$row['agentsurname'] = $users_info['surname'];
		$row['suppliername'] = $users_info['organisationname'];
		$row['reason'] = wordwrap($row['canceled_reason']);
		return $row;
	}

	/**
	 * get closure time
	 * 
	 * @param array params time
	 * @param mixed cfg The Config settings of tendersystem
	 *
	 * @param mixed closing time or FALSE on error  
	 */
	function get_closure($params,$cfg) {
		return $this->get_valid_time($params['time'],900,$cfg);
	}

	/**
	 * send notification to users about a change
	 * 
	 * @param array parties the users
	 * @param array tender the tender
	 * @param array extender old tender information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 * @param array info The email information
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function notify_parties($parties,$tender,$extender,$cfg,$conn,$info) {
		foreach($parties as $key => $value) {
			if($value['preference'] == "n" || $value['preference'] == "m") {
				$lang = array();
				$html = $subject = FALSE;
				$this->set_language("",$value['language'],$cfg,$conn);
				require($cfg['file'].'modules/procure/templates/'.$info['template'].'.php');
				// set message paramaters
				$message['reference'] = $tender['rfq_number'];
				$message['classification'] = $info['template'];
				$message['subject'] = $subject;
				$message['body'] = $html;
				$message['name'] = $value['name']." ".$value['surname'];
				$message['email'] = $value['email'];
				// send the email
				$new_message = new message;
				$message_id = $new_message->send_email_message($message,$value['id'],$extender['id'],$cfg,$conn);
				if (!$message_id) {
					// error handling
					$error_text = $this->lang['emailerror'].$value['name']." ".$value['surname']."(".$tender['rfq_number'].") ";
					$error_text.= $this->lang['reason'].": ".$new_message->error_text;
					$this->response['error_text'].= $error_text."&#10;";
				}
			}
		}
	}
	
	function set_language($module,$language,$cfg,$conn) {
		// include the language file
		$lang = array();
		require($cfg['file'].'modules/procure/language/'.$language.'/request.php');
		if($module) {
			require($cfg['file'].'modules/'.$module.'/language/'.$language.'/request.php');
		}
		// set the language
		$this->lang = $lang;
	}
	
	function supplier_exists($id,$cfg,$conn) {
      	// query database to find out if there are suppliers available for the sub category
      	$sqlstr = "SELECT * ";
      	$sqlstr.= "FROM ~organisation ";
		$sqlstr.= "WHERE ~organisation.classification = '1' ";
		$sqlstr.= "AND ~organisation.id = '".$id."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr);
      	if ($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// set the response error
			$this->error[] = "1065";
			// response
			return FALSE;
        }
		return $one;
	}
	
	/**
	 * search for tenders
	 * 
	 * @param integer value The Tender ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_tender_count($class,$status,$user,$cfg,$conn) {
		$sqlstr = "SELECT COUNT(~tender.id) ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users ";
		// WHERE
		$sqlstr.= "WHERE  ~tender.user_id = ~users.id ";
		if($class) {
 			$sqlstr.= "AND ~tender.classification = '".$class."' ";
		}
		if($user['classification'] == "2" && $user['permission'] == "1") {
			$sqlstr.= "AND ~users.id = ".$user['id']." ";
		}
		if($user['classification'] == "2" && $user['permission'] == "2") {
			$sqlstr.= "AND ~users.branch = ".$user['branch']." ";
		}
		if($user['classification'] == "2" && $user['permission'] == "4") {
			$sqlstr.= "AND ~users.organisation = ".$user['organisation']." ";
		}
		if($status) {
			$sqlstr.= "AND ~tender.status = ".$status." ";
		}
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	/**
	 * search for tenders
	 * 
	 * @param integer value The Tender ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_agent_open_request_count($class,$user,$cfg,$conn) {
		$sqlstr = "SELECT COUNT(DISTINCT ~tender.id) ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_request, ~users, ";
		$sqlstr.= "~tender_item ";
		// WHERE
		$sqlstr.= "WHERE  ~tender.id = ~tender_item.tender ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.user_id = ~users.id ";
		if($class) {
 			$sqlstr.= "AND ~tender.classification = '".$class."' ";
		}
		$sqlstr.= "AND ~users.id = ".$user['id']." ";
		$sqlstr.= "AND ~tender.status = 2 ";
		$sqlstr.= "AND ~tender_request.status = 1 ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	/**
	 * search for tenders
	 * 
	 * @param integer value The Tender ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_agent_waiting_request_count($class,$user,$cfg,$conn) {
		$sqlstr = "SELECT COUNT(DISTINCT ~tender.id) ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~users, ";
		$sqlstr.= "~tender_request LEFT JOIN ~tender_quote ";
		$sqlstr.= "             ON ~tender_request.tender_item = ~tender_quote.tender_item ";
		$sqlstr.= "             AND ~tender_request.user_id = ~tender_quote.user_id ";
		$sqlstr.= "             AND ~tender_quote.status != 0 ";
		// WHERE
		$sqlstr.= "WHERE  ~tender.id = ~tender_item.tender ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.user_id = ~users.id ";
		if($class) {
 			$sqlstr.= "AND ~tender.classification = '".$class."' ";
		}
		$sqlstr.= "AND ~users.id = ".$user['id']." ";
		$sqlstr.= "AND ~tender.status = 2 ";
		$sqlstr.= "AND ~tender_request.status = 1 ";
		$sqlstr.= "AND ~tender_quote.id IS NULL ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	/**
	 * search for tenders
	 * 
	 * @param integer value The Tender ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_tender_for_subscriber($class,$searchinfo,$status,$user,$cfg,$conn) {
		if ($searchinfo) {
			$startdate = $searchinfo['startdate']; 
			$enddate = $searchinfo['enddate'];
			if (!$startdate) {
				$startdate = date("Y-m-d",ts_time($cfg) - 10800);		
			}
			if (!$enddate) {
				$enddate = date("Y-m-d");	
			}		
		}
		$sqlstr = "SELECT ~tender.rfq_number, ~tender.rfq_reference, ~tender.transport, ";
		$sqlstr.= "~tender.id AS tenderid, ~tender.close_date, ~tender.close_time, ";
		$sqlstr.= "~tender.created_date, ~tender.created_time, ";
		$sqlstr.= "~users.name, ~users.surname, ~users.id AS usersid, ";
		$sqlstr.= "~area.name AS areaname, ";
		$sqlstr.= "~area_state.name AS statename ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users, ~area, ~area_state ";
		// WHERE
		$sqlstr.= "WHERE  ~tender.user_id = ~users.id ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND ~area.state = ~area_state.id ";
		if ($startdate && $enddate) {
			$sqlstr.= "AND ~tender.created_date >= '".$startdate."' ";
			$sqlstr.= "AND ~tender.created_date <= '".$enddate."' ";	
		}
		if($class) {
 			$sqlstr.= "AND ~tender.classification = '".$class."' ";
		}
		if($user['classification'] == "2" && $user['permission'] == "1") {
			$sqlstr.= "AND ~users.id = ".$user['id']." ";
		} elseif($user['classification'] == "2" && $user['permission'] == "2") {
			$sqlstr.= "AND ~users.branch = ".$user['branch']." ";
		} elseif($user['classification'] == "2" && $user['permission'] == "4") {
			$sqlstr.= "AND ~users.organisation = ".$user['organisation']." ";
		} else {
			$sqlstr.= "AND ~users.id = ".$user['id']." ";
		}
		if($status) {
			$sqlstr.= "AND ~tender.status = '".$status."' ";
		}
		$sqlstr.= "ORDER BY ~tender.close_date ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		$new_database->convertTime($all,$cfg);
		return $all;
	}
	
		/**
	 * Get information about tenders
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders or FALSE on error  
	 */
	function search_tender_count($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT ~tender.id AS tenderid, ~tender.rfq_number, ~tender.rfq_reference, ";
		$sqlstr.= "~tender.transport, ~tender.created_date, ~tender.created_time, ";
		$sqlstr.= "~tender.status, ~tender.close_date, ~tender.close_time, ";
		$sqlstr.= "~tender.classification, ~tender.user_id, ";
		$sqlstr.= "~area.name AS areaname,  ";
		$sqlstr.= "state.name AS statename,  ";
		$sqlstr.= "COUNT(DISTINCT ~tender_item.id) AS tenderitemcount, ";
		$sqlstr.= "COUNT(DISTINCT ~tender_quote.id) AS tenderquotecount ";
		// FROM
		$sqlstr.= "FROM ~tender, ~area, ~area_state state, ";
		$sqlstr.= "~tender_item LEFT JOIN ~tender_quote ";
		$sqlstr.= "             ON ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "             AND ~tender_quote.status != '0' ";
		// WHERE
		$sqlstr.= "WHERE ~tender.area = ~area.id ";
		$sqlstr.= "AND ~tender.id = ~tender_item.tender ";
		$sqlstr.= "AND state.id = ~area.state ";
		if(isset($this->tender['searchinfo']['tenderid'])) {
			$sqlstr.= "AND ~tender.id = ".$this->tender['searchinfo']['tenderid']." ";
		}
		if (isset($this->tender['searchinfo']['tenderids'])) {
			if(is_array($this->tender['searchinfo']['tenderids'])) {
				if(count($this->tender['searchinfo']['tenderids']) > 1) {
					$sqlstr.= "AND ( ~tender.id = ".$this->tender['searchinfo']['tenderids'][0]." ";
					for($i = 1; $i < count($this->tender['searchinfo']['tenderids']); $i++) {
						$sqlstr.= "OR ~tender.id = ".$this->tender['searchinfo']['tenderids'][$i]." ";
					}
					$sqlstr.= ") ";
				} elseif(count($this->tender['searchinfo']['tenderids']) == 1) {
					$sqlstr.= "AND ~tender.id = ".$this->tender['searchinfo']['tenderids'][0]." ";
				}
			}
		}
		if(isset($this->tender['searchinfo']['tenderstatus'])) {
			// removed due to isset $this->tender['searchinfo']['tenderstatus'] === "0"
			$sqlstr.= "AND ~tender.status = ".$this->tender['searchinfo']['tenderstatus']." ";
		}
		// GROUP BY
		$sqlstr.= "GROUP BY ~tender.id, ~tender.rfq_number, ~tender.rfq_reference, ";
		$sqlstr.= "~tender.status, ~tender.close_date, ~tender.close_time, ";
		$sqlstr.= "~tender.transport, ~tender.created_date, ~tender.created_time, ";
		$sqlstr.= "~area.name, state.name, ~tender.classification, ~tender.user_id  ";
		// ORDER BY
		$sqlstr.= "ORDER BY ~tender.id DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$result = $conn->SelectLimit($sqlstr,$cfg['procure']['tenderadmin']['log'] ,$cfg['procure']['tenderadmin']['log'] * $params['searchinfo']['display']);
		if($result) {
			$all = $result->GetRows();
		}
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} elseif(empty($all)) {
			return $all;
		}
		// create user class
		$new_user = new user;
		// calculate time left
		foreach($all as $key => $value) {
			// get the username
			$userinfo = $new_user->get_info($value['user_id'],$cfg,$conn);
			$all[$key]['user_name'] = $userinfo['name'];
			$all[$key]['user_surname'] = $userinfo['surname'];
			if($value['status'] == "2") {
				$close_time = strtotime($value['close_date']." ".$value['close_time']);
				if($close_time) {
					$all[$key]['seconds_left'] = $close_time - (time() + $cfg['local']['duration']);
				}
			}
		}
		$new_database->convertTime($all,$cfg);
		return $all;
	}
	
	/**
	 * Get information about tender items
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders quotes or FALSE on error  
	 */
	function search_tender_item_count($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT ~tender_item.id, ~tender_item.classification, ~tender_item.brand,  ";
		$sqlstr.= "~tender_item.model, ~tender_item.budget, ~tender_item.status,  ";
		$sqlstr.= "~tender.created_date, ~tender.created_time, ~tender.close_date, ";
		$sqlstr.= "~tender.classification AS tenderclassification,  ";
		$sqlstr.= "~tender.close_time, ~tender.id AS tenderid, ~tender.rfq_number, ";
		$sqlstr.= "~tender_item_complete.status AS complete_status, ~tender_item_complete.tender_quote AS quote, ";
		$sqlstr.= "~category.name AS categoryname, ~category_sub.name AS category_subname, ";
		$sqlstr.= "COUNT(DISTINCT ~tender_quote.id) AS tenderquotecount ";
		// FROM
		$sqlstr.= "FROM (~tender_item LEFT JOIN ";
		$sqlstr.= " 	~tender_quote ";
		$sqlstr.= "		ON ~tender_quote.tender_item = ~tender_item.id AND ~tender_quote.status != 0) LEFT JOIN ";
		$sqlstr.= " ~tender_item_complete ";
		$sqlstr.= " ON ~tender_item_complete.tender_item = ~tender_item.id, ";
		$sqlstr.= "~tender, ~category, ~category_sub ";
		// WHERE
		$sqlstr.= "WHERE ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_item.category_sub = ~category_sub.id ";
		$sqlstr.= "AND ~category.id = ~category_sub.category ";
		if($this->tender['searchinfo']['tenderitemstatus'] || $this->tender['searchinfo']['tenderitemstatus'] === "0") {
			$sqlstr.= "AND ~tender_item.status = '".$this->tender['searchinfo']['tenderitemstatus']."' ";
		}
		if($this->tender['searchinfo']['tenderid']) {
			$sqlstr.= "AND ~tender_item.tender = '".$this->tender['searchinfo']['tenderid']."' ";
		}
		if($this->tender['searchinfo']['category']) {
			$sqlstr.= "AND ~category.id = '".$this->tender['searchinfo']['category']."' ";
		}
		if($this->tender['searchinfo']['category_sub']) {
			$sqlstr.= "AND ~tender_item.category_sub = '".$this->tender['searchinfo']['category_sub']."' ";
		}
		// GROUP BY
		$sqlstr.= "GROUP BY ~tender_item.id, ~tender_item.classification, ~tender_item.brand,  ";
		$sqlstr.= "~tender_item.model, ~tender_item.budget, ~tender_item.status,  ";
		$sqlstr.= "~tender.created_date, ~tender.created_time, ~tender.close_date, ";
		$sqlstr.= "~tender.close_time, ~tender.id, ~tender.rfq_number, ";
		$sqlstr.= "~category.name, ~category_sub.name, ~tender.classification, ";
		$sqlstr.= "~tender_item_complete.status, ~tender_item_complete.tender_quote ";
		// ORDER BY
		$sqlstr.= "ORDER BY ~tender_item.id DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$result = $conn->SelectLimit($sqlstr,$cfg['procure']['tenderadmin']['log'] ,$cfg['procure']['tenderadmin']['log'] *$params['searchinfo']['display']);
		if($result) {
			$all = $result->GetRows();
		}
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg()." SQL:".$sqlstr;
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		$new_database->convertTime($all,$cfg);
		return $all;
		
	}
	
	/**
	 * Get information about purchase_orders
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders quotes or FALSE on error  
	 */
	function cancel_purchase_order($params,$user,$cfg,$conn) {
		// get purchase order
		$purchase_order = $this->get_purchase_order($params['id'],$cfg,$conn);
		// set subscriber information
		$new_user = new user;
		$subscriber_info = $new_user->get_profile($purchase_order['user_id'],$cfg,$conn);
		// set response paramaters
		$this->tender['id'] = $purchase_order['tender'];
		$this->tender['organisation'] = $subscriber_info['organisation'];
		if(!$purchase_order) {
			// no purchase order found
			$this->error[] = "362";
			return FALSE;
		} elseif ($purchase_order['status'] == "2") {
			// purchase order already cancelled
			$this->error[] = "363";
			return FALSE;
		}
		// set paramaters
		$purchase_order['reason'] = $params['reason'];
		$purchase_order['notify'] = $params['notify'];
		// set purchase order to canceled
		$update['status'] = "2";
		$update['canceled_reason'] = $purchase_order['reason'];
		// timestamp
		$stamp = ts_time($cfg);
		$update['deleted_date'] = date("Y-m-d",$stamp);
		$update['deleted_time'] = date("H:i:s",$stamp);
		$update['deleted_by'] = $user['id'];
		$where = " id = ".$purchase_order['id']." ";
		$new_database = new database;
		if(!$new_database->update_table("~purchase_order",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			return FALSE;
		}
		unset($update);
		// update tender status
		$update['status'] = "4";
		$where = "status = '6' AND id = '".$purchase_order['tender']."'";
		if(!$this->update_tender($update,$where,$cfg,$conn)) {
			return FALSE;
		}
		// get all purchase_order items
		$items = $this->search_purchase_order_item($purchase_order['id'],$cfg,$conn);
		$cupdate['status'] = "0";
		foreach($items as $key => $value) {
			// change item status
			$where = "status = 6 AND id = ".$value['tender_item'];
			if(!$this->update_tender_item($update,$where,$cfg,$conn)) {
				return FALSE;
			}
			// change quote status
			$where = "status = 6 AND id = ".$value['tender_quote'];
			if(!$this->update_tender_quote($update,$where,$cfg,$conn)) {
				return FALSE;
			}
			$where = "id = ".$value['id'];
			if(!$new_database->update_table("~tender_item_complete",$cupdate,$where,$cfg,$conn)) {
				if(!empty($new_database->error)) {
					$this->error = array_merge($this->error,$new_database->error);
				}
				return FALSE;
			}
		}
		// send notification
		if ($purchase_order['notify']) {
			// set the additional fields
			$purchase_order['tender'] = $this->get_tender($purchase_order['tender'],$cfg,$conn);
			// set the user and agent fields
			$new_user = new user;
			$agent_info = $new_user->get_profile($purchase_order['agent'],$cfg,$conn);
			// send the purchase order cancellation notice
			$send_purchase_order = $this->send_purchase_order_cancellation($purchase_order,$agent_info,$subscriber_info,$user,$cfg,$conn);
			if (!$send_purchase_order) {
				// no purchase order found
				$this->error[] = "362";
				return FALSE;
			}
		}
		// successfull
		return TRUE;
	}
	
	/**
	 * search for tender item information
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_purchase_order_item($purchase_order,$cfg,$conn) {
		$sqlstr = "SELECT DISTINCT ~tender_item_complete.id, ~tender_item_complete.tender_item, ~tender_item_complete.tender_quote ";
		// FROM
		$sqlstr.= "FROM ~tender_item_complete ";
		// WHERE
		$sqlstr.= "WHERE ~tender_item_complete.status != '0' ";
		$sqlstr.= "AND ~tender_item_complete.purchase_order = '".$purchase_order."' ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $all;
	}
	
	/**
	 * Get information about purchase_orders
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders quotes or FALSE on error  
	 */
	function search_purchase_order_info($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT DISTINCT ~purchase_order.id, ~purchase_order.authentication, ~purchase_order.created_date, ";
		$sqlstr.= "~purchase_order.created_time, ~purchase_order.client_excess, ~purchase_order.agent_message, ";
		$sqlstr.= "~purchase_order.status, ~purchase_order.created_by, ";
		$sqlstr.="~tender.id AS tenderid, ~tender.rfq_number, ~tender.rfq_reference, ";
		$sqlstr.= "subscriber.id AS usersid,  ";
		$sqlstr.= "agent.id AS agentid ";
		// FROM
		$sqlstr.= "FROM ~tender, ~purchase_order, ~tender_item, ";
		$sqlstr.= "~tender_quote, ~users agent, ~users subscriber, ";
		$sqlstr.= "~organisation supplier, ~organisation_branch branch, ";
		$sqlstr.= "~tender_item_complete ";
		// WHERE
		$sqlstr.= "WHERE ~purchase_order.tender = ~tender.id ";
		$sqlstr.= "AND ~tender.id = ~tender_item.tender ";
		$sqlstr.= "AND ~tender_item.id = ~tender_item_complete.tender_item ";
		$sqlstr.= "AND ~tender_item_complete.purchase_order = ~purchase_order.id ";
		$sqlstr.= "AND ~tender_item_complete.tender_quote = ~tender_quote.id ";
		$sqlstr.= "AND ~purchase_order.agent = agent.id ";
		$sqlstr.= "AND ~purchase_order.user_id = subscriber.id ";
		$sqlstr.= "AND supplier.id = agent.organisation ";
		$sqlstr.= "AND subscriber.branch = branch.id ";
		if($this->tender['searchinfo']['tenderid']) {
			$sqlstr.= "AND ~tender.id = '".$this->tender['searchinfo']['tenderid']."' ";
		}
		if($this->tender['searchinfo']['tenderitemid']) {
			$sqlstr.= "AND ~tender_item.id = '".$this->tender['searchinfo']['tenderitemid']."' ";
		}
		if($this->tender['usersid']) {
			$sqlstr.= "AND subscriber.id = ".$this->tender['usersid']." ";
		}
		if($this->tender['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->tender['branchid']." ";
		}
		if($this->tender['supplierid']) {
			$sqlstr.= "AND agent.organisation = ".$this->tender['supplierid']." ";
		}
		// ORDER BY
		$sqlstr.= "ORDER BY ~purchase_order.id DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$result = $conn->SelectLimit($sqlstr,$cfg['procure']['tenderadmin']['log'] ,$cfg['procure']['tenderadmin']['log'] *$params['searchinfo']['display']);
		if($result) {
			$all = $result->GetRows();
		}
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// get subscriber info
		$new_users = new user;
		foreach($all as $key => $value) {
			$users_info = $new_users->get_info($value['usersid'],$cfg,$conn);
			$all[$key]['name'] = $users_info['name'];
			$all[$key]['surname'] = $users_info['surname'];
		}
		// get agent info
		foreach($all as $key => $value) {
			$users_info = $new_users->get_info($value['agentid'],$cfg,$conn);
			$all[$key]['agentname'] = $users_info['name'];
			$all[$key]['agentsurname'] = $users_info['surname'];
		}
		// get agent info
		foreach($all as $key => $value) {
			$users_info = $new_users->get_info($value['created_by'],$cfg,$conn);
			$all[$key]['cname'] = $users_info['name'];
			$all[$key]['csurname'] = $users_info['surname'];
		}
		$new_database->convertTime($all,$cfg);
		return $all;
	}
	
	/**
	 * Create tender and tender item for cancellation fee
	 * 
	 * @param array params purchase order info
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param TRUE on success or FALSE on error  
	 */
	function cancellation_fee($params,$user,$cfg,$conn) {
		// get purchase order
		$purchase_order = $this->get_purchase_order($params['id'],$cfg,$conn);
		$new_user = new user;
		$subscriber_info = $new_user->get_profile($purchase_order['user_id'],$cfg,$conn);
		$this->set_language('procure',$subscriber_info['language'],$cfg,$conn);
		$tender_id = $purchase_order['tender'];
		$client_info = $this->get_profile($tender_id,$cfg,$conn);
		$params['procure']['rfq_number'] = $client_info['rfq_number']; 
		$params['procure']['rfq_reference'] = $client_info['rfq_reference'];		
		// get area 		
		$area_search_info['searchinfo']['areaname'] = $client_info['areaname'];
		require_once($cfg['file'].'modules/area/class/area.class.php');
		$new_area = new area;
		$area_info = $new_area->search($area_search_info,$cfg,$conn);		 		
		$params['procure']['area'] = $area_info[0]['areaid'];
		$params['procure']['user_id'] = $client_info['user_id'];
		$params['procure']['title'] = $client_info['client_title'];
		$params['procure']['id_number'] = $client_info['client_id_number'];
		$params['procure']['surname'] = $client_info['client_surname'];
		$params['procure']['phone_prefix'] = $client_info['client_phone_prefix'];
		$params['procure']['phone_work'] = $client_info['client_phone_work'];
		$params['procure']['phone_fax'] = $client_info['client_phone_fax'];
		$params['procure']['phone_mobile'] = $client_info['client_phone_mobile'];
		$params['procure']['email'] = $client_info['client_email'];
		$params['procure']['address'] = $client_info['client_address'];
		//get tender item
		$tender_searchinfo['searchinfo']['tenderid'] = $tender_id;	
		$tenderitem_info = $this->search_tender_item_count($tender_searchinfo,$cfg,$conn);
		
		//get category
		require_once($cfg['file'].'modules/category/class/category.class.php');
		$new_category = new category;
		$category_search_info['searchinfo']['category_subname'] = $new_category->get_category_sub_name($tenderitem_info['category_sub'],$cfg,$conn);
		$category_info = $new_category->search_sub($category_search_info,$cfg,$conn);
		$params['procure']['item'][0]['category'] = $category_info[0]['categoryid'];
		$tenderitem_info = $this->get_tender_item($tenderitem_info[0]['id'],$cfg,$conn);
			
		require_once($cfg['file'].'modules/user/class/user.class.php');
		$new_user = new user;
		$user_info = $new_user->get_profile($purchase_order['agent'],$cfg,$conn);
		$params['procure']['item'][0]['supplier'] = $user_info['organisation'];
		$params['procure']['item'][0]['retailer'] = "1";  
		$params['procure']['item'][0]['branch'] = $user_info['branch'];
	  	$params['procure']['item'][0]['category_sub'] = $tenderitem_info['category_sub'];
		$params['procure']['item'][0]['brand'] = $this->lang['cancellation']; 
		$params['procure']['item'][0]['classification'] = "1";
		$params['procure']['item'][0]['model'] = "PO ".$purchase_order['id'];
		$params['procure']['item'][0]['description'] = "PO ".$purchase_order['id']." ".$params['procure']['rfq_number']." ".$params['procure']['rfq_reference'];
		
		require($cfg['file'].'modules/tender/language/'.$user['language'].'/request.php');
		require_once($cfg['file'].'modules/procure/class/procure_request.class.php');
		require_once($cfg['file'].'modules/tender/class/tender_request.class.php');
		require_once($cfg['file'].'modules/area/class/area.class.php');
		$new_request = new tender_request;
		// initiate tender
		// validate paramaters
		$new_request->tender = $params['procure'];
		$new_request->requester = $user;
		$new_request->subscriber = $subscriber_info;
		if (!$new_request->tender['transport']) {
			// set to default if not present
			$new_request->tender['transport'] = "d";
		}
		$tender_client['title'] = $new_request->tender['title'];
		$tender_client['id_number'] = $new_request->tender['id_number'];
		$tender_client['surname'] = $new_request->tender['surname'];
		$tender_client['phone_prefix'] = $new_request->tender['phone_prefix'];
		$tender_client['phone_work'] = $new_request->tender['phone_work'];
		$tender_client['phone_fax'] = $new_request->tender['phone_fax'];
		$tender_client['phone_mobile'] = $new_request->tender['phone_mobile'];
		$tender_client['email'] = $new_request->tender['email'];
		$tender_client['address'] = $new_request->tender['address'];
		$tender_client['created_by'] = $new_request->requester ['id'];		
		if (!$new_request->prepare_procure_request($this->lang['cancellation'],$cfg,$conn)) {
			$this->error[] = $new_request->error;
			return FALSE;			
		}
		$tender_client['tender'] = $new_request->tender['id'];
		// initiate the client info
		if (!$new_request->create_tender_client($tender_client,$cfg,$conn)) {
			// response
			$this->error[] = $new_request->error;			
			return FALSE;
		}		
	
		//submit quote
		$new_tender_quote['tender_item'] = $new_request->tender['item'][0]['id'];
		$new_tender_quote['classification'] = "1";
		$new_tender_quote['user_id'] = $new_request->tender['user_id'];
		$new_tender_quote['method'] = "auto";
		$new_tender_quote['brand'] = $new_request->tender['item'][0]['brand'];
		$new_tender_quote['model'] = $new_request->tender['item'][0]['model'];
		$new_tender_quote['description'] = $new_request->tender['item'][0]['description'];
		$new_tender_quote['stock'] = 0;
		$timestamp = ts_time($cfg);
		$new_tender_quote['valid_until'] = date("Y-m-d",$timestamp + 86400);
		$new_tender_quote['price'] = $params['cancellationfee'];				
		require_once($cfg['file'].'modules/procure/class/procure_response.class.php');
		require_once($cfg['file'].'modules/tender/class/tender_response.class.php');
		require_once($cfg['file'].'modules/generic/class/file.class.php');				
	   	$new_response = new tender_response;
	   	$new_response->agent = $user;
	   	$tender_quote_id = $new_response->create_tender_quote($new_tender_quote,$cfg,$conn);
	   	
	   	// close tender
	   	$new_request->update_tender_status($new_request->tender['id'],"4",$this->error,$cfg,$conn);
	   	// close tender
	   	$new_request->close_tender_item($new_request->tender['item'][0]['id'],$cfg,$conn);		
	   	// close quote
	   	$update['status'] = "4";
		$where = " tender_item = ".$new_request->tender['item'][0]['id'];		
		if (!$new_response->update_tender_quote($update,$where,$cfg,$conn)) {
			$this->error[] = $new_request->error;			
			return FALSE;
		}

		//award
		$award['award_item'][$tender_quote_id] = $new_request->tender['id'];
		$award['preference'][$new_request->tender['id']] = "m";
		$award['reason'][$new_request->tender['id']] = $this->lang['pocancellationfee'];
		$award['message'][$new_request->tender['id']] = $this->lang['pocancellationfee'];
		$award['comment'][$new_request->tender['id']] = $this->lang['pocancellationfee'];
		require_once($cfg['file'].'modules/procure/class/procure_award.class.php');
		$new_award = new procure_award;
		if (!$lock_tender = $new_award->do_award_item($xml_params,$award,$user,"procure",$cfg,$conn)) {
			$new_award->error[] = $new_request->error;			
			return FALSE;
		}
		
		if (!$new_award->check_tender_complete($xml_params,$lock_tender,$cfg,$conn)) {
			$new_award->error[] = $new_request->error;			
			return FALSE;			
		}		
		return TRUE;
	}
}
?>