<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Client message template 
* @package TenderSystem
* @subpackage procure
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// set the subject link
$subject = $this->lang['purchase_order'].$this->user['rfqnumber']." (".$this->user['rfqreference'].")";

$link = $cfg['url']."main.php?module=procure&function=authenticate_purchase_order&language=".$this->user['language']."&tenderid=".$this->user['tenderid']."&auth_string=".$this->user['authentication'];
// authentication string
$html.= "<tr>";
$html.= "<td>";
$html.= $this->lang['dear']." ".$this->user['name'].",<br/><br/>";
$html.= "<a class=\"e\" href=\"".$link."\">".$this->lang['nbclickhere']."</a>.<br/><br/>";
$html.= $this->lang['itemsawarded']." <a href=\"mailto:".$this->user['awarderemail']."?subject=".$subject."\">".$this->user['awardername']." ".$this->user['awardersurname']."</a>.<br/><br/>";
if($cfg['tender']['salvage'] && $this->user['collectsalvage']) {
	$html.="<b>".$this->lang['collectsalvage']."</b><br/><br/>";
}

$html.= "<table width=\"100%\"  border=\"0\" cellpadding=\"2\" cellspacing=\"0\">";
$html.= "<tr>";
$html.= "<td class=\"h t1\">";
$html.=  $this->lang['item'];
$html.= "</td>";
$html.= "<td class=\"ha t1\">";
$html.=  $this->lang['brand'];
$html.= "</td>";
$html.= "<td class=\"ha t1\">";
$html.=  $this->lang['model'];
$html.= "</td>";
$html.= "<td class=\"ha t1\">";
$html.=  $this->lang['description'];
$html.= "</td>";
$html.= "<td class=\"ha t1\">";
$html.=  $this->lang['price'];
$html.= "</td>";
$html.= "<td>";
$html.= "</td>";
$html.= "</tr>";
foreach($this->user['tender_item'] as $item) {
	$html.= "<tr>";
	$html.= "<td class=\"h2b t2\">";
	$html.= $item['tender_item'];
	$html.= "</td>";
	$html.= "<td class=\"h2c t2\">";
	$html.= $item['brand'];
	$html.= "</td>";
	$html.= "<td class=\"h2c t2\">";
	$html.= $item['model'];
	$html.= "</td>";
	$html.= "<td class=\"h2c t2\">";
	$html.= "<pre class=\"t2\">".wordwrap($item['description'],25)."</pre>";
	$html.= "</td>";
	$html.= "<td class=\"h2c t2\">";
	$html.= $cfg['local']['precurrency'].sprintf("%.2f",$item['price']).$cfg['local']['postcurrency'];
	$html.= "</td>";
	$html.= "</tr>";
}
$html.= "<tr>";
$html.= "<td class=\"hb t1\" colspan=\"4\" align=\"right\">";
$html.=  $this->lang['total'];
$html.= "</td>";
$html.= "<td class=\"hc t2\">";
$html.= $cfg['local']['precurrency'].sprintf("%.2f",$this->user['total']).$cfg['local']['postcurrency'];
$html.= "</td>";
$html.= "<td>";
$html.= "</td>";
$html.= "</tr>";
$final = $this->user['total'];
if($cfg['tender']['excess']) {
	$html.= "<tr>";
	$html.= "<td class=\"hb t1\" colspan=\"4\" align=\"right\">";
	$html.=  "- ".$this->lang['lessexcess'];
	$html.= "</td>";
	$html.= "<td class=\"hc t2\">";
	$html.= $cfg['local']['precurrency'].sprintf("%.2f",$this->user['excess']).$cfg['local']['postcurrency'];
	$html.= "</td>";
	$html.= "<td>";
	$html.= "</td>";
	$html.= "</tr>";
	$html.= "<tr>";
	$final -= $this->user['excess'];
}
if($this->user['assessment_fee']) {
	$fee = min($final,intval($this->user['assessment_fee']));
	$html.= "<tr>";
	$html.= "<td class=\"hb t1\" colspan=\"4\" align=\"right\">";
	$html.=  "- ".$this->lang['lessassessment'];
	$html.= "</td>";
	$html.= "<td class=\"hc t2\">";
	$html.= $cfg['local']['precurrency'].sprintf("%.2f",$fee).$cfg['local']['postcurrency'];
	$html.= "</td>";
	$html.= "<td>";
	$html.= "</td>";
	$html.= "</tr>";
	$html.= "<tr>";
	$final -= $fee;
}

$html.= "<td class=\"hb t1\" colspan=\"4\" align=\"right\">";
$html.=  $this->lang['invoicetotal'];
$html.= "</td>";
$html.= "<td class=\"hc t2\">";
$html.= $cfg['local']['precurrency'].sprintf("%.2f",$final).$cfg['local']['postcurrency'];
$html.= "</td>";
$html.= "<td>";
$html.= "</td>";
$html.= "</tr>";
// Close the table
$html.= "</table><br/>";

$html.= $this->lang['contacttofinalize']."<br/><br/>";

$html.= "<table width=\"100%\"  border=\"0\" cellpadding=\"2\" cellspacing=\"0\">";

$html.= "<tr>";
$html.= "<td class=\"h1 t1\" colspan=\"4\" align=\"left\">";
$html.= $this->lang['clientinfo'];
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['name'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['client_title']." ".$this->user['client_surname'];
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['idno'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
if($this->user['client_idno']) {
	$html.= $this->user['client_idno'];
} else {
	$html.= $this->user['rfqreference'];
}
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['phonework'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
if($this->user['client_phone_work']) {
	$html.= $this->user['client_phone_work'];
} else {
	$html.= $this->lang['na'];
}
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['phonemobile'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
if($this->user['client_phone_mobile']) {
	$html.= $this->user['client_phone_mobile'];
} else {
	$html.= $this->lang['na'];
}
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['email'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
if($this->user['client_email']) {
	$html.= "<a href=\"mailto:".$this->user['client_email']."?subject=".$subject."\">";
	$html.= $this->user['client_email'];
	$html.= "</a>";
} else {
	$html.= $this->lang['na'];
}
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['phonefax'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
if($this->user['client_phone_fax']) {
	$html.= $this->user['client_phone_fax'];
} else {
	$html.= $this->lang['na'];
}
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\" valign=\"top\">";
$html.= $this->lang['address'];
$html.= "</td>";
$html.= "<td class=\"t2\" colspan=\"3\">";
if($this->user['client_address']) {
	$html.= "<pre class=\"t2\">".wordwrap($this->user['client_address'])."</pre>";
} else {
	$html.= $this->lang['na'];
}
$html.= "</td>";
$html.= "</tr>";


$html.= "<tr><td><br/></td></tr>";

$html.= "<tr>";
$html.= "<td class=\"h1 t1\" colspan=\"4\" align=\"left\">";
$html.= $this->lang['invoiceinfo'];
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['rfq'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['rfqnumber'];
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['reference'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['rfqreference'];
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['invoiceamount'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $cfg['local']['precurrency'].sprintf("%.2f",$final).$cfg['local']['postcurrency'];
$html.= "</td>";
if($cfg['tender']['excess'] && $this->user['excess'] && $this->user['excess'] != "0.00") {
	$html.= "<td class=\"t1\">";
	$html.= $this->lang['clientexcess'];
	$html.= "</td>";
	$html.= "<td class=\"t2\">";
	$html.= $cfg['local']['precurrency'].sprintf("%.2f",$this->user['excess']).$cfg['local']['postcurrency'];
	$html.= "</td>";
}
if($this->user['comment']) {
	$html.= "</tr>";
	$html.= "<tr>";
	$html.= "<td class=\"t1\" valign=\"top\">";
	$html.= $this->lang['comment'];
	$html.= "</td>";
	$html.= "<td class=\"t2\" colspan=\"3\">";
	$html.= "<pre class=\"t2\">".wordwrap($this->user['comment'])."</pre>";
	$html.= "</td>";
	$html.= "</tr>";
}
if($this->user['reason']) {
	$html.= "<tr>";
	$html.= "<td class=\"t1\" valign=\"top\">";
	$html.= $this->lang['reason'];
	$html.= "</td>";
	$html.= "<td class=\"t2\" colspan=\"3\">";
	$html.= "<pre class=\"t2\">".wordwrap($this->user['reason'])."</pre>";
	$html.= "</td>";
	$html.= "</tr>";
}
$html.= "<tr><td><br/></td></tr>";

$html.= "<tr>";
$html.= "<td class=\"h1 t1\" colspan=\"4\" align=\"left\">";
$html.= $this->lang['subscriberinfo'];
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['name'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['awardername']." ".$this->user['awardersurname'];
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['phonework'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['awarderphone_work'];
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['phonefax'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['awarderphone_fax'];
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['email'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= "<a href=\"mailto:".$this->user['awarderemail']."?subject=".$subject."\">";
$html.= $this->user['awarderemail'];
$html.= "</a>";
$html.= "</td>";
$html.= "</tr>";

$html.= "<tr><td><br/></td></tr>";

$html.= "<tr>";
$html.= "<td class=\"h1 t1\" colspan=\"4\" align=\"left\">";
$html.= $this->lang['companyinfo'];
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['company'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['awarderinfo']['organisationname'];
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['branch'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['awarderinfo']['branchname'];
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['phonefax'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['awarderinfo']['branchphone_fax'];
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['email'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= "<a href=\"mailto:".$this->user['branchemail']."?subject=".$subject."\">";
$html.= $this->user['awarderinfo']['branchemail'];
$html.= "</a>";
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['phonework'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['awarderinfo']['branchphone_work'];
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['vatno'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['awarderinfo']['vat_number'];
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\" valign=\"top\">";
$html.= $this->lang['comment'];
$html.= "</td>";
$html.= "<td class=\"t2\" colspan=\"3\">";
$html.= "<pre class=\"t2\">".wordwrap($this->user['awarderinfo']['branchcomment'])."</pre>";
$html.= "</td>";
$html.= "</tr>";
$html.= "<td class=\"t1\" valign=\"top\">";
$html.= $this->lang['postal']."<br/>";
$html.= $this->lang['address'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['awarderinfo']['branch_po_street']."<br/>";
$html.= $this->user['awarderinfo']['branch_po_city']."<br/>";
$html.= $this->user['awarderinfo']['branch_po_code']."<br/>";
$html.= $this->user['awarderinfo']['branch_po_state']."<br/>";
$html.= $this->user['awarderinfo']['branch_po_country']."<br/>";
$html.= "</td>";
$html.= "<td class=\"t1\" valign=\"top\">";
$html.= $this->lang['physical']."<br/>";
$html.= $this->lang['address'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['awarderinfo']['branch_ph_street']."<br/>";
$html.= $this->user['awarderinfo']['branch_ph_city']."<br/>";
$html.= $this->user['awarderinfo']['branch_ph_code']."<br/>";
$html.= $this->user['awarderinfo']['branch_ph_state']."<br/>";
$html.= $this->user['awarderinfo']['branch_ph_country']."<br/>";
$html.= "</td>";
$html.= "</tr>";

$html.= "<tr><td><br/></td></tr>";

$html.= "<tr>";
$html.= "<td class=\"h1 t1\" colspan=\"4\" align=\"left\">";
$html.= $this->lang['supplierinfo'];
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['supplier'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['organisationname'];
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['agent'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= "<a href=\"mailto:".$this->user['email']."?subject=".$subject."\">";
$html.= $this->user['name']." ".$this->user['surname'];
$html.= "</a>";
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['phonework'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['phone_work'];
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['phonefax'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->user['phone_fax'];
$html.= "</td>";
$html.= "</tr>";
$html.= "</table>";
?>