<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create tender
* @package TenderSystem
* @subpackage public
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// unauthorised user
if (!$cfg['public']['enable']) {
	// not active
	$xml = $new_xml->xml_generator("public","error","e13",$xml_params,$user,$cfg);
} else {
	require($cfg['file'].'modules/user/class/subscriber.class.php');
	require($cfg['file'].'modules/user/class/agent.class.php');
	require($cfg['file'].'modules/password/class/password.class.php');
	require($cfg['file'].'modules/generic/class/message.class.php');
	require($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	$new_org = new organisation;
	$new_branch =  new branch;
	if($params['currentinfo']) {
		$xml_params['classification'] = $params['classification'];
		$xml_params['branchid'] = $params['branchid'];
		$xml_params['organisationid'] = $params['organisationid'];
		// user info 
		$users['username'] = str_replace(" ","_", $params['currentinfo'][0]['repusername']);
		if(strlen($users['username']) < 5) {
			$errors[] = "262";
		}
		$users['name'] =  $params['currentinfo'][0]['repname'];
		$users['surname'] =  $params['currentinfo'][0]['repsurname'];
		$users['phone_prefix'] =  $params['currentinfo'][0]['repphone_prefix'];
		$users['phone_work'] =  $params['currentinfo'][0]['repphone_work'];
		$users['phone_fax'] =  $params['currentinfo'][0]['repphone_fax'];
		$users['phone_mobile'] =  $params['currentinfo'][0]['repphone_mobile'];
		$users['email'] =  $params['currentinfo'][0]['repemail'];
		$users['preference'] =  $params['currentinfo'][0]['reppreference'];
		$users['classification'] =  min($params['currentinfo'][0]['classification'],"2");
		$users['permission'] =  $params['currentinfo'][0]['reppermission'];
		$users['theme'] =  $params['currentinfo'][0]['reptheme'];
		$users['language'] =  $params['currentinfo'][0]['replang'];
		if($params['currentinfo'][0]['repmandate']) {
			$users['mandate'] =  $params['currentinfo'][0]['repmandate'];
		}
		$users['status'] = "2";
		// org info
		$org['name'] =  $params['currentinfo'][0]['organisationname'];
		$org['registered_name'] =  $params['currentinfo'][0]['registered_name'];
		$org['classification'] =  min($params['currentinfo'][0]['classification'],"2");
		$org['rep_position'] =  $params['currentinfo'][0]['repposition'];
		$org['transaction_fee'] =  $cfg['public']['transaction_fee'];
		$org['transaction_min'] =  $cfg['public']['transaction_min'];
		$org['registration_number'] =  $params['currentinfo'][0]['registration_number'];
		$org['vat_number'] =  $params['currentinfo'][0]['vat_number'];
		$org['user_fee'] =  $cfg['public']['user_fee'];
		$org['sms_fee'] =  $cfg['public']['sms_fee'];
		$org['rating'] =  $params['currentinfo'][0]['rating'];
		// set of categories and areas can be set
		if($xml_params['classification'] == "1") {
			if($cfg['public']['set']['area']) {
				$org['set_area'] = "1";
			} else {
				$org['set_area'] = "0";
			}
			if($cfg['public']['set']['category']) {
				$org['set_category'] = "1";
			} else {
				$org['set_category'] = "0";
			}
		}
		if($cfg['public']['approve_reg']) {
			// approve status
			$org['status'] = "2";
		} else {
			// normal status
			$org['status'] = "2";
		}
		// branch info
		$branch['name'] =  $params['currentinfo'][0]['branchname'];
		$branch['phone_prefix'] =  $params['currentinfo'][0]['branchphone_prefix'];
		$branch['phone_work'] =  $params['currentinfo'][0]['branchphone_work'];
		$branch['phone_fax'] =  $params['currentinfo'][0]['branchphone_fax'];
		$branch['email'] =  $params['currentinfo'][0]['branchemail'];
		$branch['branch_comment'] =  $params['currentinfo'][0]['branchcomment'];
		$branch['primary_address_street'] =  $params['currentinfo'][0]['primary_address_street'];
		$branch['primary_address_city'] =  $params['currentinfo'][0]['primary_address_city'];
		$branch['primary_address_state'] =  $params['currentinfo'][0]['primary_address_state'];
		$branch['primary_address_postalcode'] =  $params['currentinfo'][0]['primary_address_postalcode'];
		$branch['primary_address_country'] =  $params['currentinfo'][0]['address_country'];
		$branch['alt_address_street'] =  $params['currentinfo'][0]['alt_address_street'];
		$branch['alt_address_city'] =  $params['currentinfo'][0]['alt_address_city'];
		$branch['alt_address_state'] =  $params['currentinfo'][0]['alt_address_state'];
		$branch['alt_address_postalcode'] =  $params['currentinfo'][0]['alt_address_postalcode'];
		$branch['alt_address_country'] =  $params['currentinfo'][0]['address_country'];
		$branch['status'] = "1";
		$doinserts = TRUE;
		// check if organisation already exists
		$info['searchinfo']['organisationname'] =  $org['name'];
		if($new_org->search($info,$cfg,$conn)) {
			// Already exists
			$errors[] = "263";
		}
		if($users['classification'] == "2") {
			$new_users = new subscriber;
		} elseif($users['classification'] == "1") {
			$new_users = new agent;
		} else {
			$new_users = new user;
		}
		if($new_users->get_id_by_username($users['username'],$cfg,$conn,TRUE)) {
			// Already exists
			$errors[] = "267";
		}
		// join errors
		if(!empty($new_org->error)) {
			$errors = array_merge($errors,$new_org->error);
		}
		if(!empty($new_user->error)) {
			$errors = array_merge($errors,$new_user->error);
		}
		if($errors) {
			// resend old infomation
			$xml_params['currentinfo'] = $params['currentinfo'];
			$xml_params['language'] = $params['language'];
			$xml_params['theme'] = $params['theme'];
			// generate xml 
			$xml = $new_xml->xml_generator("organisation","create",$errors,$xml_params,$user,$cfg);
		} else {
			$new_database = new database;
			// organisation id 
			$xml_params['organisationid'] = $org['id'] = $new_database->get_next_id("~organisation",$cfg,$conn);
			$users['organisation'] =  $org['id'];
			$branch['organisation'] =  $org['id'];
			// user id
			$users['id'] = $new_database->get_next_id("~users",$cfg,$conn);
			$org['rep_user_id'] = $users['id'];
			// branch id
			$branch['id'] = $new_database->get_next_id("~organisation_branch",$cfg,$conn);
			$users['branch'] = $branch['id'];
			// created by
			$branch['created_by'] = $users['created_by'] =  $org['created_by'] = $users['id'];
			// administrator
			$users['administrator'] = $users['id'];
			// insert organisation into database
			if($profile['id'] = $new_org->create_organisation( $org,$cfg,$conn)) {
				// insert branch into database
				 if($new_branch->create_branch($branch,$cfg,$conn)) {
					// insert user into database
					if($users['id'] = $new_users->create_user($users,$cfg,$conn)){
						$xml_params['created'] = "1";
						if(!$cfg['public']['approve_reg']) {
							$new_password = new password;
							$new_password->send_password($users,$users['id'],$cfg,$conn);
						}
					}
				}
			}
			// join errors
			if(!empty($new_org->error)) {
				$errors = array_merge($errors,$new_org->error);
			}
			if(!empty($new_user->error)) {
				$errors = array_merge($errors,$new_user->error);
			}
			if(!empty($new_branch->error)) {
				$errors = array_merge($errors,$new_branch->error);
			}
			if(!empty($new_password->error)) {
				$errors = array_merge($errors,$new_password->error);
			}
			if(!empty($errors)) {
				// resend old infomation
				$xml_params['language'] = $params['language'];
				$xml_params['theme'] = $params['theme'];
				$xml_params['currentinfo'] = $params['currentinfo'];
				// generate xml 
				$xml = $new_xml->xml_generator("public","create",$errors,$xml_params,$user,$cfg);
			} else {
				$xml_params['created'] = "1";
				if($cfg['public']['approve_reg']) {
					$xml_params['waitingapprove'] = "1";
				}
				if($xml_params['classification'] == "1") {
					if($cfg['public']['set']['area']) {
						$xml_params['needarea'] = "1";
					}
					if($cfg['public']['set']['category']) {
						$xml_params['needcategory'] = "1";
					}	
				}
				$xml = $new_xml->xml_generator("public","create",$errors,$xml_params,$user,$cfg);
			}
		}
	} else {
		if((!$cfg['public']['supplier']['registration'] && $params['classification'] == "1") ||(!$cfg['public']['company']['registration'] && $params['classification'] == "2")) {
			// not active
			$xml = $new_xml->xml_generator("public","error","e13",$xml_params,$user,$cfg);
		}
		$info[] = array (
			'transaction_fee'	=> $cfg['public']['transaction_fee'],
			'transaction_min'	=> $cfg['public']['transaction_min'],
			'user_fee'			=> $cfg['public']['user_fee'],
			'sms_fee'			=> $cfg['public']['sms_fee'],
			'repmandate'		=> "0.00",
			'repposition'		=> "Admin",
			'rating'			=> "E",
			'reptheme'			=> $cfg['theme'],
			'replanguage'		=> $cfg['language']
		);
		$xml_params = array(
			'classification'	=> $params['classification'],
			'currentinfo'		=> $info
		);
		// generate xml 
		$xml_params['theme'] = $params['theme'];
		$xml_params['language'] = $params['language'];
		$xml = $new_xml->xml_generator("public","create",$new_org->error,$xml_params,$user,$cfg);
	}
}
?>