<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Opt-in
* @package TenderSystem
* @subpackage public
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// agent
$required[1]['classification'] = "1";
$required[1]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// load required files
	// might be included by login already
	require($cfg['file'].'modules/generic/class/file.class.php');
	require($cfg['file'].'modules/public/class/tender.class.php');
	// instantiate object
	$new_tender = new tender;
	// instantiate object
	$new_user = new user;
	$new_file = new file;
	// find out for whom the tender is being requested
	if ($user['classification'] != "3") {
		// set that normal user requesting tender
		$params['usersid'] = $user['id'];
	}
	$info['id'] = $params['usersid'];
	$request['user'] = $new_user->get_profile($info,$cfg,$conn);
	// determine if authorised user
	if ($request['user']['classification'] == "1") {
		// check for a tender id
		$info['searchinfo']['tenderid'] = $params['id'];
		$info['searchinfo']['tenderstatus'] = "2";
		$xml_params['tenderitems'] = $new_tender->search_tender_item($info,$cfg,$conn);
		$xml_params['usersid'] = $request['user']['id'];
		$xml = $new_xml->xml_generator("public","opt-in",$new_report->error,$xml_params,$user,$cfg);
	} else {
		// instantiate error object
		$new_error = new error;
		// log error
		$error_text = "Unauthorised tender quote from id:".$user['id']." name:".$user['name']." ".$user['surname'];
		$error_text.= " for user id:".$user['id'];
		if ($user['session']) {
			$error_text.= " [session]";
		}
		$new_error->log("Tender","mild",$error_text,$cfg);
		// not authorised to perform request
		$error[] = "52";
		// proses the reponse error
		$xml = $new_error->response_xml($error,$user,$cfg);
	}
}
?>