<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Show category
* @package TenderSystem
* @subpackage public
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// include files
require($cfg['file'].'modules/area/class/area.class.php');
require($cfg['file'].'modules/category/class/category.class.php');
require($cfg['file'].'modules/public/class/public.class.php');
$new_area = new area;
$new_category = new category;
$new_public = new public_class;
if(!$params['organisationid']) {
	// generate xml
	$xml = $new_xml->xml_generator("public","error","e73",$xml_params,$user,$cfg);
} elseif(!$cfg['public']['set']['category']) {
	// generate xml
	$xml = $new_xml->xml_generator("public","error","e77",$xml_params,$user,$cfg);
} elseif(!$new_public->get_set_category_status($params['organisationid'],$cfg,$conn)) {
	// generate xml
	$xml = $new_xml->xml_generator("public","error","e75",$xml_params,$user,$cfg);
} else {
	// get categories
	$xml_params['category'] =$new_category->search($params,$cfg,$conn);
	// get subcategorys
	$xml_params['subcategory'] =$new_category->search_sub($params,$cfg,$conn);
	// get selected subcategorys
	$params['searchinfo']['organisationid'] = $params['organisationid'];
	$xml_params['selectedsubcategory'] =$new_category->search_sub($params,$cfg,$conn);
	// set to editable 
	$xml_params['editable'] = "1";
	if(empty($new_category->error) && $params['change'] && $xml_params['editable']) {
		if($params['check']) {
			$check = $params['check'];
		} else {
			$check = array();
		}
		$old_check = array();
		if (is_array($xml_params['selectedsubcategory'])) {
			foreach($xml_params['selectedsubcategory'] as $selectedsubcategory) {
				$old_check[$selectedsubcategory['subcategoryid']] = $selectedsubcategory['subcategorysupplierid'];
			}
		}
		
		// was not checked but is now checked
		foreach($check as $key => $value) {
			if(!$old_check[$key]) {
				if($new_category->create_category_sub_supplier($key,$params['organisationid'],$user['id'],$cfg,$conn)) {
					$xml_params['updated'] = "1";
				}
			}
		}
		
		// was checked but is now not checked
		foreach($old_check as $key => $value) {
			if(!$check[$key]) {
				if($new_category->delete_category_sub_supplier($value,$user['id'],$cfg,$conn)) {
					$xml_params['updated'] = "1";
				}
			}
		}
		// get selected subcategorys again
		$xml_params['selectedsubcategory'] = $new_category->search_sub($params,$cfg,$conn);
		$info['searchinfo']['organisationid'] = $params['organisationid'];
		// check if need area still
		if(!$new_area->search($info,$cfg,$conn) && $cfg['public']['set']['area']) {
			$xml_params['needarea'] = "1";
		}
		$xml_params['editable'] = "0";
		$new_public->unset_category_status($params['organisationid'],$cfg,$conn);
	}
	$xml_params['organisationid']	= $params['organisationid'];
	// generate xml
	$xml = $new_xml->xml_generator("public","show_category",$new_category->error,$xml_params,$user,$cfg);
}

?>