<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Public class
* @package TenderSystem
* @subpackage public
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class public_class {
	// set paramaters
	var $user;
	var $tender;
	var $requester;
	var $deliver;
	var $supplier;
	var $agent;
	var $response;
	var $error;
	
	function get_set_area_status($id,$cfg,$conn) {
		if(is_numeric($id)) {
			$this->user['id'] = $id;
		} else {
			$this->user = $id;
		}
		// Check if main parameters exist 
		if (!$this->user['id']){
			// Missing organisation id
			$this->error[] = "78";
		}
		// errors 
		if(!empty($this->error)){
			// Error in Public Class
			$this->error[] = "e76";
			return FALSE;
		}
		$sqlstr = "SELECT set_area ";
		$sqlstr.= "FROM ~organisation ";
		$sqlstr.= "WHERE ~organisation.id = ".$this->user['id']." "; 
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	function unset_area_status($id,$cfg,$conn) {
		$update['set_area'] = "0";
		$where = "id = ".$id;
		$new_database = new database;
		if(!$new_database->update_table("~organisation",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in Public Class
			$this->error[] = "e76";
			return FALSE;
		} 
      	return TRUE;
	}
	
	function get_set_category_status($id,$cfg,$conn) {
		if(is_numeric($id)) {
			$this->user['id'] = $id;
		} else {
			$this->user = $id;
		}
		// Check if main parameters exist 
		if (!$this->user['id']){
			// Missing organisation id
			$this->error[] = "78";
		}
		// errors 
		if(!empty($this->error)){
			// Error in Public Class
			$this->error[] = "e76";
			return FALSE;
		}
		$sqlstr = "SELECT set_category ";
		$sqlstr.= "FROM ~organisation ";
		$sqlstr.= "WHERE ~organisation.id = ".$this->user['id']." "; 
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	function unset_category_status($id,$cfg,$conn) {
		$update['set_category'] = "0";
		$where = "id = ".$id;
		$new_database = new database;
		if(!$new_database->update_table("~organisation",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in Public Class
			$this->error[] = "e76";
			return FALSE;
		} 
      	return TRUE;
	}
}
?>