<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Public tender class
* @package TenderSystem
* @subpackage public
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class tender {
	// set paramaters
	var $user;
	var $tender;
	var $requester;
	var $deliver;
	var $supplier;
	var $agent;
	var $response;
	var $error;
	
	/**
	 * search for tender item information
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_tender_item($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT DISTINCT ~tender_item.id, ~tender_item.classification, ~tender_item.brand, ";
		$sqlstr.= "~tender_item.model, ~tender_item.description, ~tender_item.tender, ";
		$sqlstr.= "~category_sub.name AS category_subname,   ";
		$sqlstr.= "~tender_item.quote, ~tender_item.budget, ~tender_item.status ";
		// FROM
		$sqlstr.= "FROM ~tender_item, ~category_sub ";
		// WHERE
		$sqlstr.= "WHERE ~tender_item.category_sub = ~category_sub.id ";
		$sqlstr.= "AND ~category_sub.status = '1' ";
		$sqlstr.= "AND ~tender_item.status = '2' ";
		if($this->tender['searchinfo']['tenderid']) {
			$sqlstr.= "AND ~tender_item.tender = '".$this->tender['searchinfo']['tenderid']."' ";
		}
		// ORDER BY
		$sqlstr.= "ORDER BY ~tender_item.tender ASC, ~tender_item.classification ASC, ~tender_item.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $all;
	}

	function category_search_count($params,$cfg,$conn) {
		$this->category = $params;
		// sqlstr
		$sqlstr = "SELECT ~category.id AS categoryid, ~category.name AS categoryname, ";
		$sqlstr.= "COUNT(~tender_item.id) as item_count ";
		$sqlstr.= "FROM ~category, ~tender_item, ~category_sub ";
		$sqlstr.= "WHERE ~category.status = '1' ";
		$sqlstr.= "AND ~category.id = ~category_sub.id ";
	    $sqlstr.= "AND ~category_sub.status = '1' ";
		$sqlstr.= "AND ~category_sub.id = ~tender_item.category_sub ";
		$sqlstr.= "AND (~tender_item.status != '2' ";
		$sqlstr.= "OR ~tender_item.status = '4') ";
		$sqlstr.= "GROUP BY ~category.id, ~category.name ";
		$sqlstr.= "ORDER BY ~category.name ASC";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $all;
	}

	function category_sub_search_count($params,$cfg,$conn) {
		$this->category = $params;
		// sqlstr
		$sqlstr = "SELECT ~category_sub.id AS category_subid, ~category_sub.name AS category_subname, ~category_sub.category AS categoryid, ";
		$sqlstr.= "COUNT(~tender_item.id) as item_count  ";
		$sqlstr.= "FROM ~tender_item, ~category_sub ";
		$sqlstr.= "WHERE ~category_sub.status = '1' ";
		$sqlstr.= "AND ~category_sub.id = ~tender_item.category_sub ";
		$sqlstr.= "AND (~tender_item.status = '2' ";
		$sqlstr.= "OR ~tender_item.status = '4') ";
		$sqlstr.= "GROUP BY ~category_sub.id, ~category_sub.name, ~category_sub.category ";
		$sqlstr.= "ORDER BY ~category_sub.name ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg()." SQL:".$sqlstr;
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $all;
	}
}
?>