<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Add ratings view
* @package TenderSystem
* @subpackage rating
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "all";
$required[0]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif (!$cfg['rating']['enable']) {
	// e1 - Rating Module is Disabled
	$xml = $new_xml->xml_generator("rating","error","e1",$xml_params,$user,$cfg);
} else {
	// include files
	require_once($cfg['file'].'modules/rating/class/rating.class.php');
	$xml_params['minimum'] = $cfg['rating']['min']['count'];
	$xml_params['outof'] = $cfg['rating']['outof'];
	$new_rating = new rating;
	$new_users = new user;
	$new_organisation = new organisation;
	$xml_params['supplierinfo'][] = $new_organisation->get_info($params['supplierid'],$cfg,$conn);
	if($user['classification'] == "3" && $params['usersid']) {
		$xml_params['userinfo'][] = $new_users->get_info($params['usersid'],$cfg,$conn);
	} else {
		$xml_params['userinfo'][] = $user;
	}
	if($xml_params['userinfo'][0]['classification'] == "2") {
		$xml_params['canadd'] = '1';
	} else {
		$xml_params['canadd'] = '0';
	}
	if($xml_params['canadd'] && is_array($params['add'])) {	
		$new_rating->create_supplier_rating($params['supplierid'],$xml_params['userinfo'][0]['id'],$params['add'],$user,$cfg,$conn);
		// include settings
		require($cfg['file']."modules/rating/config.inc.php");
		if ($cfg['rating']['sendemail']) {
			// email rating to supplier agents
			if ($xml_params['userinfo'][0]['id'] != $user['id']) {
				$new_rating->email_supplier($params['supplierid'],$xml_params['userinfo'][0]['id'],$user,$params['add'],$cfg,$conn);
			} else {
				$new_rating->email_supplier($params['supplierid'],$xml_params['userinfo'][0]['id'],NULL,$params['add'],$cfg,$conn);
			}	 
		}
	}	
	// get supplier	
	$xml_params['ratinginfo'][] = $new_rating->get_rating_info($params['supplierid'],$cfg,$conn);
	// join errors
	if(!empty($new_rating->error)) {
		$errors = array_merge($errors,$new_rating->error);
	}
	// join errors
	if(!empty($new_users->error)) {
		$errors = array_merge($errors,$new_users->error);
	}
	// join errors
	if(!empty($new_organisation->error)) {
		$errors = array_merge($errors,$new_organisation->error);
	}
	$xml = $new_xml->xml_generator("rating","add_view",$errors,$xml_params,$user,$cfg);
}
?>