<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Link generator
* @package TenderSystem
* @subpackage report
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

require($cfg['file'].'modules/rating/config.inc.php');
if($cfg['rating']['enable']) {
	if ($link == "organisation" && $sub_link == "profile") {
		require_once($cfg['file'].'modules/rating/class/rating.class.php');
		require($cfg['file'].'modules/rating/language/'.$user['language'].'/rating.php');
		$new_rating = new rating;
		$rating = $new_rating->get_supplier_rating($xml_params['organisationinfo'][0]['organisationid'],$cfg,$conn);
		$add['name'] = $lang['supplierrating'];
		$add['type'] = "view_text";
		if(!$rating['supplier_rating'] || $rating['supplier_rating']=="0.00") {
			$add['current'] = $lang['notrated'];	
		} else {
			$add['current'] = $rating['supplier_rating']." ".$lang['outof']." ".$cfg['rating']['outof'];
		}
		$xml_params['organisationinfo'][0]['additional'][] = $add;
		unset($add);
	}
	
	if (($link == "tender" && $sub_link == "tender_group_by_quote") || ($link == "assessment" && $sub_link == "assessment_group_by_assessment")) {
		require_once($cfg['file'].'modules/rating/class/rating.class.php');
		require($cfg['file'].'modules/rating/language/'.$user['language'].'/rating.php');
		$new_rating = new rating;
		if($user['classification'] == "2") {
			$text = $lang['ratesupplierviewratings'];
		} else {
			$text = $lang['viewratings'];
		}
		if ($xml_params['agent']) {
			foreach($xml_params['agent'] as $key => $value) {
				$add['name'] = $lang['overallrating'];
				$rating = $new_rating->get_supplier_rating($value['organisationid'],$cfg,$conn);
				if(!$rating['supplier_rating'] || $rating['supplier_rating']=="0.00") {
					$add['current'] = $lang['notrated'];
				} else {
					$add['current'] = $rating['supplier_rating']." ".$lang['outof']." ".$cfg['rating']['outof'];
				}
				$xml_params['agent'][$key]['additional'][] = $add;
				unset($add);
				$add['name'] = $text;
				$add['current'] = $lang['clickhere'];
				$add['module'] = "rating";
				$add['function'] = "add_view&supplierid=".$value['organisationid'];
				$xml_params['agent'][$key]['additional'][] = $add;
				unset($add);
			}
		}	
		unset($add);
	}
	
	// links for company admin
	if ($link == "organisation" && $sub_link == "left_company") {
		require($cfg['file'].'modules/rating/language/'.$user['language'].'/rating.php');
		$add['name'] = $lang['ratesupplier'];
		$add['frame'] = "main";
		$add['module'] = "rating";
		$add['function'] = "rate_supplier";
		$xml_params['subscriberadmin'][] = $add;
		unset($add);
	}
	
	// add to feedback_request email
	if ($link == "feedback" && $sub_link == "feedback_request") {
		require($cfg['file'].'modules/rating/language/'.$user['language'].'/rating.php');
		require_once($cfg['file'].'modules/rating/class/rating.class.php');
		$new_rating = new rating;
		$rating = $new_rating->get_supplier_rating($user['supplier'],$cfg,$conn);
		if(!$rating['supplier_rating'] || $rating['supplier_rating'] == "0.00") {
			$rating = $lang['notrated'];
		} else {
			$rating = $rating['supplier_rating']." ".$lang['outof']." ".$cfg['rating']['outof'];
		}
		$xml_params.= "<br/>".$lang['overallratingexplain']."<br/>";
		$xml_params.= "<table width=\"100%\"  border=\"0\" cellpadding=\"2\" cellspacing=\"0\">";
		$xml_params.= "<tr>";
		$xml_params.= "<td class=\"h1 t1\" align=\"left\">";
		$xml_params.= $lang['overallrating'];
		$xml_params.= "</td>";
		$xml_params.= "<td class=\"h2a t1\" align=\"left\">";
		$xml_params.= $rating;
		$xml_params.= "</td>";
		$xml_params.= "</tr>";
		$xml_params.= "</table><br/>";
		$redirect = "add_view&supplierid=".$user['supplier'];
		$link = $cfg['url']."index.php?next_module=rating&next_function=".rawurlencode($redirect)."&next_call_id=".time();
		$xml_params.= $lang['toviewrating'].", <a href=".$link.">".$lang['clickhere']."</a><br/>";
	}
	
	if (($link == "tender" || $link == "assessment") && $sub_link == "response_submitter") {
		require($cfg['file'].'modules/rating/language/'.$user['language'].'/rating.php');
		require_once($cfg['file'].'modules/rating/class/rating.class.php');
		$new_rating = new rating;
		$rating = $new_rating->get_supplier_rating($user['organisationid'],$cfg,$conn);
		if(!$rating['supplier_rating'] || $rating['supplier_rating'] == "0.00") {
			$display = $lang['notrated'];
		} else {
			$display = $rating['supplier_rating']." ".$lang['outof']." ".$cfg['rating']['outof'];
		}
		$redirect = "add_view&supplierid=".$user['organisationid'];
		$link = $cfg['url']."index.php?next_module=rating&next_function=".rawurlencode($redirect)."&next_call_id=".time();
		$xml_params.= "<tr>\n";
		$xml_params.= "<td class=\"hb t1\" colspan=\"2\">";
		$xml_params.= $lang['supplierrating'];
		$xml_params.= "</td>\n";
		$xml_params.= "<td class=\"hc t2\" colspan=\"4\">";
		$xml_params.= $display;
		$xml_params.= " (<a href=".$link.">".$lang['submitratingonline']."</a>)";
		$xml_params.= "</td>\n";
	}
	
	// add to feedback_response email
	if ($link == "feedback" && $sub_link == "feedback_response_additional") {
		require($cfg['file'].'modules/rating/language/'.$user['language'].'/rating.php');
		require_once($cfg['file'].'modules/rating/class/rating.class.php');
		$new_rating = new rating;
		$rating = $new_rating->get_supplier_rating($user['supplier'],$cfg,$conn);
		if(!$rating['supplier_rating'] || $rating['supplier_rating'] == "0.00") {
			$display = $lang['notrated'];
		} else {
			$display = $rating['supplier_rating']." ".$lang['outof']." ".$cfg['rating']['outof'];
		}
		$redirect = "add_view&supplierid=".$user['supplier'];
		$link = $cfg['url']."index.php?next_module=rating&next_function=".rawurlencode($redirect)."&next_call_id=".time();
		$xml_params.= "<br/>".$lang['overallratingexplain'].".<br/><br/>";
		$xml_params.= "<table width=\"100%\"  border=\"0\" cellpadding=\"2\" cellspacing=\"0\">";
		$xml_params.= "<tr>";
		$xml_params.= "<td class=\"h1 t1\" align=\"left\">";
		$xml_params.= $lang['overallrating'];
		$xml_params.= "</td>";
		$xml_params.= "<td class=\"h2a t1\" align=\"left\">";
		$xml_params.= $display." (<a href=".$link.">".$lang['clickheretosubmitarating']."</a>)";
		$xml_params.= "</td>";
		$xml_params.= "</tr>";
		$xml_params.= "</table><br/>";
	}
} 
?>