<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Bordereaux
* @package TenderSystem
* @subpackage report
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
// administrator is requesting tender on behalf of user
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// user
$required[1]['classification'] = "2";
$required[1]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// load required files
	require($cfg['file'].'modules/report/class/report.class.php');
	// instantiate objects
	$new_database = new database;
	$new_report = new report;
	// determine if authorised user
	if($params['info']) {
		// update invoices
		if(is_array($params['info']['invoice_user'])) {
			foreach($params['info']['invoice_user'] as $key => $value) {
				if($new_report->set_tender_item_invoice($key,$user['id'],$cfg,$conn) && $xml_params['updated'] != "1") {
					$xml_params['updated'] = "1";
				}
				if(!is_array($sinfo['searchinfo']['tender_itemid']) || !in_array($key,$sinfo['searchinfo']['tender_itemid'])) {
					$sinfo['searchinfo']['tender_itemid'][] = $key;
				}
			}
		}
		// update payment
		if(is_array($params['info']['payment_user'])) {
			foreach($params['info']['payment_user'] as $key => $value) {
				if($new_report->set_tender_item_payment($key,$user['id'],$cfg,$conn) && $xml_params['updated'] != "1") {
					$xml_params['updated'] = "1";
				}
				if(!is_array($sinfo['searchinfo']['tender_itemid']) || !in_array($key,$sinfo['searchinfo']['tender_itemid'])) {
					$sinfo['searchinfo']['tender_itemid'][] = $key;
				}
			}
		}
	}
	if(!empty($new_tender->error)) {
		$xml = $new_xml->xml_generator("report","bordereaux",$new_tender->error,$xml_params,$user,$cfg);
	} else {
		if($sinfo['searchinfo']['tender_itemid']) {
			$xml_params['tender_quote'] = $new_report->search_bordereaux($sinfo,$cfg,$conn);
			$tender_count = 0;
			$new_users = new user;
			foreach($xml_params['tender_quote'] as $key => $value) {
				// if first sum for agent
				if(!$xml_params['agent_sum'][$value['agentid']]['id']) {
					$userinfo = $new_users->get_info($value['agentid'],$cfg,$conn);
					$xml_params['agent_sum'][$value['agentid']]['id'] = $value['agentid'];
					$xml_params['agent_sum'][$value['agentid']]['name'] = $userinfo['name'];
					$xml_params['agent_sum'][$value['agentid']]['surname'] = $userinfo['surname'];
					$xml_params['agent_sum'][$value['agentid']]['invoice'] = 0;
					$xml_params['agent_sum'][$value['agentid']]['payment']= 0;
					$xml_params['agent_sum'][$value['agentid']]['paid']= 0;
				}
				// agent calculations
				$xml_params['agent_sum'][$value['agentid']]['awarded']+= $value['price'];
				if(!$value['invoice_user']) {
					$xml_params['agent_sum'][$value['agentid']]['invoice']+= $value['price'];
				} elseif(!$value['payment_user']) {
					$xml_params['agent_sum'][$value['agentid']]['payment']+= $value['price'];
				} else{
					$xml_params['agent_sum'][$value['agentid']]['paid']+= $value['price'];
				}
		
				// first time for tender
				if(!$tender_counter[$value['tenderid']][$value['agentid']][$value['complete_order']]) {
					$num = $tender_counter[$value['tenderid']][$value['agentid']][$value['complete_order']] = ++$tender_count;
					$xml_params['tender_sum'][$num]['id'] = $value['tenderid'];
					$xml_params['tender_sum'][$num]['agentid'] = $value['agentid'];
					$xml_params['tender_sum'][$num]['purchase_order'] = $value['purchase_order'];
					$xml_params['tender_sum'][$num]['rfq_number'] = $value['rfq_number'];
					$xml_params['tender_sum'][$num]['total'] = 0;
					$xml_params['tender_sum'][$num]['payable']-=$xml_params['tender_sum'][$num]['excess'] =  $value['client_excess'];
				} else {
					$num = $tender_counter[$value['tenderid']][$value['agentid']][$value['purchase_order']];
				}
				// tender calculations
				$xml_params['tender_sum'][$num]['payable']+=$xml_params['tender_sum'][$num]['total']+= $value['price'];
			}
			foreach($xml_params['agent_sum'] as $key => $value) {
				$xml_params['total_sum'][0]['awarded']+= $value['awarded'];
				$xml_params['total_sum'][0]['invoice']+= $value['invoice'];
				$xml_params['total_sum'][0]['payment']+= $value['payment'];
				$xml_params['total_sum'][0]['paid']+= $value['paid'];
			}
		}
		$xml = $new_xml->xml_generator("report","bordereaux",$new_report->error,$xml_params,$user,$cfg);
	}
}
?>