<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Supplier 
* @package TenderSystem
* @subpackage report
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = array("1","3");
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif(is_array($params['error'])) {
	// generate xml 
	$xml = $new_xml->xml_generator( "report", "supplier",$params['error'],"",$user,$cfg);
} else {
	require($cfg['file'].'modules/area/class/area.class.php');
	require($cfg['file'].'modules/report/class/report.class.php');
	// instantiate objects
	$new_branch = new branch;
	$new_area = new area;
	$new_users = new user;
	$xml_params['daysago3'] = date("Y-m-d",ts_time($cfg) - 259200);
	$xml_params['today'] = date("Y-m-d",ts_time($cfg));
	if(!$params['supplierid']) {
		$params['supplierid'] = $user['organisation'];
	}
	$xml_params['supplierid'] = $params['supplierid'];
	if($cfg['tender']['budget']) {
		$xml_params['tenderbudget'] = "1";
	}
	if($params['reportinfo']) {
		// permission checks
		if($user['classification'] == "1") {
			if($user['permission'] == "1") {
				$params['reportinfo']['agentid'] = $user['id'];
			} else{
				$params['reportinfo']['supplierid'] = $user['organisation'];
			}
		} else {
			$params['reportinfo']['supplierid'] = $params['supplierid'];
		}
		// check for start_date
		if(!$params['reportinfo']['startdate']) {
			// make three months ago
			$params['reportinfo']['startdate'] = date("Y-m-d",ts_time($cfg) - 7889231.49);
		}
		// check for end date
		if(!$params['reportinfo']['enddate']) {
			// make today
			$params['reportinfo']['enddate'] = date("Y-m-d",ts_time($cfg));
		}

		$info['searchinfo'] = $params['reportinfo'];
		list($year,$month,$day) = sscanf(str_replace(array("-"," "),"",$params['reportinfo']['startdate']),'%4s%2s%2s');
		$xml_params['startdate'] = date($cfg['date']['format'],mktime("0","0","0",$month,$day,$year));
		list($year,$month,$day) = sscanf(str_replace(array("-"," "),"",$params['reportinfo']['enddate']),'%4s%2s%2s');
		$xml_params['enddate'] = date($cfg['date']['format'],mktime("0","0","0",$month,$day,$year));
		// open tenders report
		if($params['reportinfo']['reporttype'] == "open" || $params['reportinfo']['reporttype'] == "all") {
			// instantiate object
			$new_report = new report;
			if($params['reportinfo']['reporttype'] == "open") {
				$xml_params['tender'] = $new_report->search_open($info,$cfg,$conn);
			} else {
				$xml_params['tender'] = $new_report->search_all($info,$cfg,$conn);
			}
			for($i = 0; $i < count($xml_params['tender']); $i++) {
				$timestamp = ts_time($cfg);
				// check create time
				if($xml_params['tender'][$i]['created_date'] == date($cfg['date']['format'],$timestamp)) {
					$xml_params['tender'][$i]['created_on'] = $xml_params['tender'][$i]['created_time'];
				} else {
					$xml_params['tender'][$i]['created_on'] = $xml_params['tender'][$i]['created_date']." " .$xml_params['tender'][$i]['created_time'];
				}
				// check close time
				if($xml_params['tender'][$i]['status'] == '2') {
					$xml_params['tender'][$i]['close_on'] = "N/A";
				} elseif($xml_params['tender'][$i]['close_date'] == date($cfg['date']['format'],$timestamp)) {
					$xml_params['tender'][$i]['close_on'] = $xml_params['tender'][$i]['close_time'];
				} else {
					$xml_params['tender'][$i]['close_on'] = $xml_params['tender'][$i]['close_date']." " .$xml_params['tender'][$i]['close_time'];
				}
				// assoc array for tender
				$tender_assoc[$xml_params['tender'][$i]['id']] = $i;
 			}
			$xml_params['tender_item'] = $new_report->search_open_tender_item($info,$cfg,$conn);
			for($i = 0; $i < count($xml_params['tender_item']); $i++) {
				$tenderid = $xml_params['tender_item'][$i]['tenderid'];
				$j = $tender_assoc[$tenderid];
				$xml_params['tender'][$j]['budget'] += $xml_params['tender_item'][$i]['budget'];
				$xml_params['tender'][$j]['budget'] = sprintf("%.2f",$xml_params['tender'][$j]['budget']);
 			}
			// generate xml
			$xml = $new_xml->xml_generator( "report", "open",$new_report->error,$xml_params,$user,$cfg);
		} elseif($params['reportinfo']['reporttype'] == "closed") {
			// instantiate object
			$new_report = new report;
			$xml_params['tender'] = $new_report->search_closed($info,$cfg,$conn);
			for($i = 0; $i < count($xml_params['tender']); $i++) {
				$timestamp = ts_time($cfg);
				// check create time
				if($xml_params['tender'][$i]['created_date'] == date($cfg['date']['format'],$timestamp)) {
					$xml_params['tender'][$i]['created_on'] = $xml_params['tender'][$i]['created_time'];
				} else {
					$xml_params['tender'][$i]['created_on'] = $xml_params['tender'][$i]['created_date']." " .$xml_params['tender'][$i]['created_time'];
				}
				// check close time
				if($xml_params['tender'][$i]['close_date'] == date($cfg['date']['format'],$timestamp)) {
					$xml_params['tender'][$i]['close_on'] = $xml_params['tender'][$i]['close_time'];
				} else {
					$xml_params['tender'][$i]['close_on'] = $xml_params['tender'][$i]['close_date']." " .$xml_params['tender'][$i]['close_time'];
				}
				// assoc array for tender
				$tender_assoc[$xml_params['tender'][$i]['id']] = $i;
 			}
			$xml_params['tender_quote'] = $new_report->search_closed_tender_quote($info,$cfg,$conn);
			$agent_counter = 0;
 			for($i = 0; $i < count($xml_params['tender_quote']); $i++) {
 				$tenderid = $xml_params['tender_quote'][$i]['tenderid'];
				$tender_item = $xml_params['tender_quote'][$i]['tender_item'];
				$agentid = $xml_params['tender_quote'][$i]['agentid'];
				if(!$done[$tenderid][$tender_item]) {
 					$j = $tender_assoc[$tenderid];
 					$xml_params['tender'][$j]['budget'] += $xml_params['tender_quote'][$i]['budget'];
 					$xml_params['tender'][$j]['budget'] = sprintf("%.2f",$xml_params['tender'][$j]['budget']);
					$done[$tenderid][$tender_item] = TRUE;
				}
				if(!$agent_k[$tenderid][$agentid]) {
					$agent_k[$tenderid][$agentid] = ++$agent_counter;
				}
				$k = $agent_k[$tenderid][$agentid];
				if(!$xml_params['agent'][$k]['id']) {
					$xml_params['agent'][$k]['id'] = $agentid;
					$xml_params['agent'][$k]['tenderid'] = $tenderid;
					$xml_params['agent'][$k]['name'] = $xml_params['tender_quote'][$i]['name'];
					$xml_params['agent'][$k]['surname'] = $xml_params['tender_quote'][$i]['surname'];
				}
				$xml_params['agent'][$k]['price']+= $xml_params['tender_quote'][$i]['price'];
  			}
			// generate xml
			$xml = $new_xml->xml_generator( "report", "closed",$new_report->error,$xml_params,$user,$cfg);
		} elseif($params['reportinfo']['reporttype'] == "awarded") {
			unset($info['searchinfo']['agentid']);
			//unset($info['searchinfo']['supplierid']);
			// instantiate object
			$new_report = new report;
			$xml_params['tender'] = $new_report->search_award($info,$cfg,$conn);			
			for($i = 0; $i < count($xml_params['tender']); $i++) {
				$timestamp = ts_time($cfg);
				// check create time
				if($xml_params['tender'][$i]['created_date'] == date($cfg['date']['format'],$timestamp)) {
					$xml_params['tender'][$i]['created_on'] = $xml_params['tender'][$i]['created_time'];
				} else {
					$xml_params['tender'][$i]['created_on'] = $xml_params['tender'][$i]['created_date']." " .$xml_params['tender'][$i]['created_time'];
				}
				// check close time
				if($xml_params['tender'][$i]['status'] == '2') {
					$xml_params['tender'][$i]['close_on'] = "N/A";
				} elseif($xml_params['tender'][$i]['close_date'] == date($cfg['date']['format'],$timestamp)) {
					$xml_params['tender'][$i]['close_on'] = $xml_params['tender'][$i]['close_time'];
				} else {
					$xml_params['tender'][$i]['close_on'] = $xml_params['tender'][$i]['close_date']." " .$xml_params['tender'][$i]['close_time'];
				}
				// assoc array for tender
				$tender_assoc[$xml_params['tender'][$i]['id']] = $i;
 			}
			$xml_params['tender_quote'] = $new_report->search_award_tender_quote($info,$cfg,$conn);
			$agent_counter = 0;
 			for($i = 0; $i < count($xml_params['tender_quote']); $i++) {
 				$tenderid = $xml_params['tender_quote'][$i]['tenderid'];
				$tender_item = $xml_params['tender_quote'][$i]['tender_item'];
				$agentid = $xml_params['tender_quote'][$i]['agentid'];
 	
				$j = $tender_assoc[$tenderid];				
				if(!$done[$tenderid][$tender_item]) {
	 				$xml_params['tender'][$j]['budget'] += $xml_params['tender_quote'][$i]['budget'];
	 				$xml_params['tender'][$j]['budget'] = sprintf("%.2f",$xml_params['tender'][$j]['budget']);
					$done[$tenderid][$tender_item] = TRUE;
				}
									
				if(!$agent_k[$tenderid][$agentid]) {
					$agent_k[$tenderid][$agentid] = ++$agent_counter;
				}
				$k = $agent_k[$tenderid][$agentid];
				if(!$xml_params['agent'][$k]['id']) {
					$xml_params['agent'][$k]['id'] = $agentid;
					$xml_params['agent'][$k]['tenderid'] = $tenderid;
					$xml_params['agent'][$k]['name'] = $xml_params['tender_quote'][$i]['name'];
					$xml_params['agent'][$k]['surname'] = $xml_params['tender_quote'][$i]['surname'];
				}				
				$xml_params['agent'][$k]['price']+= $xml_params['tender_quote'][$i]['price'];
  			}
			// generate xml
			$xml = $new_xml->xml_generator("report", "closed",$new_report->error,$xml_params,$user,$cfg);
		} elseif($params['reportinfo']['reporttype'] == "agent_fees") {
			// service fees of organisations
			// instantiate object
			$new_report = new report;
			$new_organisation = new organisation;
			$supplierinfo = $new_organisation->get_info($params['reportinfo']['supplierid'],$cfg,$conn);
			list($year,$month,$day) = sscanf(str_replace(array("-"," "),"",$params['reportinfo']['startdate']),'%4s%2s%2s');
			$start = mktime("0","0","0",$month,$day,$year);
			list($year,$month,$day) = sscanf(str_replace(array("-"," "),"",$params['reportinfo']['enddate']),'%4s%2s%2s');
			$diff = mktime("23","59","59",$month,$day,$year) - $start;
			$months = ceil($diff / 2629743.83);
			$user_fee = max(0.00,$new_report->search_active_agents($info,$cfg,$conn) * $supplierinfo['user_fee'] * $months);
			$info['searchinfo']['organisationid'] = $info['searchinfo']['supplierid']; 
			$message_fee = $new_report->search_message_fees($info,$cfg,$conn);
			$xml_params['all'][0]['message_fee'] = sprintf("%.2f",$message_fee);
			$xml_params['all'][0]['user_fee'] = sprintf("%.2f",$user_fee);
			$xml_params['all'][0]['total'] = sprintf("%.2f",$message_fee + $user_fee);
			// generate xml
			$xml = $new_xml->xml_generator( "report", "supplier_fees",$new_report->error,$xml_params,$user,$cfg);
		} else {
			// Unknown type
			$error[] = "288";
			// generate xml
			$xml = $new_xml->xml_generator("report", "supplier",$error,$xml_params,$user,$cfg);
		}
	} else {
		$xml_params['state'] = $new_area->search_state("",$cfg,$conn);
		$xml_params['area'] = $new_area->search("",$cfg,$conn);
		// generate xml
		$xml = $new_xml->xml_generator( "report", "supplier","",$xml_params,$user,$cfg);
	}
}
?>