<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Report class
* @package TenderSystem
* @subpackage report
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class report {
	// set paramaters
	var $user;
	var $tender;
	var $requester;
	var $deliver;
	var $supplier;
	var $agent;
	var $response;
	var $error;
	
	/**
	 * Returns information for audit report
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tender items or FALSE on error  
	 */
	function search_audit($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr.= "SELECT DISTINCT ~tender_item.id, ~tender_item_complete.status AS complete_status, ~tender_item.status, ~tender_item.model, ~tender_item.brand, ~tender_item.classification, "; 
		$sqlstr.= "~tender_quote.quote_position, "; 
		$sqlstr.= "~tender.id AS tenderid, ~tender.rfq_number, ~tender.created_date, "; 
		$sqlstr.= "~tender.created_time, ~tender.close_date, ~tender.close_time, "; 
		$sqlstr.= "~tender.classification AS tenderclassification, ~tender.status AS tenderstatus, "; 
		$sqlstr.= "branch.id AS branchid, ";
		$sqlstr.= "~users.id AS usersid, "; 
		$sqlstr.= "~area.name AS areaname, ";
		$sqlstr.= "~category_sub.name AS category_subname, "; 
		$sqlstr.= "COUNT(DISTINCT request.id) AS sent, ";
		$sqlstr.= "COUNT(DISTINCT quote.id) AS received ";
		$sqlstr.= "FROM 	((~tender_item LEFT JOIN ~tender_item_complete "; 
		$sqlstr.= "ON ~tender_item.id = ~tender_item_complete.tender_item) LEFT JOIN ~tender_request "; 
		$sqlstr.= "ON ~tender_request.tender_item = ~tender_item.id AND ~tender_request.status = '1') LEFT JOIN ~tender_quote ";
		$sqlstr.= "ON ~tender_quote.tender_item = ~tender_item.id "; 
		$sqlstr.= "AND ~tender_item_complete.tender_quote = ~tender_quote.id AND ~tender_item_complete.status = '1' ";
		$sqlstr.= "AND ~tender_quote.status != '0', ";
		$sqlstr.= "((~tender_item AS response LEFT JOIN ~tender_item_complete AS itemcompelte ";
		$sqlstr.= "ON response.id = itemcompelte.tender_item) LEFT JOIN ~tender_request AS request ";
		$sqlstr.= "ON request.tender_item =  response.id AND request.status = '1') LEFT JOIN ~tender_quote AS quote ";
		$sqlstr.= "ON quote.tender_item = response.id AND quote.status != '0', "; 
		$sqlstr.= "~tender, ts_users, ~organisation_branch branch, ";
		$sqlstr.= "~area, ~category_sub "; 
		$sqlstr.= "WHERE ~tender_item.tender = ~tender.id "; 
		$sqlstr.= "AND response.tender = ~tender.id ";
		$sqlstr.= "AND ~tender.user_id = ~users.id ";
		$sqlstr.= "AND ~users.branch = branch.id ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND ~tender_item.category_sub = ~category_sub.id ";	
		$sqlstr.= "AND ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender.user_id = ~users.id ";
		$sqlstr.= "AND ~users.branch = branch.id ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND ~tender_item.category_sub = ~category_sub.id ";
		if($this->tender['searchinfo']['tenderstatus'] || $this->tender['searchinfo']['tenderstatus'] === "0") {
			$sqlstr.= "AND ~tender.status = ".$this->tender['searchinfo']['tenderstatus']." ";
		}
		if($this->tender['searchinfo']['usersid']) {
			$sqlstr.= "AND ~users.id = ".$this->tender['searchinfo']['usersid']." ";
		}
		if($this->tender['searchinfo']['branchid']) {
			$sqlstr.= "AND branch.id = ".$this->tender['searchinfo']['branchid']." ";
		}
		if($this->tender['searchinfo']['organisationid']) {
			$sqlstr.= "AND ~users.organisation = ".$this->tender['searchinfo']['organisationid']." ";
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~area.id = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['stateid']) {
			$sqlstr.= "AND ~area.state = ".$this->tender['searchinfo']['stateid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		// GROUP BY
		$sqlstr.= "GROUP BY ts_tender_item.id, ts_tender_item_complete.status, ts_tender_item.status, "; 
		$sqlstr.= "ts_tender_item.model, ts_tender_item.brand, ts_tender_item.classification, ";
		$sqlstr.= "ts_tender_quote.quote_position, ";
		$sqlstr.= "ts_tender.id, ts_tender.rfq_number, ts_tender.created_date, "; 
		$sqlstr.= "ts_tender.created_time, ts_tender.close_date, ts_tender.close_time, "; 
		$sqlstr.= "ts_tender.classification, ts_tender.status, ";
		$sqlstr.= "branch.id, ";
		$sqlstr.= "ts_users.id, ";
		$sqlstr.= "ts_area.name, ";
		$sqlstr.= "ts_category_sub.name, "; 
		$sqlstr.= "response.id ";
		// ORDER BY
		if($this->tender['searchinfo']['firstsort'] == "created") {
			$sqlstr.= "ORDER BY ~tender.created_date DESC, ~tender.created_time DESC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "closed") {
			$sqlstr.= "ORDER BY ~tender.close_date DESC, ~tender.close_time DESC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "category") {
			$sqlstr.= "ORDER BY ~category_sub.name ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "area") {
			$sqlstr.= "ORDER BY ~area.name ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "brand") {
			$sqlstr.= "ORDER BY ~tender_item.brand ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "model") {
			$sqlstr.= "ORDER BY ~tender_item.model ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "sent") {
			$sqlstr.= "ORDER BY COUNT(DISTINCT ~tender_request.id) ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "received") {
			$sqlstr.= "ORDER BY COUNT(DISTINCT ~tender_quote.id)  ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "status") {
			$sqlstr.= "ORDER BY ~tender_item.status ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "rfqnumber") {
			$sqlstr.= "ORDER BY ~tender.rfq_number ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "tenderstatus") {
			$sqlstr.= "ORDER BY ~tender.status ASC ";
		}
		if($this->tender['searchinfo']['secondsort'] == "created") {
			$sqlstr.= ",~tender.created_date DESC, ~tender.created_time DESC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "closed") {
			$sqlstr.= ", ~tender.close_date DESC, ~tender.close_time DESC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "category") {
			$sqlstr.= ", ~category_sub.nam ";
		} elseif($this->tender['searchinfo']['secondsort'] == "area") {
			$sqlstr.= ", ~area.name ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "brand") {
			$sqlstr.= ", ~tender_item.brand ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "model") {
			$sqlstr.= ", ~tender_item.model ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "sent") {
			$sqlstr.= ", COUNT(DISTINCT ~tender_request.id) ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "received") {
			$sqlstr.= ", COUNT(DISTINCT ~tender_quote.id) ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "status") {
			$sqlstr.= ", ~tender_item.status ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "rfqnumber") {
			$sqlstr.= ", ~tender.rfq_number ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "tenderstatus") {
			$sqlstr.= ", ~tender.status ASC ";
		}
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} 
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		// get user info
		$new_user = new user;
		foreach($all as $key => $value) {
			$usersinfo = $new_user->get_info($value['usersid'],$cfg,$conn);
			$all[$key]['name'] = $usersinfo['name'];
			$all[$key]['surname'] = $usersinfo['surname'];
		}
		// get branch info
		$new_branch = new branch;
		foreach($all as $key => $value) {
			$branchinfo = $new_branch->get_info($value['branchid'],$cfg,$conn);
			$all[$key]['branchname'] = $branchinfo['name'];
		}
		return $all;
	}
	
	/**
	 * Returns information for bordereaux report
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tender items or FALSE on error  
	 */
	function search_bordereaux($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT ~tender_item.id, ";
		$sqlstr.= "~tender_quote.id AS quoteid, ~tender_quote.status, ~tender_quote.model, ";
		$sqlstr.= "~tender_quote.brand, ~tender_quote.price, ~tender_quote.description, ";
		$sqlstr.= "~tender_quote.quote_position, ~tender_quote.classification,";
		$sqlstr.= "~tender.id AS tenderid, ~tender.rfq_number, ~tender.classification AS tenderclassification,";
		$sqlstr.= "~tender.id AS created_date, ~tender.created_time, ~tender.close_date, ";
		$sqlstr.= "~tender.close_time, ~tender.status, ";
		$sqlstr.= "~tender_item_complete.payment_user, ~tender_item_complete.purchase_order, ~tender_item_complete.invoice_user,";
		$sqlstr.= "~tender_item.classification AS itemclassification, ~tender_item.status AS itemstatus, ";
		$sqlstr.= "agent.id AS agentid, ";
		$sqlstr.= "subscriber.id AS subscriberid, ";
		$sqlstr.= "~purchase_order.client_excess, ";
		$sqlstr.= "~area.name AS areaname, ";
		$sqlstr.= "~category_sub.name AS category_subname, ";
		$sqlstr.= "~tender_item_complete.created_date AS complete_date, ~tender_item_complete.created_time AS complete_time, ";
		$sqlstr.= "~category.name AS categoryname ";
		// FROM
		$sqlstr.= "FROM ~tender_item LEFT JOIN ~tender_item_complete ON ~tender_item.id = ~tender_item_complete.tender_item, ";
		$sqlstr.= "~tender, ~users subscriber, ~area, ";
		$sqlstr.= "~category_sub, ~tender_quote, ~purchase_order, ";
		$sqlstr.= "~users agent, ~category ";
		// WHERE
		$sqlstr.= "WHERE ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender.user_id = subscriber.id ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND ~tender_item.category_sub = ~category_sub.id ";
		$sqlstr.= "AND ~category_sub.category = ~category.id ";
		$sqlstr.= "AND ~tender.status != 0 ";
		$sqlstr.= "AND ~tender_item.status = 6 ";
		$sqlstr.= "AND ~tender_quote.id = ~tender_item_complete.tender_quote ";
		$sqlstr.= "AND ~tender_quote.user_id = agent.id ";
		$sqlstr.= "AND ~purchase_order.id = ~tender_item_complete.purchase_order ";
		if($this->tender['searchinfo']['tenderstatus'] || $this->tender['searchinfo']['tenderstatus'] === "0") {
			$sqlstr.= "AND ~tender.status = ".$this->tender['searchinfo']['tenderstatus']." ";
		}
		if(is_array($this->tender['searchinfo']['tender_itemid'])) {
			if(count($this->tender['searchinfo']['tender_itemid']) > 1) {
				$sqlstr.= "AND ( ~tender_item.id = ".$this->tender['searchinfo']['tender_itemid'][0]." ";
				for($i = 1; $i < count($this->tender['searchinfo']['tender_itemid']); $i++) {
					$sqlstr.= "OR ~tender_item.id = ".$this->tender['searchinfo']['tender_itemid'][$i]." ";
				}
				$sqlstr.= ") ";
			} elseif(count($this->tender['searchinfo']['tender_itemid']) == 1) {
				$sqlstr.= "AND ~tender_item.id = ".$this->tender['searchinfo']['tender_itemid'][0]." ";
			}
		}
		if($this->tender['searchinfo']['usersid']) {
			$sqlstr.= "AND subscriber.id = ".$this->tender['searchinfo']['usersid']." ";
		}
		if($this->tender['searchinfo']['branchid']) {
			$sqlstr.= "AND subscriber.id = ".$this->tender['searchinfo']['branchid']." ";
		}
		if($this->tender['searchinfo']['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->tender['searchinfo']['organisationid']." ";
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~area.id = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['stateid']) {
			$sqlstr.= "AND ~area.state = ".$this->tender['searchinfo']['stateid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		// ORDER BY
		if($this->tender['searchinfo']['firstsort'] == "created") {
			$sqlstr.= "ORDER BY ~tender.created_date DESC, ~tender.created_time DESC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "closed") {
			$sqlstr.= "ORDER BY ~tender.close_date DESC, ~tender.close_time DESC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "category") {
			$sqlstr.= "ORDER BY ~category_sub.name ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "area") {
			$sqlstr.= "ORDER BY ~area.name ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "brand") {
			$sqlstr.= "ORDER BY ~tender_quote.brand ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "model") {
			$sqlstr.= "ORDER BY ~tender_quote.model ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "sent") {
			$sqlstr.= "ORDER BY ~tender_quote.id ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "received") {
			$sqlstr.= "ORDER BY ~tender_quote.id ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "status") {
			$sqlstr.= "ORDER BY ~tender_item.status ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "rfqnumber") {
			$sqlstr.= "ORDER BY ~tender.rfq_number ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "tenderstatus") {
			$sqlstr.= "ORDER BY ~tender.status DESC ";
		}
		if($this->tender['searchinfo']['secondsort'] == "created") {
			$sqlstr.= ",~tender.created_date DESC, ~tender.created_time DESC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "closed") {
			$sqlstr.= ", ~tender.close_date DESC, ~tender.close_time DESC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "category") {
			$sqlstr.= ", ~category_sub.name ";
		} elseif($this->tender['searchinfo']['secondsort'] == "area") {
			$sqlstr.= ", ~area.name ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "brand") {
			$sqlstr.= ", ~tender_quote.brand ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "model") {
			$sqlstr.= ", ~tender_quote.model ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "sent") {
			$sqlstr.= ", ~tender_quote.id ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "received") {
			$sqlstr.= ", ~tender_quote.id ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "status") {
			$sqlstr.= ", ~tender_item.status ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "rfqnumber") {
			$sqlstr.= ", ~tender.rfq_number ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "tenderstatus") {
			$sqlstr.= ", ~tender.status DESC ";
		}
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} 
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		return $all;
	}
	
	/**
	 * Returns information for close report
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tender items or FALSE on error  
	 */
	function search_close($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT ~tender_item.id, ~tender_item.status, ~tender_item.model, ";
		$sqlstr.= "~tender_item.brand, ~tender_item.classification, ~tender_item.transaction_fee, ";
		$sqlstr.= "~tender.id AS tenderid, ~tender.rfq_number, ~tender.rfq_reference, ~tender.created_date, ";
		$sqlstr.= "~tender.created_time, ~tender.close_date, ~tender.close_time, ";
		$sqlstr.= "~tender.classification AS tenderclassification, ~tender.status as tenderstatus, ";
		$sqlstr.= "~tender_item_complete.tender_quote, ~tender_item_complete.invoice_user, ";
		$sqlstr.= "~tender_item_complete.status AS complete_status, ~tender_item_complete.payment_user, ";
		$sqlstr.= "branch.id AS branchid, ";
		$sqlstr.= "state.name AS statename, ";
		$sqlstr.= "~category.name AS categoryname, ";
		$sqlstr.= "~users.id AS usersid, ";
		$sqlstr.= "~area.name AS areaname, ";
		$sqlstr.= "~category_sub.name AS category_subname, ";
		$sqlstr.= "~tender_item.quote, ";
		$sqlstr.= "MIN(~tender_quote.price) AS bestprice, ";
		$sqlstr.= "MAX(~tender_quote.price) AS worstprice, ";
		$sqlstr.=" STDDEV(~tender_quote.price) AS std_dev,";
		$sqlstr.= "(~tender_item.quote - MIN(~tender_quote.price)) AS saving, ";
		$sqlstr.= "COUNT(DISTINCT ~tender_quote.id) AS received ";
		// FROM
		$sqlstr.= "FROM ~tender_quote, ";
		$sqlstr.= "~tender, ~users, ~organisation_branch branch, ";
		$sqlstr.= "~area, ~category_sub, ~area_state state, ";
		$sqlstr.= "~category, ";
		$sqlstr.= "~tender_item LEFT JOIN ~tender_item_complete ";
		$sqlstr.= "             ON ~tender_item_complete.tender_item = ~tender_item.id";
		$sqlstr.= "             AND ~tender_item_complete.status != '0' ";
		// WHERE
		$sqlstr.= "WHERE ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender.user_id = ~users.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~users.branch = branch.id ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND state.id = ~area.state ";
		$sqlstr.= "AND ~tender_quote.status != '0' ";
		$sqlstr.= "AND ~tender_item.category_sub = ~category_sub.id ";
		$sqlstr.= "AND ~category.id = ~category_sub.category ";
		$sqlstr.= "AND ~category_sub.status = '1' ";
		$sqlstr.= "AND ~tender.status > 3 ";
		if($this->tender['searchinfo']['tenderstatus'] || $this->tender['searchinfo']['tenderstatus'] === "0") {
			$sqlstr.= "AND ~tender.status = ".$this->tender['searchinfo']['tenderstatus']." ";
		}
		if($this->tender['searchinfo']['usersid']) {
			$sqlstr.= "AND ~users.id = ".$this->tender['searchinfo']['usersid']." ";
		}
		if($this->tender['searchinfo']['branchid']) {
			$sqlstr.= "AND branch.id = ".$this->tender['searchinfo']['branchid']." ";
		}
		if($this->tender['searchinfo']['organisationid']) {
			$sqlstr.= "AND ~users.organisation = ".$this->tender['searchinfo']['organisationid']." ";
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~area.id = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['stateid']) {
			$sqlstr.= "AND ~area.state = ".$this->tender['searchinfo']['stateid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		// GROUP BY
		$sqlstr.= "GROUP BY ~tender_item.id, ~tender_item.status, ~tender_item.model, ";
		$sqlstr.= "~tender_item.brand, ~tender_item.quote, ~tender_item.classification,";
		$sqlstr.= "~tender.id, ~tender.rfq_number, ~tender.rfq_reference, ~tender.created_date, ~tender.classification, ";
		$sqlstr.= "~tender.created_time, ~tender.close_date, ~tender.close_time, ";
		$sqlstr.= "~tender_item_complete.tender_quote, ~tender_item_complete.invoice_user, ~tender_item_complete.status, ~tender_item_complete.payment_user, ";
		$sqlstr.= "branch.id, ~tender_item.transaction_fee, ";
		$sqlstr.= "state.name, ";
		$sqlstr.= "~category.name, ";
		$sqlstr.= "~users.id, ";
		$sqlstr.= "~area.name, ";
		$sqlstr.= "~category_sub.name, ";
		$sqlstr.= "~tender.status ";
		// ORDER BY
		if($this->tender['searchinfo']['firstsort'] == "created") {
			$sqlstr.= "ORDER BY ~tender.created_date ASC, ~tender.created_time ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "closed") {
			$sqlstr.= "ORDER BY ~tender.close_date ASC, ~tender.close_time ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "category") {
			$sqlstr.= "ORDER BY ~category_sub.name ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "area") {
			$sqlstr.= "ORDER BY ~area.name ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "brand") {
			$sqlstr.= "ORDER BY ~tender_item.brand ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "model") {
			$sqlstr.= "ORDER BY ~tender_item.model ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "sent") {
			$sqlstr.= "ORDER BY COUNT(DISTINCT ~tender_quote.id) ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "received") {
			$sqlstr.= "ORDER BY COUNT(DISTINCT ~tender_quote.id) ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "status") {
			$sqlstr.= "ORDER BY ~tender_item.status ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "rfqnumber") {
			$sqlstr.= "ORDER BY ~tender.rfq_number ASC ";
		} elseif($this->tender['searchinfo']['firstsort'] == "tenderstatus") {
			$sqlstr.= "ORDER BY ~tender.status ASC ";
		}
		if($this->tender['searchinfo']['secondsort'] == "created") {
			$sqlstr.= ",~tender.created_date ASC, ~tender.created_time ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "closed") {
			$sqlstr.= ", ~tender.close_date ASC, ~tender.close_time ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "category") {
			$sqlstr.= ", ~category_sub.name ";
		} elseif($this->tender['searchinfo']['secondsort'] == "area") {
			$sqlstr.= ", ~area.name ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "brand") {
			$sqlstr.= ", ~tender_item.brand ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "model") {
			$sqlstr.= ", ~tender_item.model ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "sent") {
			$sqlstr.= ", COUNT(DISTINCT ~tender_quote.id) ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "received") {
			$sqlstr.= ", COUNT(DISTINCT ~tender_quote.id) ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "status") {
			$sqlstr.= ", ~tender_item.status ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "rfqnumber") {
			$sqlstr.= ", ~tender.rfq_number ASC ";
		} elseif($this->tender['searchinfo']['secondsort'] == "tenderstatus") {
			$sqlstr.= ", ~tender.status ASC ";
		}
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// Error in tender class
			$this->error[] = "260";
			// response
			return FALSE;
		}	
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		return $all;
	}
	
	/**
	 * Returns information for a companies fees
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders or FALSE on error  
	 */
	function search_company_fees($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT ~tender.id, ~tender.rfq_number,  ";
		$sqlstr.= "~tender.rfq_reference, ";
		$sqlstr.= "~organisation.user_fee, ";
		$sqlstr.= "~users.id AS usersid,   ";
		$sqlstr.= "SUM(~tender_item.transaction_fee) AS transaction_fee, ";
		$sqlstr.= "COUNT(~tender_item.id) AS item_count ";
		// FROM
		$sqlstr.= "FROM ~tender_item, ~tender, ~users, ~organisation ";
		// WHERE
		$sqlstr.= "WHERE ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender.user_id = ~users.id ";
		$sqlstr.= "AND ~tender.status != 0 ";
		$sqlstr.= "AND (~tender_item.status = 4 OR  ~tender_item.status = 6)";
		$sqlstr.= "AND ~tender.user_id = ~users.id ";
		$sqlstr.= "AND ~users.organisation = ~organisation.id ";
		if($this->tender['searchinfo']['usersid']) {
			$sqlstr.= "AND ~users.id = ".$this->tender['searchinfo']['usersid']." ";
		}
		if($this->tender['searchinfo']['branchid']) {
			$sqlstr.= "AND branch.id = ".$this->tender['searchinfo']['branchid']." ";
		}
		if($this->tender['searchinfo']['organisationid']) {
			$sqlstr.= "AND ~users.organisation = ".$this->tender['searchinfo']['organisationid']." ";
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~area.id = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['stateid']) {
			$sqlstr.= "AND ~area.state = ".$this->tender['searchinfo']['stateid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		// ORDER BY
		$sqlstr.= "GROUP BY ~tender.id, ~tender.rfq_number,  ";
		$sqlstr.= "~users.id, ~tender.rfq_reference, ~organisation.user_fee ";
		// ORDER BY
		$sqlstr.= "ORDER BY ~tender.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		// get user info
		$new_users = new user;
		foreach($all as $key => $value) {
			$users_info = $new_users->get_info($value['usersid'],$cfg,$conn);
			$all[$key]['name'] = $users_info['name'];
			$all[$key]['surname'] = $users_info['surname'];
		}
		return $all;
	}
	
	/**
	 * Returns message fees
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders or FALSE on error  
	 */
	function search_message_fees($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT SUM(~message_schedule.cost) AS message_fee ";
		// FROM
		$sqlstr.= "FROM ~message_schedule, ~users ";
		// WHERE
		$sqlstr.= "WHERE ~message_schedule.user_id = ~users.id ";
		if($this->tender['searchinfo']['organisationid']) {
			$sqlstr.= "AND ~users.organisation = ".$this->tender['searchinfo']['organisationid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~message_schedule.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~message_schedule.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	/**
	 * Returns active users
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders or FALSE on error  
	 */
	function search_active_agents($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT COUNT(DISTINCT ~users.id) AS active_agents ";
		// FROM
		$sqlstr.= "FROM ~tender_request, ~users ";
		// WHERE
		$sqlstr.= "WHERE ~tender_request.user_id = ~users.id ";
		if($this->tender['searchinfo']['supplierid']) {
			$sqlstr.= "AND ~users.organisation = ".$this->tender['searchinfo']['supplierid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender_request.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender_request.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	/**
	 * Returns information a balance score card report
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders or FALSE on error  
	 */
	function search_balance($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT supplier.id, ";
		$sqlstr.= "~tender_item_complete.rating, ";
		$sqlstr.= "SUM(~tender_quote.price) AS price ";
		// FROM
		$sqlstr.= "FROM ~tender_item, ~tender_item_complete, ~tender, ";
		$sqlstr.= "~organisation company, ~tender_quote, ~organisation supplier, ";
		$sqlstr.= "~users subscriber, ~users agent ";
		// WHERE
		$sqlstr.= "WHERE ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_item.id = ~tender_item_complete.tender_item ";
		$sqlstr.= "AND ~tender_quote.id = ~tender_item_complete.tender_quote ";
		$sqlstr.= "AND ~tender_quote.user_id = agent.id ";
		$sqlstr.= "AND agent.organisation = supplier.id ";
		$sqlstr.= "AND ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender.user_id = subscriber.id ";
		$sqlstr.= "AND ~tender.status = 6 ";
		$sqlstr.= "AND subscriber.organisation = company.id ";
		if($this->tender['searchinfo']['usersid']) {
			$sqlstr.= "AND subscriber.id = ".$this->tender['searchinfo']['usersid']." ";
		}
		if($this->tender['searchinfo']['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->tender['searchinfo']['branchid']." ";
		}
		if($this->tender['searchinfo']['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->tender['searchinfo']['organisationid']." ";
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~area.id = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['stateid']) {
			$sqlstr.= "AND ~area.state = ".$this->tender['searchinfo']['stateid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		// ORDER BY
		$sqlstr.= "GROUP BY supplier.id, supplier.name, ~tender_item_complete.rating ";
		$sqlstr.= " ";
		// ORDER BY
		$sqlstr.= "ORDER BY supplier.name ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg()." SQL:".$sqlstr;
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} elseif(!$all) {
			return $all;	
		}
		// get supplier info and group info
		$new_organisation = new organisation;
		foreach($all as $key => $value) {
			$organisation_info = $new_organisation->get_info($value['id'],$cfg,$conn);
			$all[$key]['suppliername'] = $organisation_info['name'];
		}
		return $all;
	}
	
	/**
	 * search for open tenders
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_open($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT DISTINCT ~tender.id, ~tender.rfq_number, ~tender.rfq_reference, ";
		$sqlstr.= "~tender.created_date, ~tender.created_time, ~tender.status, ";
		$sqlstr.= "~tender.close_date, ~tender.close_time, ";
		$sqlstr.= "subscriber.id AS usersid, ";
		$sqlstr.= "~area.name AS areaname, state.name AS statename, ";
		$sqlstr.= "~organisation.id AS organisationid ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber, ~area, ";
		$sqlstr.= "~category, ~category_sub, ~tender_item, ";
		$sqlstr.= "~tender_request, ~users agent, ~area_state state, ~organisation ";
		// WHERE
		$sqlstr.= "WHERE ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender.user_id = subscriber.id ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.user_id = agent.id ";
		$sqlstr.= "AND ~tender.status = 2 ";
		$sqlstr.= "AND subscriber.organisation = ~organisation.id ";
		$sqlstr.= "AND ~area.status = '1' ";
		$sqlstr.= "AND ~area.state = state.id ";
		$sqlstr.= "AND state.status = '1' ";
		if($this->tender['searchinfo']['agentid']) {
			$sqlstr.= "AND ~tender_request.user_id = ".$this->tender['searchinfo']['agentid']." ";
		}
		if($this->tender['searchinfo']['supplierid']) {
			$sqlstr.= "AND agent.organisation = ".$this->tender['searchinfo']['supplierid']." ";
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~area.id = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['stateid']) {
			$sqlstr.= "AND ~area.state = ".$this->tender['searchinfo']['stateid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		// ORDER BY
		$sqlstr.= " ORDER BY ~tender.close_date DESC, ~tender.close_time DESC, ~tender.id DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} 
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		// get subscriber info
		$new_users = new user;
		foreach($all as $key => $value) {
			$users_info = $new_users->get_info($value['usersid'],$cfg,$conn);
			$all[$key]['name'] = $users_info['name'];
			$all[$key]['surname'] = $users_info['surname'];
			$all[$key]['email'] = $users_info['email'];
			$all[$key]['phone_prefix'] = $users_info['phone_prefix'];
			$all[$key]['phone_work'] = $users_info['phone_work'];
		}
		// get organisation info
		$new_organisation = new organisation;
		foreach($all as $key => $value) {
			$organisation_info = $new_organisation->get_info($value['organisationid'],$cfg,$conn);
			$all[$key]['organisationname'] = $organisation_info['name'];
		}
		return $all;
	}
	
	/**
	 * search for all tenders
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_all($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT DISTINCT ~tender.id, ~tender.rfq_number, ~tender.rfq_reference, ";
		$sqlstr.= "~tender.created_date, ~tender.created_time, ~tender.status, ";
		$sqlstr.= "~tender.close_date, ~tender.close_time, ";
		$sqlstr.= "subscriber.id AS usersid, ";
		$sqlstr.= "~area.name AS areaname, state.name AS statename, ";
		$sqlstr.= "~organisation.id AS organisationid ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber, ~area, ";
		$sqlstr.= "~category, ~category_sub, ~tender_item, ";
		$sqlstr.= "~tender_request, ~users agent, ~area_state state, ~organisation ";
		// WHERE
		$sqlstr.= "WHERE ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender.user_id = subscriber.id ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.user_id = agent.id ";
		$sqlstr.= "AND subscriber.organisation = ~organisation.id ";
		$sqlstr.= "AND ~area.status = '1' ";
		$sqlstr.= "AND ~area.state = state.id ";
		$sqlstr.= "AND state.status = '1' ";
		if($this->tender['searchinfo']['agentid']) {
			$sqlstr.= "AND ~tender_request.user_id = ".$this->tender['searchinfo']['agentid']." ";
		}
		if($this->tender['searchinfo']['supplierid']) {
			$sqlstr.= "AND agent.organisation = ".$this->tender['searchinfo']['supplierid']." ";
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~area.id = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['stateid']) {
			$sqlstr.= "AND ~area.state = ".$this->tender['searchinfo']['stateid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		// ORDER BY
		$sqlstr.= " ORDER BY ~tender.close_date DESC, ~tender.close_time DESC, ~tender.id DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		// get subscriber info
		$new_users = new user;
		foreach($all as $key => $value) {
			$users_info = $new_users->get_info($value['usersid'],$cfg,$conn);
			$all[$key]['name'] = $users_info['name'];
			$all[$key]['surname'] = $users_info['surname'];
			$all[$key]['email'] = $users_info['email'];
			$all[$key]['phone_prefix'] = $users_info['phone_prefix'];
			$all[$key]['phone_work'] = $users_info['phone_work'];
		}
		// get organisation info
		$new_organisation = new organisation;
		foreach($all as $key => $value) {
			$organisation_info = $new_organisation->get_info($value['organisationid'],$cfg,$conn);
			$all[$key]['organisationname'] = $organisation_info['name'];
		}
		return $all;
	}
	
	/**
	 * find open tender items
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_open_tender_item($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT DISTINCT ~tender_item.id, ~tender_item.brand, ~tender_item.model, ";
		$sqlstr.= "~category.name AS categoryname, ~category_sub.name AS category_subname, ";
		$sqlstr.= "~tender_item.description, ~tender_item.quote, ~tender_item.budget, ";
		$sqlstr.= "~tender.id AS tenderid, ";
		$sqlstr.= "COUNT(~tender_request.id) AS sent ";
		// FROM
		$sqlstr.= "FROM ~tender_item, ~tender, ~tender_request, ~category, ~category_sub, ~users agent ";
		// WHERE
		$sqlstr.= "WHERE ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.user_id = agent.id ";
		$sqlstr.= "AND ~tender.status = 2 ";
		$sqlstr.= "AND ~tender_item.category_sub = ~category_sub.id ";
		$sqlstr.= "AND ~category.id = ~category_sub.category ";
		if($this->tender['searchinfo']['agentid']) {
			$sqlstr.= "AND ~tender_request.user_id = ".$this->tender['searchinfo']['agentid']." ";
		}
		if($this->tender['searchinfo']['supplierid']) {
			$sqlstr.= "AND agent.organisation = ".$this->tender['searchinfo']['supplierid']." ";
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~tender.area = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		// GROUP BY
		$sqlstr.= "GROUP BY ~tender_item.id, ~tender_item.brand, ~tender_item.model, ";
		$sqlstr.= "~category.name, ~category_sub.name, ";
		$sqlstr.= "~tender_item.description, ~tender_item.quote, ~tender_item.budget, ";
		$sqlstr.= "~tender.id ";
		// ORDER BY
		$sqlstr.= " ORDER BY ~tender_item.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		return $all;
	}
	
	/**
	 * search for closed tenders
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_closed($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT DISTINCT ~tender.id, ~tender.rfq_number, ~tender.rfq_reference, ";
		$sqlstr.= "~tender.close_date, ~tender.created_date, ~tender.created_time, ";
		$sqlstr.= "~tender.close_time, ~tender.classification, ";
		$sqlstr.= "subscriber.id AS usersid, ";
		$sqlstr.= "subscriber.organisation AS organisationid, ";
		$sqlstr.= "~area.name AS areaname, state.name AS statename, ";
		$sqlstr.= "~organisation.id AS organisationid ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber, ~area, ";
		$sqlstr.= "~category, ~category_sub, ~tender_item, ";
		$sqlstr.= "~tender_request, ~users agent, ~area_state state, ~organisation ";
		// WHERE
		$sqlstr.= "WHERE ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender.user_id = subscriber.id ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.user_id = agent.id ";
		$sqlstr.= "AND ~tender.status = 4 ";
		$sqlstr.= "AND subscriber.organisation = ~organisation.id ";
		$sqlstr.= "AND ~area.state = state.id ";
		if($this->tender['searchinfo']['agentid']) {
			$sqlstr.= "AND ~tender_request.user_id = ".$this->tender['searchinfo']['agentid']." ";
		}
		if($this->tender['searchinfo']['supplierid']) {
			$sqlstr.= "AND agent.organisation = ".$this->tender['searchinfo']['supplierid']." ";
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~area.id = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['stateid']) {
			$sqlstr.= "AND ~area.state = ".$this->tender['searchinfo']['stateid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		// ORDER BY
		$sqlstr.= " ORDER BY ~tender.close_date DESC, ~tender.close_time DESC, ~tender.id DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		// get subscriber info
		$new_users = new user;
		foreach($all as $key => $value) {
			$users_info = $new_users->get_info($value['usersid'],$cfg,$conn);
			$all[$key]['name'] = $users_info['name'];
			$all[$key]['surname'] = $users_info['surname'];
			$all[$key]['email'] = $users_info['email'];
			$all[$key]['phone_prefix'] = $users_info['phone_prefix'];
			$all[$key]['phone_work'] = $users_info['phone_work'];
		}
		// get organisation info
		$new_organisation = new organisation;
		foreach($all as $key => $value) {
			$organisation_info = $new_organisation->get_info($value['organisationid'],$cfg,$conn);
			$all[$key]['organisationname'] = $organisation_info['name'];
		}
		return $all;
	}
	
	/**
	 * search for closed tender quotes
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_closed_tender_quote($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT ~tender_quote.id, ~tender_quote.user_id, ~tender_quote.tender_item, ";
		$sqlstr.= "~tender_quote.price, ~tender_quote.brand, ~tender_quote.model, ";
		$sqlstr.= "~tender_quote.description, ~tender_quote.stock, ~tender_quote.status, ";
		$sqlstr.= "~tender_quote.valid_until, ~tender_quote.quote_position, ~tender_quote.classification, ";
		$sqlstr.= "~tender_item.model AS itemmodel, ~tender_item.description AS itemdescription, ";
		$sqlstr.= "~tender_item.budget, ~tender_item.brand AS itembrand, ~tender_item.classification AS itemclassification, ";
		$sqlstr.= "~tender.id AS tenderid, ~tender.classification AS tenderclassification, ";
		$sqlstr.= "~category.name AS categoryname, ~category_sub.name AS category_subname, ";
		$sqlstr.= "agent.id AS agentid ";
		// FROM
		$sqlstr.= "FROM ~tender_item, ~tender, ~tender_quote, ~users agent, ~category, ~category_sub ";
		// WHERE
		$sqlstr.= "WHERE ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.user_id = agent.id ";
		$sqlstr.= "AND ~tender.status = 4 ";
		$sqlstr.= "AND ~tender_quote.status = 4 ";
		$sqlstr.= "AND ~tender_item.category_sub = ~category_sub.id ";
		$sqlstr.= "AND ~category.id = ~category_sub.category ";
		if($this->tender['searchinfo']['agentid']) {
			$sqlstr.= "AND ~tender_quote.user_id = ".$this->tender['searchinfo']['agentid']." ";
		}
		if($this->tender['searchinfo']['supplierid']) {
			$sqlstr.= "AND agent.organisation = ".$this->tender['searchinfo']['supplierid']." ";
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~tender.area = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		// ORDER BY
		$sqlstr.= " ORDER BY ~tender_quote.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		// get agent info
		$new_users = new user;
		foreach($all as $key => $value) {
			$users_info = $new_users->get_info($value['agentid'],$cfg,$conn);
			$all[$key]['name'] = $users_info['name'];
			$all[$key]['surname'] = $users_info['surname'];
		}
		return $all;
	}
	
	/**
	 * search for awarded tenders
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_award($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT DISTINCT ~tender.id, ~tender.rfq_number, ~tender.rfq_reference, ";
		$sqlstr.= "~tender.created_date, ~tender.created_time, ~tender.close_date, ";
		$sqlstr.= "~tender.close_time, ~tender.status, ~tender.classification,";
		$sqlstr.= "subscriber.id AS usersid, ";
		$sqlstr.= "~area.name AS areaname, state.name AS statename, ";
		$sqlstr.= "~organisation.id AS organisationid ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber, ~area, ";
		$sqlstr.= "~category, ~category_sub, ~tender_item, ";
		$sqlstr.= "~tender_quote, ~users agent, ~area_state state, ~organisation ";
		// WHERE
		$sqlstr.= "WHERE ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender.user_id = subscriber.id ";
		$sqlstr.= "AND ~tender.area = ~area.id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		//$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		//$sqlstr.= "AND ~tender_request.user_id = agent.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.user_id = agent.id ";
		$sqlstr.= "AND ~tender.status = 6 ";
		$sqlstr.= "AND subscriber.organisation = ~organisation.id ";
		$sqlstr.= "AND ~area.status = '1' ";
		$sqlstr.= "AND ~area.state = state.id ";
		$sqlstr.= "AND state.status = '1' ";
		if($this->tender['searchinfo']['agentid']) {
			//$sqlstr.= "AND ~tender_request.user_id = ".$this->tender['searchinfo']['agentid']." ";
			$sqlstr.= "AND ~tender_quote.user_id = ".$this->tender['searchinfo']['agentid']." ";
		}
		if($this->tender['searchinfo']['supplierid']) {
			$sqlstr.= "AND agent.organisation = ".$this->tender['searchinfo']['supplierid']." ";			
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~area.id = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['stateid']) {
			$sqlstr.= "AND ~area.state = ".$this->tender['searchinfo']['stateid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		// ORDER BY
		$sqlstr.= " ORDER BY ~tender.close_date DESC, ~tender.close_time DESC, ~tender.id DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} 
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		// get subscriber info
		$new_users = new user;
		foreach($all as $key => $value) {
			$users_info = $new_users->get_info($value['usersid'],$cfg,$conn);
			$all[$key]['name'] = $users_info['name'];
			$all[$key]['surname'] = $users_info['surname'];
			$all[$key]['email'] = $users_info['email'];
			$all[$key]['phone_prefix'] = $users_info['phone_prefix'];
			$all[$key]['phone_work'] = $users_info['phone_work'];
		}
		// get organisation info
		$new_organisation = new organisation;
		foreach($all as $key => $value) {
			$organisation_info = $new_organisation->get_info($value['organisationid'],$cfg,$conn);
			$all[$key]['organisationname'] = $organisation_info['name'];
		}
		return $all;
	}
	
	/**
	 * search for awarded tender quotes
	 * 
	 * @param array params search infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function search_award_tender_quote($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT ~tender_quote.id, ~tender_quote.user_id, ~tender_quote.tender_item, ";
		$sqlstr.= "~tender_quote.price, ~tender_item.quote, ~tender_item.budget,  ";
		$sqlstr.= "~tender_quote.brand, ~tender_quote.model, ~tender_quote.description, ";
		$sqlstr.= "~tender_quote.stock, ~tender_quote.status, ~tender_quote.valid_until, ";
		$sqlstr.= "~tender_quote.quote_position, ~tender_quote.classification, ";
		$sqlstr.= "~tender.id AS tenderid, ";
		$sqlstr.= "~category.name AS categoryname, ";
		$sqlstr.= "~category_sub.name AS category_subname, ";
		$sqlstr.= "~tender_item.brand AS itembrand, ~tender_item.model AS itemmodel, ~tender_item.description AS itemdescription,";
		$sqlstr.= "~tender_item.classification AS itemclassification, ";
		$sqlstr.= "agent.id AS agentid ";
		// FROM
		$sqlstr.= "FROM ~tender_item, ~tender, ~tender_quote, ~users agent, ~category, ~category_sub ";
		// WHERE
		$sqlstr.= "WHERE ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.user_id = agent.id ";
		$sqlstr.= "AND ~tender.status = 6 ";
		$sqlstr.= "AND ~tender_item.category_sub = ~category_sub.id ";
		$sqlstr.= "AND ~category.id = ~category_sub.category ";
		if($this->tender['searchinfo']['agentid']) {
			$sqlstr.= "AND ~tender_quote.user_id = ".$this->tender['searchinfo']['agentid']." ";
		}
		if($this->tender['searchinfo']['supplierid']) {
			$sqlstr.= "AND agent.organisation = ".$this->tender['searchinfo']['supplierid']." ";
		}
		if($this->tender['searchinfo']['areaid']) {
			$sqlstr.= "AND ~tender.area = ".$this->tender['searchinfo']['areaid']." ";
		}
		if($this->tender['searchinfo']['startdate']) {
			$sqlstr.= "AND ~tender.created_date >= '".$this->tender['searchinfo']['startdate']."' ";
		}
		if($this->tender['searchinfo']['enddate']) {
			$sqlstr.= "AND ~tender.created_date <= '".$this->tender['searchinfo']['enddate']."' ";
		}
		// ORDER BY
		$sqlstr.= " ORDER BY agent.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// Error in tender class
			$this->error[] = "315";
			// response
			return FALSE;
		}
		// change time to proper format
		$new_database->convertTime($all,$cfg);
		// get agent info
		$new_users = new user;
		foreach($all as $key => $value) {
			$users_info = $new_users->get_info($value['agentid'],$cfg,$conn);
			$all[$key]['name'] = $users_info['name'];
			$all[$key]['surname'] = $users_info['surname'];
		}
		return $all;
	}
	
	function set_tender_item_invoice($id,$usersid,$cfg,$conn) {
		$new_database = new database;
		$update['invoice_user'] = $usersid;
		$new_database->setTime("invoice",$update,"",$cfg);
		$where = " tender_item = ".$id." ";
		if(!$new_database->update_table("~tender_item_complete",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in Category Class
			$this->error[] = "315";
			return FALSE;
		} 
		// return that category_brand deleted
      	return TRUE;
	}
	
	function set_tender_item_payment($id,$usersid,$cfg,$conn) {
		$new_database = new database;
		$update['payment_user'] = $usersid;
		$new_database->setTime("payment",$update,"",$cfg);
		$where = " tender_item = ".$id." AND (invoice_user != 0 OR invoice_user IS NOT NULL) ";
		if(!$new_database->update_table("~tender_item_complete",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in Category Class
			$this->error[] = "315";
			return FALSE;
		} 
		// return that category_brand deleted
      	return TRUE;
	}
	
	/**
	 * Returns information for group by quote report
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed array of tenders or FALSE on error  
	 */
	function rfqsearch($params,$cfg,$conn) {
		$this->tender = $params;
		$sqlstr = "SELECT DISTINCT ~tender.rfq_number, ~tender.rfq_reference ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users ";
		// WHERE
		$sqlstr.= "WHERE ~tender.rfq_number like '%".$this->tender['searchinfo']['rfqnumber']."%' ";
		$sqlstr.= "AND ~tender.rfq_reference like '%".$this->tender['searchinfo']['rfqreference']."%' ";
		$sqlstr.= "AND ~tender.user_id = ~users.id ";
		if($this->tender['searchinfo']['usersid']) {
			$sqlstr.= "AND ~users.id = ".$this->tender['searchinfo']['usersid']." ";
		}
		if($this->tender['searchinfo']['branchid']) {
			$sqlstr.= "AND ~users.branch = ".$this->tender['searchinfo']['branchid']." ";
		}
		if($this->tender['searchinfo']['organisationid']) {
			$sqlstr.= "AND ~users.organisation = ".$this->tender['searchinfo']['organisationid']." ";
		}
		// ORDER BY
		if($this->tender['searchinfo']['rfqreference']) {
			$sqlstr.= " ORDER BY ~tender.rfq_reference ASC ";
		} else {
			$sqlstr.= " ORDER BY ~tender.rfq_number ASC ";
		}
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $all;
	}
}
?>