<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Login
* @package TenderSystem
* @subpackage session
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// login the user
require_once($cfg['file'].'modules/password/class/password.class.php');
require_once($cfg['file'].'modules/generic/class/file.class.php');

$new_session = new session;
$login = $new_session->login($params,$cfg,$conn);
// instantiate the xml object
$new_xml = new xml;

// if offsite login
if ($params['offsite']) {
	$xml_params['offsite'] = "true";
}
// error handling
if (!$login || !$new_session->user['id']) {
	// set the username
	$xml_params['username'] = $params['username'];
	// generate the xml
	$xml = $new_xml->xml_generator("session","login",$new_session->error,$xml_params,"",$cfg);
} else {
 	// determine if password must be reset
 	if ($new_session->user['status'] == "2") {
		// set the session paramaters
		$xml_params['session'] = $new_session->user['session'];
		$xml_params['md'] = $new_session->user['password'];
		// generate the xml
		$xml = $new_xml->xml_generator("password","change","",$xml_params,$new_session->user,$cfg);
 	} else {
		// NOTE: Do not get the control panel information as the page is first reset
		// set the session paramaters
		$xml_params['session'] = $new_session->user['session'];
		$user = $new_session->user;
		// determine which user type is loging in
		$new_file = new file;
		$new_file->link_api_find("user","control",$xml_params,$user,$cfg,$conn);
		$xml_params['next_module'] = $params['next_module'];
		$xml_params['next_function'] = $params['next_function']; 
		$xml = $new_xml->xml_generator("user","control",$new_session->error,$xml_params,$user,$cfg);
 	}
}
?>