<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Display settings
* @package TenderSystem
* @subpackage settings
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "2";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	// include settings class
	require($cfg['file'].'modules/settings/class/settings.class.php');
	require($cfg['file'].'modules/generic/class/file.class.php');
	require($cfg['file'].'modules/generic/class/message.class.php');
	require($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	$settings['availablelang'] = $params['availablelang'];
	$settings['availabletheme'] = $params['availabletheme'];
	// instantiate object
	$new_settings = new settings($params['settings_type']);
	// login the user
	$file = $cfg['file']."modules/settings/config.inc.php";
	if(!is_writable($file)) {
		$settings['readonly'] = '1';
	}
	if($params['newappsettings']) {
		if(end($params['newappsettings']) == "on" && key($params['newappsettings']) == "smtptest") {
			$testsmtp = array_pop($params['newappsettings']);
		} elseif(end($params['newappsettings']) == "on" && key($params['newappsettings']) == "smstest") {
			$testsms = array_pop($params['newappsettings']);
		} elseif(end($params['newappsettings']) == "on" && key($params['newappsettings']) == "passwordrenewal") {
			$password = array_pop($params['newappsettings']);
		}
		$writesuccess = $new_settings->set_settings($file,$params['newappsettings'],$cfg);
		if($writesuccess) {
			$settings['updated'] = "1";
			// reload settings
			require($cfg['file'].'modules/settings/config.inc.php');
		}
		// send a test email
		if($testsmtp) {
			$new_message = new message;
			$message['classification'] = "test_smtp";
			$message['subject'] = "Testing the SMTP";
			$message['body'] = "<b>This is a test email.</b>";
			$message['name'] = $message['reference'] = $user['name']." ".$user['surname'];
			$message['email'] = $user['email'];
			// send now
			$cfg['message']['schedule']['status'] = FALSE;
			if($new_message->send_email_message($message,$user['id'],$user['id'],$cfg,$conn)) {
				$settings['sentmessage'] = "1";
			} elseif(!empty($new_message->error)) {
				$new_settings->error = array_merge($new_settings->error,$new_message->error);
				$new_settings->error[] = "e3";
			}
		}
		// send a test sms
		if($testsms) {
			$new_message = new message;
			$message['classification'] = "test_smtp";
			$message['subject'] = "Testing the SMTP";
			$message['body'] = "This is a test sms.";
			$message['name'] = $message['reference'] = $user['name']." ".$user['surname'];
			$message['phone_mobile'] = $user['phone_mobile'];
			$message['phone_prefix'] = $user['phone_prefix'];
			if($new_message->send_sms_message($message,$user['id'],$user['id'],$cfg,$conn)) {
				$settings['sentmessage'] = "1";
			} else {
				$new_settings->error[] = "e4";
			}
		}
		
		// set to status 2
		if($password) {
			$new_users = new user;
			if($new_users->password_renew($cfg,$conn)) {
				$settings['password_renewed'] = "1";
			} elseif(!empty($new_users->error)) {
				$new_settings->error = array_merge($new_settings->error,$new_users->error);
			}
		}
	}
	// get clickatell info
	if($params['settings_type'] == "sms" && $cfg['sms']['status']) {
		$new_message = new message;
		$settings['balance'] = $new_message->create_sms_session($cfg,$conn);
	}
	$settings['settings'][0] = $new_settings->get_settings($file,$params['settings_type'],$cfg);
	// error handling
	if (!$settings['settings'][0]) {
		// generate the xml
		$xml = $new_xml->xml_generator("settings",$params['settings_type'],$new_settings->error,"",$user,$cfg);
	} else{
		// generate the xml
		$xml = $new_xml->xml_generator("settings",$params['settings_type'],$new_settings->error,$settings,$user,$cfg);
	}
}
?>