<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* API config settings
* @package TenderSystem
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

/**
* TenderSystem default configuration
* 	version:	TenderSystem version
* 	theme:		default theme (must also be set in gui config)
* 	lang:		default language (must also be set in gui config)
* 	url:		gui url
* 	password
* 	- salt schemes
* 		1 - hash(password)
* 		2 - hash(password+salt)
*		3 - hash(hash(password) + salt)
*		4 - hash(hash(password) + hash(salt))
* 	- hash
*/
$cfg['version'] = '0.9.5';
$cfg['header'] = 'TenderSystem Open Source Procurement';
$cfg['theme'] = 'blue';
$cfg['language'] = 'en';
$cfg['local']['precurrency'] = '$';
$cfg['local']['postcurrency'] = '';
$cfg['url'] = 'http://localhost/tendersystem/php_sourceforge_script.php';
// NOTICE : MUST CHANGE THIS ON THE GUI AS WELL
$cfg['password']['salt']['pre'] = 'wall';
$cfg['password']['salt']['post'] = 'pipe';
$cfg['password']['scheme'] = '2';
$cfg['password']['hash'] = 'md5';
// whether or not to display error codes
$cfg['error']['codes'] = TRUE;

/**
* Database configuration
* 	type:		database type - either mysql, postgresql and should work with oracle
* 	host:		database host
* 	name:		database name
* 	user:		username
* 	password:	password
*	prefix		database prefix
*/

// option of running sql on multiple database (for developers)
$cfg['multiple']['dsn'] = FALSE;
// log difference between multiple databases
$cfg['multiple']['error'] = './log/multiple_error.log';
$cfg['multiple']['time'] = './log/time.log';
// first database connection
$cfg['dsn']['0']['conn'] = 'postgres7://valuecard_test:valuecard@192.168.1.100/valuecard_test?persist&port=5432';
$cfg['dsn']['0']['prefix'] = 'ts_';
// how the next id is retrieved (sequence or query)
$cfg['dsn']['0']['next_id'] = 'query';
$cfg['dsn']['0']['transaction']['enable'] = TRUE;
// more database connection for multiple
$cfg['dsn']['1']['conn'] = 'postgres7://valuecard_test:valuecard@192.168.1.100/valuecard_test?persist&port=5432';
$cfg['dsn']['2']['conn'] = 'mysql://tendersystem:tendersystem@localhost/tendersystem?persist&port=3306';
//$cfg['dsn']['ora']['conn'] = 'oci8po://tendersystem:tendersystem@localhost/tendersy?charset=WE8MSWIN1252&port=1521';
//$cfg['dsn']['3']['conn'] = 'postgres7://tendersystem:tendersystem@192.168.1.8/tendersystem?persist&port=5432';
//$cfg['dsn']['4']['conn'] = 'mysql://tendersystem:tendersystem@192.168.1.8/tendersystem?persist&port=3306';
//$cfg['dsn']['5']['conn'] = 'sqlitepo://%2Fhome%2Fgrant%2Fwork%2Ftendersystem%2Fapplication%2Finclude%2Ftendersystem/';


/**
* SMTP configuration
* 	status:		status of smtp server
* 	server:		smtp server
* 	port:		smtp port
* 	blob:		store message in database as a blob field
* 	from:		name from which emails are sent
* 	tender:		email from which tender invitation is sent
* 		email:		tender email address
* 	support		email from which support messages is sent
* 		email:		support email address
* 	feedback:	email from which feedback request is sent
* 		email:		feedback email address
* 	backup:		backup email address
* 		status:		wether or not to BCC all messages to a backup address
* 		address:	backup email address
* 	keyword :
* 		if a email contains this keyword, forward to super administrators
*/
$cfg['smtp']['status'] = FALSE;
$cfg['smtp']['server'] = 'SMTP_IP';
$cfg['smtp']['port'] = '25';
$cfg['smtp']['helo'] = 'test';
$cfg['smtp']['auth'] = FALSE;
$cfg['smtp']['user'] = 'test';
$cfg['smtp']['password'] = 'test';
$cfg['smtp']['encoding'] = 'quoted-printable';
$cfg['smtp']['blob'] = TRUE;
$cfg['smtp']['from'] = 'TenderSystem';
$cfg['smtp']['tender']['email'] = 'quote@EMAIL.ADRESS';
$cfg['smtp']['tender']['emailpriority'] = TRUE;
$cfg['smtp']['message'] = 'This message was sent from the TenderSystem Open Source. If you received this email in error please notify the sender immediately.';
$cfg['smtp']['disclaimer'] = 'This message contains privileged and confidential information intended only for the person or entity to[br] which it is addressed. Any review, retransmission, dissemination, copy or other use of, or taking of any[br] action in reliance upon this information by persons] or entities other than the intended recipient, is [br] prohibited. If you received this message in error, please notify the sender immediately by e-mail, [br] facsimile or telephone and thereafter delete the material from any computer. ValueCard, its[br] subsidiaries or associates do not accept liability for any personal views expressed in this message.';
$cfg['smtp']['sourceforge'] = TRUE;
$cfg['smtp']['support']['email'] = 'support@EMAIL.ADRESS';
$cfg['smtp']['support']['emailpriority'] = TRUE;
$cfg['smtp']['backup']['status'] = FALSE;
$cfg['smtp']['backup']['email'] = 'backup@EMAIL.ADRESS';
$cfg['smtp']['keyword']['0'] = 'postmaster';
$cfg['smtp']['keyword']['1'] = 'The Postfix program';
$cfg['smtp']['keyword']['2'] = 'Recipient address rejected';
$cfg['smtp']['receipt']['img']['enable'] = TRUE;

/**
* Message configuration
* 	schedule:	schedule messages if there was a problem
* 	attempts:	number of times to try and send scheduled message
* 	time:		minimum seconds before scheduling
* 	go:			tries to send before scheduling
* 	logs:		number of logs to display in the message log field
*/
$cfg['message']['schedule']['status'] = TRUE;
$cfg['message']['schedule']['attempts'] = '5';
$cfg['message']['schedule']['time'] = '600';
$cfg['message']['schedule']['go'] = TRUE;
$cfg['message']['logs'] = '10';

/**
* POP Configuration
* 	status:		status of pop server
* 	server:		pop server
* 	port:		port port
* 	notype:		binary save emails with no type
* 	tender:		email to which tender response is sent
* 		name:	username to access the mailbox
* 		password:	password to read mail
* 	feedback:	email to which feedback response is sent
* 		name:	username to access the mailbox
* 		password:	password to read mail
*/
$cfg['pop']['status'] = FALSE;
$cfg['pop']['server'] = 'POP_IP_ADRESS';
$cfg['pop']['port'] = '110';
$cfg['pop']['tender']['username'] = 'POP_USERNAME';
$cfg['pop']['tender']['password'] = 'POP_PASSWORD';
$cfg['pop']['notype'] = TRUE;

/**
* SMS configuration (visit www.clickatell.com for further information)
* 	status:		wether or not to send sms notifications if elected by supplier
* 	code:		internatioal code
* 	username:	sms username
* 	password:	sms password
* 	id:			sms id
* 	urlauth:	url to authenticate username, password and id
* 	urlsend:	url to send SMS cannot be SSL as file() used
* 	ipaddress:	array valid incoming ip address
*   receipt:    wether to check delivery status of sms
*               valid values are : "callback", "query", FALSE
*/
$cfg['sms']['status'] = FALSE;
$cfg['sms']['code'] = '1';
$cfg['sms']['api_id'] = 'SMS_ID';
$cfg['sms']['user'] = 'SMS_USERNAME';
$cfg['sms']['password'] = 'SMS_PASSWORD';
$cfg['sms']['urlsend'] = 'http://api.clickatell.com/http/sendmsg';
$cfg['sms']['receipt'] = 'query';

/**
* Time configuration
* 	open:		business opening hour
* 	close:		business closing hour
* 		Note: Array key is the weekday 0 = Sunday 6 = Saturday
*/
$cfg['date']['format'] = 'd F Y';
$cfg['time']['format'] = 'H:i:s';
$cfg['time']['open']['0'] = '0';
$cfg['time']['close']['0'] = '0';
$cfg['time']['open']['1'] = '8';
$cfg['time']['close']['1'] = '17';
$cfg['time']['open']['2'] = '8';
$cfg['time']['close']['2'] = '17';
$cfg['time']['open']['3'] = '8';
$cfg['time']['close']['3'] = '17';
$cfg['time']['open']['4'] = '8';
$cfg['time']['close']['4'] = '17';
$cfg['time']['open']['5'] = '8';
$cfg['time']['close']['5'] = '17';
$cfg['time']['open']['6'] = '8';
$cfg['time']['close']['6'] = '13';

$cfg['time']['lunch']['start']['hour'] = '0';
$cfg['time']['lunch']['start']['min'] = '00';
$cfg['time']['lunch']['end']['hour'] = '0';
$cfg['time']['lunch']['end']['min'] = '00';

$cfg['holiday']['0']['name'] = 'New Years Day';
$cfg['holiday']['0']['date'] = '01-01';
$cfg['holiday']['1']['name'] = '';
$cfg['holiday']['1']['date'] = '';
$cfg['holiday']['1']['name'] = '';
$cfg['holiday']['2']['date'] = '';
$cfg['holiday']['2']['name'] = '';
$cfg['holiday']['3']['date'] = '';
$cfg['holiday']['3']['name'] = '';
$cfg['holiday']['4']['date'] = '';
$cfg['holiday']['4']['name'] = '';
$cfg['holiday']['5']['date'] = '';
$cfg['holiday']['5']['name'] = '';
$cfg['holiday']['6']['date'] = '';
$cfg['holiday']['6']['name'] = '';
$cfg['holiday']['7']['date'] = '';
$cfg['holiday']['7']['name'] = '';
$cfg['holiday']['8']['date'] = '';
$cfg['holiday']['8']['name'] = '';
$cfg['holiday']['9']['date'] = '';
$cfg['holiday']['9']['name'] = '';
$cfg['holiday']['10']['name'] = '';
$cfg['holiday']['10']['date'] = '';
$cfg['holiday']['11']['name'] = '';
$cfg['holiday']['11']['date'] = '';
$cfg['holiday']['11']['name'] = '';
$cfg['holiday']['12']['date'] = '';
$cfg['holiday']['12']['name'] = '';
$cfg['holiday']['13']['date'] = '';
$cfg['holiday']['13']['name'] = '';
$cfg['holiday']['14']['date'] = '';
$cfg['holiday']['14']['name'] = '';
$cfg['holiday']['15']['date'] = '';
$cfg['holiday']['15']['name'] = '';
$cfg['holiday']['16']['date'] = '';
$cfg['holiday']['16']['name'] = '';
$cfg['holiday']['17']['date'] = '';
$cfg['holiday']['17']['name'] = '';
$cfg['holiday']['18']['date'] = '';
$cfg['holiday']['18']['name'] = '';
$cfg['holiday']['19']['date'] = '';
$cfg['holiday']['19']['name'] = '';
$cfg['holiday']['20']['name'] = '';
$cfg['holiday']['20']['date'] = '';
$cfg['holiday']['21']['name'] = '';
$cfg['holiday']['21']['date'] = '';
$cfg['holiday']['21']['name'] = '';
$cfg['holiday']['22']['date'] = '';
$cfg['holiday']['22']['name'] = '';
$cfg['holiday']['23']['date'] = '';
$cfg['holiday']['23']['name'] = '';
$cfg['holiday']['24']['date'] = '';
$cfg['holiday']['24']['name'] = '';
$cfg['holiday']['25']['date'] = '';
$cfg['holiday']['25']['name'] = '';
$cfg['holiday']['26']['date'] = '';
$cfg['holiday']['26']['name'] = '';
$cfg['holiday']['27']['date'] = '';
$cfg['holiday']['27']['name'] = '';
$cfg['holiday']['28']['date'] = '';
$cfg['holiday']['28']['name'] = '';
$cfg['holiday']['29']['date'] = '';
$cfg['holiday']['29']['name'] = '';

/**
* Login time configuration
* 	agent:		period for which agent will remain valid in seconds
* 	subscriber:		period for which subscriber will remain valid in seconds
* 	admin:		period for which admin will remain valid in seconds
*
*/
$cfg['login']['agent'] = '900';
$cfg['login']['subscriber'] = '1800';
$cfg['login']['admin'] = '72000';

/**
* Error configuration
* 	file:		location for file to log errors
* 				use // on windows os instead of /
* 	mail:		when to send email to support email address
* 		critical:	critical will only send email for critical errors
* 		serious:	serious will send email for serious and critical errors
* 		all:		will send email for all errors 
* 		none:		will not send any error mails
*/
$cfg['error']['file'] = './log/error.log';
$cfg['error']['email'] = 'none';

/**
* Log configuration
* 	status:		wether or not to log all incoming requests and responses
* 				handy for debugging but should not be active in production environment
* 				due to server strain
* 	file:		location for file to log all requests
* 				use // on windows os instead of /
*/
$cfg['log']['status'] = TRUE;
$cfg['log']['file'] = './log/request.log';
$cfg['log']['php'] = './log/php.log';

/**
* Security configuration
* 	ip_track:	wether or not to also check incoming ip address
* 	call:		only allow request from certain ip addresses - not used in module connection
* 	ip:			array of authorised ip addresses
* 		127.0.0.1 == localhost and must always be present
*/
$cfg['security']['ip_track'] = TRUE;
$cfg['security']['call'] = TRUE;
$cfg['security']['ip']['0'] = '127.0.0.1';
$cfg['security']['ip']['1'] = '127.0.0.1';
$cfg['security']['ip']['2'] = '127.0.0.1';

/**
* Security configuration
* 	ip_track:	wether or not to also check incoming ip address
* 	call:		only allow request from certain ip addresses - not used in module connection
* 	ip:			array of authorised ip addresses
* 		127.0.0.1 == localhost and must always be present
*/
$cfg['api']['authenticate'] = FALSE;
$cfg['api']['username']['0'] = '0';
$cfg['api']['password']['0'] = '0';
$cfg['api']['username']['1'] = '0';
$cfg['api']['password']['1'] = '0';
$cfg['api']['username']['2'] = '0';
$cfg['api']['password']['2'] = '0';
$cfg['api']['username']['3'] = '0';
$cfg['api']['password']['3'] = '0';
$cfg['api']['username']['4'] = '0';
$cfg['api']['password']['4'] = '0';
$cfg['api']['username']['5'] = '';
$cfg['api']['password']['5'] = '';

/**
* Localization configuration
* 	duration:	seconds to increment or decrease the time if server is located in 
* 				different time zone. This is required to determine tender closing time.
* 	display:	eg ECT
*/
$cfg['local']['duration'] = '0';
$cfg['local']['display'] = 'GMT';

/**
* Display configuration
* 	login:		how many login sessions to display 
* 	error:		how many logs to display
* 	limit:		limit the amount of display increments allowed to display
*/
$cfg['display']['login'] = '10';
$cfg['display']['logs'] = '5';
$cfg['display']['limit'] = '5';

/**
 * Settings configuration
 *  
 */
$cfg['settings']['rename'] = FALSE;
?>