<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Generate statistics
* @package TenderSystem
* @subpackage statistics
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = array("2","3");
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	$info = $params['info'];
	if($user['classification'] != "3") {
		if($user['permission'] == "1") {
			$info['usersid'] = $user['id'];
		} elseif($user['permission'] == "2") {
			$info['branchid'] = $user['branch'];
		}
		// set organisation
		$info['organisationid'] = $user['organisation'];	
	}
	// check for values
	if(!$info['startdate']) {
		// set default startdate
		$info['startdate'] = date("Y-m-d",ts_time($cfg) - 7889231); 	
	}
	if(!$info['enddate']) {
		// set default enddate
		$info['enddate'] = date("Y-m-d",ts_time($cfg)); 	
	}
	if(!$info['yaxis']) {
		// set default yaxis
		$info['yaxis'] = "tender"; 	
	}
	if(!$info['xaxis']) {
		// set default xaxis
		$info['xaxis'] = "monthly"; 	
	}
	$info['language'] = $user['language'];
	include($cfg['file'].'modules/statistics/language/'.$info['language'].'/statistics.php');
	if($info['yaxis'] == "tender") {
		require($cfg['file'].'modules/statistics/class/tender.class.php');
		$new_tender = new tender;
		$function = "get_".$info['xaxis']."_statistics";
		$data = $new_tender->$function($info,$cfg,$conn);
		if($info['xaxis'] == "hourly" || $info['xaxis'] == "daily" || $info['xaxis'] == "monthly") {
			$legend = $lang['tenderstatuslegend'];
		}
	} elseif($info['yaxis'] == "tenderitem") {
		require($cfg['file'].'modules/statistics/class/tenderitem.class.php');
		$new_tender = new tenderitem;
		$function = "get_".$info['xaxis']."_statistics";
		$data = $new_tender->$function($info,$cfg,$conn);		
		if($info['xaxis'] != "supplier") {
			$legend = $lang['tenderitemlegend'];
		}		
	} elseif($info['yaxis'] == "send") {
		require($cfg['file'].'modules/statistics/class/send.class.php');
		$new_tender = new send;
		$function = "get_".$info['xaxis']."_statistics";
		$data = $new_tender->$function($info,$cfg,$conn);
		if($info['xaxis'] == "hourly" || $info['xaxis'] == "daily" || $info['xaxis'] == "monthly") {
			$legend = $lang['sendlegend'];
		}
	} elseif($info['yaxis'] == "average_rfq") {
		require($cfg['file'].'modules/statistics/class/tenderitem.class.php');
		$new_tender_item = new tenderitem;
		$function = "get_".$info['xaxis']."_statistics";
		$data = $new_tender_item->$function($info,$cfg,$conn);
		$legend = $lang['average_rfqlegend'];		
	} elseif($info['yaxis'] == "conversion_rate") {
		require($cfg['file'].'modules/statistics/class/tenderitem.class.php');
		$new_tender = new tenderitem;
		$function = "get_".$info['xaxis']."_statistics";
		$data = $new_tender->$function($info,$cfg,$conn);
		$legend = $lang['average_rfqlegend'];		
	}
	// set x and y axis values;
	$xml_params['yaxis'] = $lang[$info['yaxis']];
	$xml_params['xaxis'] = $lang[$info['xaxis']];
	// set title
	$xml_params['title'] = $lang[$info['yaxis'].$info['xaxis']];
	// add time to title
	list($year,$month,$day) = sscanf(str_replace(array("-"," "),"",$info['startdate']),'%4s%2s%2s');
	$start_date = date($cfg['date']['format'],mktime(FALSE,FALSE,FALSE,$month,$day,$year));
	list($year,$month,$day) = sscanf(str_replace(array("-"," "),"",$info['enddate']),'%4s%2s%2s');
	$end_date = date($cfg['date']['format'],mktime(FALSE,FALSE,FALSE,$month,$day,$year));
	$xml_params['title'].= "\n".$start_date." - ".$end_date;
	// remove keys
	foreach($data as $value) {
		$new_data[] = $value;
	}
	// encoded data array 
	$xml_params['coded_data'] = base64_encode(serialize($new_data));
	// encod data array 
	$xml_params['coded_legend'] = base64_encode(serialize($legend));
	// file format
	$xml_params['file_format'] = $cfg['statistics']['image'];
	// generate xml
	$xml = $new_xml->xml_generator( "generic", "error","",$xml_params,$user,$cfg);
}
?>