<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Send class
* @package TenderSystem
* @subpackage statistics
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class send {
	// set paramaters
	var $user;
	var $tender;
	var $error;
	
	/**
	 * Get monthly statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_monthly_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT EXTRACT(MONTH FROM ~tender_request.created_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_request, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.status = 1 ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(MONTH FROM ~tender_request.created_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		require($cfg['file'].'modules/statistics/language/'.$this->user['language'].'/statistics.php');
		for($i = 1; $i < 13; $i++) {
			if($this->tender[$i]) {
				$response[$i-1] = array($lang['months'][$i],$this->tender[$i]);
			} else {
				$response[$i-1] = array($lang['months'][$i],"0");
			}
		}
		$sqlstr = "SELECT EXTRACT(MONTH FROM ~tender_quote.created_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_quote, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.method = 'email' ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(MONTH FROM ~tender_quote.created_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 1; $i < 13; $i++) {
			if($this->tender[$i]) {
				$response[$i-1][] = $this->tender[$i];
			} else {
				$response[$i-1][] = "0";
			}
		}
		$sqlstr = "SELECT EXTRACT(MONTH FROM ~tender_quote.created_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_quote, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.method = 'internet' ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(MONTH FROM ~tender_quote.created_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 1; $i < 13; $i++) {
			if($this->tender[$i]) {
				$response[$i-1][] = $this->tender[$i];
			} else {
				$response[$i-1][] = "0";
			}
		}
		$sqlstr = "SELECT EXTRACT(MONTH FROM ~tender_quote.created_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_quote, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.method = 'Auto' ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(MONTH FROM ~tender_quote.created_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 1; $i < 13; $i++) {
			if($this->tender[$i]) {
				$response[$i-1][] = $this->tender[$i];
			} else {
				$response[$i-1][] = "0";
			}
		}
		return $response;
	}
	
	/**
	 * Get daily statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_daily_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT EXTRACT(DAY FROM ~tender_request.created_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_request, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.status = 1 ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(DAY FROM ~tender_request.created_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		require($cfg['file'].'modules/statistics/language/'.$this->user['language'].'/statistics.php');
		for($i = 1; $i < 32; $i++) {
			if($this->tender[$i]) {
				$response[$i][] = $i;
				$response[$i][] = $this->tender[$i];
			} else {
				$response[$i][] = $i;
				$response[$i][] = "0";
			}
		}
		$sqlstr = "SELECT EXTRACT(DAY FROM ~tender_quote.created_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_quote, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.method = 'email' ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(DAY FROM ~tender_quote.created_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 1; $i < 32; $i++) {
			if($this->tender[$i]) {
				$response[$i][] = $this->tender[$i];
			} else {
				$response[$i][] = "0";
			}
		}
		$sqlstr = "SELECT EXTRACT(DAY FROM ~tender_quote.created_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_quote, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.method = 'internet' ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(DAY FROM ~tender_quote.created_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 1; $i < 32; $i++) {
			if($this->tender[$i]) {
				$response[$i][] = $this->tender[$i];
			} else {
				$response[$i][] = "0";
			}
		}
		$sqlstr = "SELECT EXTRACT(DAY FROM ~tender_quote.created_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_quote, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.method = 'Auto' ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(DAY FROM ~tender_quote.created_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 1; $i < 32; $i++) {
			if($this->tender[$i]) {
				$response[$i][] = $this->tender[$i];
			} else {
				$response[$i][] = "0";
			}
		}
		return $response;
	}
	
	/**
	 * Get hourly statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_hourly_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT EXTRACT(HOUR FROM ~tender_request.created_time) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_request, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.status = 1 ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(HOUR FROM ~tender_request.created_time) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 0; $i < 24; $i++) {
			if($this->tender[$i]) {
				$response[] = array($i.":00",$this->tender[$i]);
			} else {
				$response[] = array($i.":00","0");
			}
		}
		$sqlstr = "SELECT EXTRACT(HOUR FROM ~tender_quote.created_time) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_quote, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.method = 'email' ";
		$sqlstr.= "AND ~tender.close_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.close_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(HOUR FROM ~tender_quote.created_time) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 0; $i < 24; $i++) {
			if($this->tender[$i]) {
				$response[$i][] =$this->tender[$i];
			} else {
				$response[$i][] = "0";
			}
		}
		$sqlstr = "SELECT EXTRACT(HOUR FROM ~tender_quote.created_time) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_quote, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.method = 'internet' ";
		$sqlstr.= "AND ~tender.close_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.close_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(HOUR FROM ~tender_quote.created_time) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 0; $i < 24; $i++) {
			if($this->tender[$i]) {
				$response[$i][] =$this->tender[$i];
			} else {
				$response[$i][] = "0";
			}
		}
		$sqlstr = "SELECT EXTRACT(HOUR FROM ~tender_quote.created_time) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_quote, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.method = 'Auto' ";
		$sqlstr.= "AND ~tender.close_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.close_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(HOUR FROM ~tender_quote.created_time) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 0; $i < 24; $i++) {
			if($this->tender[$i]) {
				$response[$i][] =$this->tender[$i];
			} else {
				$response[$i][] = "0";
			}
		}
		return $response;
	}
	
	/**
	 * Get subscriber statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_subscriber_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT subscriber.id, COUNT(~tender.id) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_request, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.status = 1 ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY subscriber.id ";
		$sqlstr.= "ORDER BY COUNT(~tender.id) DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// get user info
		$new_users = new user;
		foreach($this->tender as $value) {
			$users_info = $new_users->get_info($value['id'],$cfg,$conn);
			$fullname = $users_info['name']." ".$users_info['surname'];
			$response[] = array($fullname,$value['count']);
		}
		return $response;
	}
	
	/**
	 * Get branch statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_branch_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT branch.id, COUNT(~tender.id) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_request, ~users subscriber, ~organisation_branch branch ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.status = 1 ";
		$sqlstr.= "AND subscriber.branch = branch.id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY branch.id ";
		$sqlstr.= "ORDER BY COUNT(~tender.id) DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// get branch info
		$new_branch = new branch;
		foreach($this->tender as $value) {
			$branch_info = $new_branch->get_info($value['id'],$cfg,$conn);
			$response[] = array($branch_info['name'],$value['count']);
		}
		return $response;
	}
	
	/**
	 * Get organisation statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_organisation_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT ~organisation.id, COUNT(~tender.id) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_request, ~users subscriber, ~organisation ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_request.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_request.status = 1 ";
		$sqlstr.= "AND subscriber.organisation  = ~organisation.id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY ~organisation.id ";
		$sqlstr.= "ORDER BY COUNT(~tender.id) DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// get organisation info
		$new_organisation = new organisation;
		foreach($this->tender as $value) {
			$organisation_info = $new_organisation->get_info($value['id'],$cfg,$conn);
			$response[] = array($organisation_info['name'],$value['count']);
		}
		return $response;
	}
	
	/**
	 * Get supplier statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_supplier_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT supplier.id, COUNT(~tender.id) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~tender_item, ~tender_quote, ~users subscriber, ~users agent, ~organisation supplier ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender_item.tender = ~tender.id ";
		$sqlstr.= "AND ~tender_quote.tender_item = ~tender_item.id ";
		$sqlstr.= "AND ~tender_quote.user_id = agent.id ";
		$sqlstr.= "AND agent.organisation  = supplier.id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id <= ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch <= ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation <= ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY supplier.id ";
		$sqlstr.= "ORDER BY COUNT(~tender.id) DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// get supplier info
		$new_organisation = new organisation;
		foreach($this->tender as $value) {
			$organisation_info = $new_organisation->get_info($value['id'],$cfg,$conn);
			$response[] = array($organisation_info['name'],$value['count']);
		}
		return $response;
	}
}
?>