<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Tender class
* @package TenderSystem
* @subpackage statistics
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class tender {
	// set paramaters
	var $user;
	var $tender;
	var $error;
	
	/**
	 * Get monthly statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_monthly_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT EXTRACT(MONTH FROM ~tender.created_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender LEFT JOIN ~users AS subscriber ";
		$sqlstr.= "			    ON ~tender.user_id = subscriber.id ";	
		$sqlstr.= "WHERE ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(MONTH FROM ~tender.created_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		require($cfg['file'].'modules/statistics/language/'.$this->user['language'].'/statistics.php');
		for($i = 1; $i < 13; $i++) {
			if($this->tender[$i]) {
				$response[$i-1] = array($lang['months'][$i],$this->tender[$i]);
			} else {
				$response[$i-1] = array($lang['months'][$i],"0");
			}
		}
		// set default values an array incorrect order
		$sqlstr = "SELECT EXTRACT(MONTH FROM ~tender.close_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(MONTH FROM ~tender.close_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 1; $i < 13; $i++) {
			if($this->tender[$i]) {
				$response[$i-1][] = $this->tender[$i];
			} else {
				$response[$i-1][] = "0";
			}
		}
		$sqlstr = "SELECT EXTRACT(MONTH FROM ~tender.complete_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(MONTH FROM ~tender.complete_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 1; $i < 13; $i++) {
			if($this->tender[$i]) {
				$response[$i-1][] = $this->tender[$i];
			} else {
				$response[$i-1][] = "0";
			}
		}
		return $response;
	}
	
	/**
	 * Get daily statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_daily_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT EXTRACT(DAY FROM ~tender.created_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(DAY FROM ~tender.created_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		require($cfg['file'].'modules/statistics/language/'.$this->user['language'].'/statistics.php');
		for($i = 1; $i <= 31; $i++) {
			if($this->tender[$i]) {
				$response[$i][] = $i;
				$response[$i][] = $this->tender[$i];
			} else {
				$response[$i][] = $i;
				$response[$i][] = "0";
			}
		}
		$sqlstr = "SELECT EXTRACT(DAY FROM ~tender.close_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(DAY FROM ~tender.close_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 1; $i <= 31; $i++) {
			if($this->tender[$i]) {
				$response[$i][] = $this->tender[$i];
			} else {
				$response[$i][] = "0";
			}
		}
		$sqlstr = "SELECT EXTRACT(DAY FROM ~tender.complete_date) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(DAY FROM ~tender.complete_date) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 1; $i <= 31; $i++) {
			if($this->tender[$i]) {
				$response[$i][] = $this->tender[$i];
			} else {
				$response[$i][] = "0";
			}
		}
		return $response;
	}
	
	/**
	 * Get hourly statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_hourly_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT EXTRACT(HOUR FROM ~tender.created_time) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(HOUR FROM ~tender.created_time) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		require($cfg['file'].'modules/statistics/language/'.$this->user['language'].'/statistics.php');
		for($i = 0; $i < 24; $i++) {
			$response[$i][] = $i.":00";
			if($this->tender[$i]) {
				$response[$i][] =$this->tender[$i];
			} else {
				$response[$i][] = "0";
			}
		}
		$sqlstr = "SELECT EXTRACT(HOUR FROM ~tender.close_time) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender.status = '4' ";
		$sqlstr.= "AND ~tender.close_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.close_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(HOUR FROM ~tender.close_time) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 0; $i < 24; $i++) {
			if($this->tender[$i]) {
				$response[$i][] =$this->tender[$i];
			} else {
				$response[$i][] = "0";
			}
		}
		$sqlstr = "SELECT EXTRACT(HOUR FROM ~tender.complete_time) AS value, COUNT(*) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender.status = '6' ";
		$sqlstr.= "AND ~tender.close_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.close_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY EXTRACT(HOUR FROM ~tender.complete_time) ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		for($i = 0; $i < 24; $i++) {
			if($this->tender[$i]) {
				$response[$i][] =$this->tender[$i];
			} else {
				$response[$i][] = "0";
			}
		}		
		return $response;
	}
	
	/**
	 * Get subscriber statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_subscriber_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT subscriber.id, COUNT(~tender.id) as count ";
		// FROM
		$sqlstr.= "FROM ~users subscriber, ~tender ";
		// WHERE
		$sqlstr.= "WHERE ~tender.user_id = subscriber.id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY subscriber.id ";
		$sqlstr.= "ORDER BY COUNT(~tender.id) DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// get user info
		$new_users = new user;
		foreach($this->tender as $value) {
			$users_info = $new_users->get_info($value['id'],$cfg,$conn);
			$fullname = $users_info['name'][0]." ".$users_info['surname'];
			if(!$value['count']) {
				$value['count'] = "0";
			}
			$response[] = array($fullname,$value['count']);
		}
		if ($params['yaxis'] == 'average_rfq') {
			foreach($this->tender as $value) {
				if(!$value['count']) {
					$value['count'] = "0";
				}
				$responseRFQ[] = array($value['id'], $value['count']);
			}	
		
			$sqlstr = "SELECT subscriber.id, SUM(~tender_item.quote) AS total ";
			// FROM
			$sqlstr.= "FROM ~tender, ~tender_item, ~users subscriber ";
			// WHERE
			$sqlstr.= "WHERE ~tender_item.tender = ~tender.id ";
			$sqlstr.= "AND subscriber.id = ~tender.user_id ";
			$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
			$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
			if($this->user['usersid']) {
				$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
			}
			if($this->user['branchid']) {
				$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
			}
			if($this->user['organisationid']) {
				$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
			}
			$sqlstr.= "GROUP BY subscriber.id";
			$new_database = new database;
			$new_database->parse_sql($sqlstr,$cfg);
			$this->tender = $conn->GetAssoc($sqlstr,"",FALSE);
			if($conn->ErrorMsg()) {
				// instantiate the error class and log
				$new_error = new error;
				$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
				$new_error->log("SQL","critical",$error_text,$cfg);
				// error occurred while querying into database 
				$this->error[] = "1065";
				// response
				return FALSE;
			}		
			$data = $this->tender;
			$new_users = new user;			
			foreach($data as $userid => $value) {
				for ($i = 0; $i < sizeof($response); $i++) {
					if ($responseRFQ[$i][0] == $userid) {	
						$users_info = $new_users->get_info($userid,$cfg,$conn);
						$fullname = $users_info['name'][0]." ".$users_info['surname'];
						$responseRFQ[$i][0] = $fullname;
						if ($responseRFQ[$i][1] != 0) { 						 
							$responseRFQ[$i][1] = $value / $responseRFQ[$i][1];
						}
					}					
				}
			}
			$response = $responseRFQ;
		}
		return $response;
	}
	
	/**
	 * Get branch statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_branch_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT branch.id, COUNT(~tender.id) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber, ~organisation_branch branch ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND subscriber.branch = branch.id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY branch.id ";
		$sqlstr.= "ORDER BY COUNT(~tender.id) DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// get branch info
		$new_branch = new branch;
		foreach($this->tender as $value) {
			$branch_info = $new_branch->get_info($value['id'],$cfg,$conn);
			$response[] = array($branch_info['name'],$value['count']);
		}
		return $response;
	}
	
	/**
	 * Get organisation statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_organisation_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT ~organisation.id, COUNT(~tender.id) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber, ~organisation ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND subscriber.organisation  = ~organisation.id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY ~organisation.id ";
		$sqlstr.= "ORDER BY COUNT(~tender.id) DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		// get organisation info
		$new_organisation = new organisation;
		foreach($this->tender as $value) {
			$organisation_info = $new_organisation->get_info($value['id'],$cfg,$conn);
			$response[] = array($organisation_info['name'],$value['count']);
		}
		return $response;
	}
	
	/**
	 * Get state statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_state_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT state.name, COUNT(~tender.id) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber, ~area_state state, ~area ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender.area  = ~area.id ";
		$sqlstr.= "AND ~area.state  = state.id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY state.id, state.name ";
		$sqlstr.= "ORDER BY COUNT(~tender.id) DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $this->tender;
	}
	
	/**
	 * Get area statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_area_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT ~area.id, ~area.name, COUNT(~tender.id) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber, ~area ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender.area  = ~area.id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY ~area.id, ~area.name ";
		$sqlstr.= "ORDER BY COUNT(~tender.id) DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		foreach($this->tender as $value) {
			if (strlen($value['name']) > 15) {
				$value['name'] = substr($value['name'], 0, 15)."..";
			}
			$response[] = $value;			
		}	
		return $response;
	}

	/**
	 * Get transport statistics
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param mixed tender_information or FALSE on error  
	 */
	function get_transport_statistics($params,$cfg,$conn) {
		// set default values an array incorrect order
		$this->user = $params;
		$sqlstr = "SELECT ~tender.transport, COUNT(~tender.id) AS count ";
		// FROM
		$sqlstr.= "FROM ~tender, ~users subscriber ";
		// WHERE
		$sqlstr.= "WHERE subscriber.id = ~tender.user_id ";
		$sqlstr.= "AND ~tender.created_date >= '".$this->user['startdate']."' ";
		$sqlstr.= "AND ~tender.created_date <= '".$this->user['enddate']."' ";
		if($this->user['usersid']) {
			$sqlstr.= "AND ~tender.user_id = ".$this->user['usersid']." ";
		}
		if($this->user['branchid']) {
			$sqlstr.= "AND subscriber.branch = ".$this->user['branchid']." ";
		}
		if($this->user['organisationid']) {
			$sqlstr.= "AND subscriber.organisation = ".$this->user['organisationid']." ";
		}
		$sqlstr.= "GROUP BY ~tender.transport ";
		$sqlstr.= "ORDER BY COUNT(~tender.id) DESC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$this->tender = $conn->GetAssoc($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		require($cfg['file'].'modules/statistics/language/'.$this->user['language'].'/statistics.php');
		foreach($this->tender as $key => $value) {
			$response[] = array($lang['trans_'.$key],$value['count']);
		}
		return $response;
	}	
}
?>