<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Add item
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// or
$required[1]['classification'] = "1";
$required[1]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif (!$cfg['tender']['enable']) {
	// e54 - Tender module is disabled
	$xml = $new_xml->xml_generator("tender","error","e54",$xml_params,$user,$cfg);
} else {
	// load required files
	require($cfg['file'].'modules/procure/config.inc.php');
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_update.class.php');
	require_once($cfg['file'].'modules/tender/class/tender_update.class.php');
	require($cfg['file'].'modules/category/class/category.class.php');
	// instantiate object
	$new_category = new category;
	$new_update = new tender_update;
	// get brands
	$xml_params['brand'] = $new_category->search_brand($params,$cfg,$conn);
	// get categories
	$xml_params['category'] = $new_category->search($params,$cfg,$conn);
	// get sub-categories
	$xml_params['subcategory'] = $new_category->search_sub($params,$cfg,$conn);
	if($user['classification'] != 3) {
		$params['organisationid'] = $user['organisation'];
	}
	$xml_params['organisationid'] = $params['organisationid'];
	$xml_params['show'] = "0";
	if(is_array($params['error'])) {
		$xml_params['currentinfo'] = $params['currentinfo'];
		// generate xml 
		$xml = $new_xml->xml_generator("tender","add_item",$params['error'],$xml_params,$user,$cfg);
	} elseif ($params['insert']) {
		if(!$params['upload']) {
			// go through each item
			$i = 0;
			foreach($params['insert'] as $value) {
				// brand
				$item['brand'] = $value['brand'];
				// category
				$category['searchinfo']['searchvalue'] = $value['category'];
				$categoryinfo = $new_category->search($category,$cfg,$conn);
				if($categoryinfo) {
					$item['category'] = $categoryinfo[0]['categoryid'];
					// sub category 
					$category_sub['searchinfo']['categoryid'] = $item['category'];
					$category_sub['searchinfo']['searchvalue'] = $value['category_sub'];
					$category_subinfo = $new_category->search_sub($category_sub,$cfg,$conn);
					if($category_subinfo) {
						$item['category_sub'] = $category_subinfo[0]['subcategoryid'];
					}
				}
				// model
				$item['model'] = $value['model'];
				// Description
				$item['description'] = $value['description'];
				// stock
				$item['stock'] = $value['stock'];
				// price
				$item['price'] = $value['price'];
				// item number
				$item['number'] = ++$i;
				$xml_params['uploaditem'][] = $item;
			}
			// valid_until
			$xml_params['validuntil_all'] = date("Y-m-d",ts_time($cfg) + 24 * 60 * 60 * $cfg['tender']['validity']['default']);
			$xml_params['show'] = "1";
			$xml = $new_xml->xml_generator("tender","add_item","",$xml_params,$user,$cfg);
		} else {
			// go through each item
			foreach($params['insert'] as $item) {
				// created by
				$item['supplier'] = $params['organisationid'];
				$item['created_by'] = $user['id'];
				if($new_update->add_item($item,$cfg,$conn)) {
					$xml_params['createdcount']++;
					$xml_params['created'] = "1";
				} elseif(!empty($new_organisation->error)) {
					$errors = array_merge($errors,$new_organisation->error);
					// clear errors
					$new_organisation->error = "";
				}
			}
			$date = date("Y-m-d",ts_time($cfg) + $cfg['tender']['validity']['default']*24*60*60);
			$xml_params['currentinfo'][0]['itemvaliduntil'] = $date;
			$xml_params['itemcount'] = count($params['insert']);
			$xml_params['show'] = "0";
			$xml = $new_xml->xml_generator("tender","add_item",$errors,$xml_params,$user,$cfg);
		}
	} else {
		$date = date("Y-m-d",ts_time($cfg) + $cfg['tender']['validity']['default']*24*60*60);
		$xml_params['currentinfo'][0]['itemvaliduntil'] = $date;
		// include required file
		$xml = $new_xml->xml_generator("tender","add_item","",$xml_params,$user,$cfg);
	}
}
?>