<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Submit tender
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// administrator is requesting tender on behalf of user
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// user
$required[1]['classification'] = "2";
$required[1]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($type,$permission,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif (!$cfg['tender']['enable']) {
	// e54 - Tender module is disabled
	$xml = $new_xml->xml_generator("tender","error","e54",$xml_params,$user,$cfg);
} else {
	require($cfg['file'].'modules/procure/config.inc.php');
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_request.class.php');
	// load required files
	require_once($cfg['file'].'modules/tender/class/tender_request.class.php');
	require_once($cfg['file'].'modules/area/class/area.class.php');
	require_once($cfg['file'].'modules/generic/class/message.class.php');
	require_once($cfg['file'].'modules/generic/class/file.class.php');
	require_once($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	$new_request = new tender_request;
	// insert tender information
	$tender_info = $new_request->get_tender($params['tenderid'],$cfg,$conn);
	$new_request->tender = $tender_info;  
	$new_request->tender['item'][] = $params['procure'];
	$params['procure']['area'] = $tender_info['area'];
	$params['procure']['userid'] = $tender_info['user_id'];
	$xml_params['tender'][0]['tenderid'] = $params['tenderid'];
	$xml_params['tender'][0]['userid'] = $tender_info['user_id'];
	if ($new_request->check_subscriber_profile($params,$user,$cfg,$conn)) {
		// initiate the added items
		if ($new_request->initiate_items($cfg,$conn)) {
			// check if should close if all quoted
			if($cfg['tender']['close']['auto']) {
				$new_request->check_tender_closure($cfg,$conn);
			}
			// error handling, generate the xml
			$xml = $new_xml->xml_generator("tender","add_success",$new_request->error,$xml_params,$user,$cfg);
		} else {
			// set the response
			$response['procure'][] = $new_request->response;
			// instantiate the xml object
			$new_xml = new xml;
				// generate the xml
				$xml = $new_xml->xml_generator("tender","error",$new_request->error,$response,$user,$cfg);
			}
		} else {
			// error handling, generate the xml
			$xml = $new_xml->xml_generator("tender","error",$new_request->error,$response,$user,$cfg);
		}
	} 
?>