<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Add quote
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif (!$cfg['tender']['enable']) {
	// e54 - Tender module is disabled
	$xml = $new_xml->xml_generator("tender","error","e54",$xml_params,$user,$cfg);
} else {
	// include procurement module config
	require($cfg['file'].'modules/procure/config.inc.php');
	// load required files
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_response.class.php');
	require($cfg['file'].'modules/tender/class/tender_response.class.php');
	require($cfg['file'].'modules/generic/class/file.class.php');
	if($cfg['procure']['attachment']['enable']) {
		$xml_params['attachment'] = "1";
	}
	$xml_params['localdisplay'] = $cfg['local']['display'];
	// instantiate object
	$new_response = new tender_response;
	// instantiate object
	$new_user = new user;
	$new_file = new file;
	if($new_response->check_agent_profile($params,$user,$cfg,$conn)) {
		if(is_array($params['item'])) {
			$new_response->set_language("tender",$user['language'],$cfg,$conn);
			$new_response->add_tender_quotes($xml_params,$params,"tender",$user,$cfg,$conn);
			// join errors
			if(!empty($new_response->error)) {
				$errors = array_merge($errors,$new_response->error);
			}
			$xml = $new_xml->xml_generator("tender","add_quote",$errors,$xml_params,$user,$cfg);
		} else {
			$new_response->find_tender_items($xml_params,$params,"tender",$cfg,$conn);
			$xml_params['tendervaliditydefault'] = $cfg['tender']['validity']['default'];
			$xml = $new_xml->xml_generator("tender","add_quote",$new_response->error,$xml_params,$user,$cfg);
		}
	}  else {
		// Unauthorised
		$xml = $new_xml->xml_generator("tender","error",$new_response->error,$xml_params,$user,$cfg);
	}
}
?>