<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Approve tender
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif (!$cfg['tender']['enable']) {
	// e54 - Tender module is disabled
	$xml = $new_xml->xml_generator("tender","error","e54",$xml_params,$user,$cfg);
} else {
	// load required files
	// might be included by login already
	require($cfg['file'].'modules/procure/config.inc.php');
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_approve.class.php');
	require_once($cfg['file'].'modules/tender/class/tender_approve.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_request.class.php');
	require_once($cfg['file'].'modules/tender/class/tender_request.class.php');
	require_once($cfg['file'].'modules/generic/class/message.class.php');
	require_once($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	require_once($cfg['file'].'modules/area/class/area.class.php');
	require_once($cfg['file'].'modules/category/class/category.class.php');
	// instantiate object
	$new_approve = new tender_approve;
	// determine if authorised user
	if($params['info']) {
		// tender not need to be approved
		$cfg['procure']['approve']['enable'] = FALSE;
		// set that busy approving
		$cfg['approving_rfq'] = TRUE;
		// request the tender
		if ($new_approve->approve_tender($params['info'],$cfg,$conn)) {
			// determine if there are any other tenders that need to be approved
			$second_approve = new tender_approve;
			$xml_params['approvaltenders'] = $second_approve->search_approve_tender(array(),"tender",$cfg,$conn);
			// merge the responses and errors
			$xml_params = array_merge($new_approve->response,$xml_params);
			// set the response
			$xml = $new_xml->xml_generator("tender","success",$new_approve->error,$xml_params,$user,$cfg);
		} else {
			// error handling, generate the xml
			$xml = $new_xml->xml_generator("tender","error",$new_approve->error,"",$user,$cfg);
		}
	} elseif($params['searchinfo']['tenderid'] || $params['searchinfo']['rfqnumber']) {
		// check for a tender id
		$xml_params['tender'] = $new_approve->search_approve_tender($params,"tender",$cfg,$conn);
		// get items
		$xml_params['tenderitem'] = $new_approve->search_approve_tender_item($xml_params['tender'][0]['tenderid'],$cfg,$conn);
		$new_category = new category;
		for($k = 0; $k < sizeof($xml_params['tenderitem']); $k++) {
			$sinfo1['searchinfo']['categoryname'] = $xml_params['tenderitem'][$k]['categoryname'];
			$category_info = $new_category->search($sinfo1,$cfg,$conn);
			$xml_params['tenderitem'][$k]['categoryid'] = $category_info[0]['categoryid'];
			$sinfo2['searchinfo']['category_subname'] = $xml_params['tenderitem'][$k]['category_subname'];
			$category_sub_info = $new_category->search_sub($sinfo2,$cfg,$conn);
			$xml_params['tenderitem'][$k]['category_subid'] = $category_sub_info[0]['subcategoryid'];		
		}
		$xml_params['tenderid'] = $xml_params['tender'][0]['tenderid'];
		// get area
		$xml_params['area'] = $new_approve->area_available($xml_params['tender'][0]['organisation'],$cfg,$conn);
		// get states
		$xml_params['state'] = $new_approve->state_available($xml_params['tender'][0]['organisation'],$cfg,$conn);
		$sinfo3['searchinfo']['categorystatus'] = "1";
		$xml_params['category'] = $new_category->search($sinfo3,$cfg,$conn);
		$xml_params['subcategory'] = $new_category->search_sub(NULL,$cfg,$conn);
		// join errors
		if(!empty($new_area->error)) {
			$errors = array_merge($errors,$new_area->error); 
		}
		if(!empty($new_admin->error)) {
			$errors = array_merge($errors,$new_admin->error); 
		}
		if ($cfg['procure']['approve']['url'] && $cfg['procure']['approve']['url'] != 'FALSE') {
			$xml_params['searchurl'] = $cfg['procure']['approve']['url'];
		}
		$xml = $new_xml->xml_generator("tender","approve",$errors,$xml_params,$user,$cfg);
	} else {
		// missing tender id
		$xml = $new_xml->xml_generator("tender","error","259",$xml_params,$user,$cfg);
	}
}
?>