<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Load areas into CSV file
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server

if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// or
$required[1]['classification'] = "1";
$required[1]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
}
else {
	require($cfg['file'].'modules/tender/language/'.$user['language'].'/areas.php');
	// determine if it is delivery or installation
	if ($params['type'] == 'delivery') {
		$brand = $lang['delivery'];
		$brand_des = $lang['delivery_des'];
	} else {
		$brand = $lang['installation'];
		$brand_des = $lang['installation_des'];
	}
	require($cfg['file'].'modules/area/class/area.class.php');
	$new_area = new area;
	$xml_params['areas'] = $new_area->search($params,$cfg,$conn);
	$i = 0;
	foreach($xml_params['areas'] as $areas_info) {
		$state_name =  $new_area->get_state_name_by_area($areas_info['areaid'],$cfg,$conn);
		$state_array['statename'] = $state_name;
		$xml_params['areas'][$i] = array_merge($xml_params['areas'][$i], $state_array);
		$i++;				
	}
	// set the response
	$xml = "\"".$lang['category']."\",\"".$lang['category_sub']."\",\"".$lang['brand']."\",\"".$lang['model']."\",\"".$lang['description']."\",\"".$lang['availability']."\",\"".$lang['price']."\" \n";
	$area_size = sizeof($xml_params['areas']);
	// set the areas
	for ($i = 0; $i < $area_size; $i++) {
		$xml.= "\"\",\"\",\"".$brand."\",\"".$xml_params['areas'][$i]['statename'].":".$xml_params['areas'][$i]['areaname']."\",\"".$brand_des.$xml_params['areas'][$i]['areaname']."\",\"\",\"\" \n";
	}
}
?>