<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Link generator
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

require($cfg['file'].'modules/tender/config.inc.php');
if($cfg['tender']['enable']) {
	// links for company admin
	if ($link == "organisation" && $sub_link == "left_company") {
		require($cfg['file'].'modules/tender/language/'.$user['language'].'/tender.php');
		if ($user['classification'] == "3") {
			$add['name'] = $lang['tenderrequest'];
			$add['frame'] = "main";
			$add['module'] = "tender";
			$add['function'] = "invitation";
			$xml_params['subscriberadmin'][] = $add;
			unset($add);
			$add['name'] = $lang['tenderaward'];
			$add['frame'] = "main";
			$add['module'] = "tender";
			$add['function'] = "subscriber_close";
			$xml_params['subscriberadmin'][] = $add;
			unset($add);
			$add['name'] = $lang['tendersuppliersearch'];
			$add['frame'] = "main";
			$add['module'] = "tender";
			$add['function'] = "supplier_search";
			$xml_params['suppliersearch'][] = $add;
			unset($add);
			$add['name'] = $lang['tendersupplierpanel'];
			$add['frame'] = "main";
			$add['module'] = "organisation";
			$add['function'] = "supplier_link";
			$xml_params['companyadmin'][] = $add;
			unset($add);
		} elseif ($user['classification'] == "2") {
			if ($cfg['tender']['supplier']['search']['menu']) {
				$add['name'] = $lang['tendersuppliersearch'];
				$add['frame'] = "main";
				$add['module'] = "tender";
				$add['function'] = "supplier_search";
				$xml_params['suppliersearch'][] = $add;
				unset($add);
				$add['name'] = $lang['tendersupplierpanel'];
				$add['frame'] = "main";
				$add['module'] = "organisation";
				$add['function'] = "supplier_link";
				$xml_params['companyadmin'][] = $add;
				unset($add);
			}
		}
	}
	
	// links for supplier admin
	if ($link == "organisation" && $sub_link == "left_supplier") {
		require($cfg['file'].'modules/tender/language/'.$user['language'].'/tender.php');
		if($user['classification'] == "3") {
			$add['name'] = $lang['submitQuote'];
			$add['frame'] = "main";
			$add['module'] = "tender";
			$add['function'] = "quote";
			$xml_params['agentadmin'][] = $add;
			unset($add); 
		}
		if($user['classification'] == "3" || ($user['classification'] == "1" && $user['permission'] == "2")) {
			$add['name'] = $lang['tendercategories'];
			$add['frame'] = "main";
			$add['module'] = "tender";
			$add['function'] = "show_category";
			$xml_params['supplieradmin'][] = $add;
			unset($add);			
		}
		if(($user['classification'] == "3" || $user['classification'] == "1") && $cfg['tender']['validity']['status']) {
			$add['name'] = $lang['additem'];
			$add['frame'] = "main";
			$add['module'] = "tender";
			$add['function'] = "add_item";
			$xml_params['supplieradmin'][] = $add;
			unset($add);
			$add['name'] = $lang['viewitem'];
			$add['frame'] = "main";
			$add['module'] = "tender";
			$add['function'] = "view_item";
			$xml_params['supplieradmin'][] = $add;
			unset($add);
		}
	}
	
	// links form company reports
	if ($link == "report" && $sub_link == "company") {
		require($cfg['file'].'modules/tender/language/'.$user['language'].'/tender.php');
		$add['name'] = $lang['groupbyquote'];
		$add['value'] = "tender_group_by_quote";
		$xml_params['reporttype'][] = $add;
		unset($add); 
	}
	
	// links form company reports
	if ($link == "report" && $sub_link == "company") {
		require($cfg['file'].'modules/tender/language/'.$user['language'].'/tender.php');
		$add['name'] = $lang['groupbyitem'];
		$add['value'] = "tender_group_by_item";
		$xml_params['reporttype'][] = $add;
		unset($add); 
	}	

	// links form company reports
	if ($link == "report" && $sub_link == "company") {
		require($cfg['file'].'modules/tender/language/'.$user['language'].'/tender.php');
		$add['name'] = $lang['groupbyprice'];
		$add['value'] = "tender_group_by_price";
		$xml_params['reporttype'][] = $add;
		unset($add); 
	}	

	// link for tender group by report
	if ($link == "report" && is_array($sub_link) && $sub_link['reportinfo']['reporttype'] == "tender_group_by_quote") {
		require_once($cfg['file'].'modules/procure/class/procure_report.class.php');
		require_once($cfg['file'].'modules/tender/class/tender_report.class.php');
		// instantiate object
		$new_report = new tender_report;
		$info['searchinfo'] = $sub_link['reportinfo'];
		$info['searchinfo']['tenderclassification'] = "tender";
		// set wether or not show cash settlement option
		if ($cfg['tender']['award']['cash']) {
			$xml_params['tenderawardcashoption'] = true;
		}
		// set wether or not show nontender supplier option
		if ($cfg['tender']['award']['nontendersupplier']) {
			$xml_params['tenderawardnontenderoption'] = true;
		}
		// set wether or not show invalidate option
		if ($cfg['tender']['award']['invalidate']) {
			$xml_params['tenderawardinvalidateoption'] = true;
		}
		$xml_params['tender'] = $new_report->search_tender($info,$cfg,$conn);
		// use tender ids to limit sql quotes and agents query
		if ($xml_params['tender']) {
			foreach($xml_params['tender'] as $tender_info) {
				$info['searchinfo']['tenderids'][] = $tender_info['tenderid'];						
			}
			$xml_params['agent'] = $new_report->search_agent($info,$cfg,$conn);
			$xml_params['tenderquote'] = $new_report->search_quoted($info,$cfg,$conn);
		}		
		$xml_params['module'] = "tender";
		$xml_params['function'] = "group_by_quote";
		// look for additional things to be added to report
		$this->link_api_find("tender","tender_group_by_quote",$xml_params,$user,$cfg,$conn);
	}

	// link for tender group by item report 
	if ($link == "report" && is_array($sub_link) && $sub_link['reportinfo']['reporttype'] == "tender_group_by_item") {
		require_once($cfg['file'].'modules/procure/class/procure_report.class.php');
		require_once($cfg['file'].'modules/tender/class/tender_report.class.php');
		// instantiate object
		$new_report = new tender_report;
		$info['searchinfo'] = $sub_link['reportinfo'];
		$info['searchinfo']['tenderclassification'] = "tender";
		// set wether or not show cash settlement option
		if ($cfg['tender']['award']['cash']) {
			$xml_params['tenderawardcashoption'] = true;
		}
		// set wether or not show nontender supplier option
		if ($cfg['tender']['award']['nontendersupplier']) {
			$xml_params['tenderawardnontenderoption'] = true;
		}
		// set wether or not show invalidate option
		if ($cfg['tender']['award']['invalidate']) {
			$xml_params['tenderawardinvalidateoption'] = true;
		}
		$xml_params['tender'] = $new_report->search_tender($info,$cfg,$conn);
		// use tender ids to limit sql quotes and agents query
		if ($xml_params['tender']) {
			foreach($xml_params['tender'] as $tender_info) {
				$info['searchinfo']['tenderids'][] = $tender_info['tenderid'];						
			}
			$xml_params['tenderitem'] = $new_report->search_tender_item($info,$cfg,$conn);
			$xml_params['tenderquote'] = $new_report->search_supplier_quoted($info,$cfg,$conn);
		}		
		
		$xml_params['module'] = "tender";
		$xml_params['function'] = "group_by_item";
	}

	// link for tender group by price report 
	if ($link == "report" && is_array($sub_link) && $sub_link['reportinfo']['reporttype'] == "tender_group_by_price") {
		require_once($cfg['file'].'modules/procure/class/procure_report.class.php');
		require_once($cfg['file'].'modules/tender/class/tender_report.class.php');
		// instantiate object
		$new_report = new tender_report;
		$info['searchinfo'] = $sub_link['reportinfo'];
		$info['searchinfo']['tenderclassification'] = "tender";
		// set wether or not show cash settlement option
		if ($cfg['tender']['award']['cash']) {
			$xml_params['tenderawardcashoption'] = true;
		}
		// set wether or not show nontender supplier option
		if ($cfg['tender']['award']['nontendersupplier']) {
			$xml_params['tenderawardnontenderoption'] = true;
		}
		// set wether or not show invalidate option
		if ($cfg['tender']['award']['invalidate']) {
			$xml_params['tenderawardinvalidateoption'] = true;
		}
		$xml_params['tender'] = $new_report->search_tender($info,$cfg,$conn);
		// use tender ids to limit sql quotes and agents query
		if ($xml_params['tender']) {
			foreach($xml_params['tender'] as $tender_info) {
				$info['searchinfo']['tenderids'][] = $tender_info['tenderid'];						
			}
			$xml_params['tenderitem'] = $new_report->search_tender_quote_position($info,$cfg,$conn);
			$xml_params['tenderquote'] = $new_report->search_supplier_quoted($info,$cfg,$conn);
		}		
		$xml_params['module'] = "tender";
		$xml_params['function'] = "group_by_price";
	}
	
	// links for admin control panel
	if ($link == "user" && $sub_link == "control") {
		require($cfg['file'].'modules/procure/config.inc.php');
		require($cfg['file'].'modules/tender/config.inc.php');
		require_once($cfg['file'].'modules/procure/class/procure.class.php');
		if($user['classification'] == "3") {
			require_once($cfg['file'].'modules/procure/class/procure_approve.class.php');
			require_once($cfg['file'].'modules/tender/class/tender_approve.class.php');
			// instantiate object
			$new_approve = new tender_approve;
			$count = $new_approve->get_approval_tender_count("tender",$cfg,$conn);
			if($count) {
				require($cfg['file'].'modules/tender/language/'.$user['language'].'/tender.php');
				$add['prename'] = $lang['tenderneedapproval']." (".$count.") : ";
				$add['name'] = $lang['clickhere'];
				$add['frame'] = "main";
				$add['module'] = "tender";
				$add['function'] = "show_approve";
				$xml_params['control_information'][] = $add;
				unset($add);
			}
		} elseif($user['classification'] == "2") {
			require_once($cfg['file'].'modules/procure/class/procure_update.class.php');
			require_once($cfg['file'].'modules/tender/class/tender_update.class.php');
			require($cfg['file'].'modules/tender/language/'.$user['language'].'/tender.php');
			// instantiate object
			$new_update = new tender_update;
			// approval tenders
			$count = $new_update->get_tender_count("tender","1",$user,$cfg,$conn);
			if($count) {
				$add['prename'] = $lang['tenderapprove']." (".$count.") : ";
				$add['name'] = $lang['toviewclick'];
				$add['frame'] = "main";
				$add['module'] = "tender";
				$add['function'] = "subscriber_approve";
				$xml_params['control_information'][] = $add;
				unset($add);
			}
			// open tenders
			$count = $new_update->get_tender_count("tender","2",$user,$cfg,$conn);
			if($count) {
				$add['prename'] = $lang['tenderopen']." (".$count.") : ";
				$add['name'] = $lang['toviewclick'];
				$add['frame'] = "main";
				$add['module'] = "tender";
				$add['function'] = "subscriber_open";
				$xml_params['control_information'][] = $add;
				unset($add);
			}
			// close tenders
			$count = $new_update->get_tender_count("tender","4",$user,$cfg,$conn);
			if($count) {
				$add['prename'] = $lang['tenderclose']." (".$count.") : ";
				$add['name'] = $lang['tocompleteclick'];
				$add['frame'] = "main";
				$add['module'] = "tender";
				$add['function'] = "subscriber_close";
				$xml_params['control_notice'][] = $add;
				unset($add);
			}
		} elseif($user['classification'] == "1") {
			require_once($cfg['file'].'modules/procure/class/procure_update.class.php');
			require_once($cfg['file'].'modules/tender/class/tender_update.class.php');
			require($cfg['file'].'modules/tender/language/'.$user['language'].'/tender.php');
			// instantiate object
			$new_update = new tender_update;
			// approval tenders
			$count = $new_update->get_agent_waiting_request_count("tender",$user,$cfg,$conn);
			if($count) {
				$add['prename'] = $lang['tenderagentwaiting']." (".$count.") : ";
				$add['name'] = $lang['toviewclick'];
				$add['frame'] = "main";
				$add['module'] = "tender";
				$add['function'] = "agent_open";
				$xml_params['control_notice'][] = $add;
				unset($add);
			}
			// instantiate object
			$new_update = new tender_update;
			// approval tenders
			$count = $new_update->get_agent_open_request_count("tender",$user,$cfg,$conn);
			if($count) {
				$add['prename'] = $lang['tenderagentopen']." (".$count.") : ";
				$add['name'] = $lang['toviewclick'];
				$add['frame'] = "main";
				$add['module'] = "tender";
				$add['function'] = "agent_open";
				$xml_params['control_information'][] = $add;
				unset($add);
			}
		}
	}
	
	// links for organisation setup
	if ($link == "organisation" && $sub_link == "setup") {
		require($cfg['file'].'modules/procure/config.inc.php');
		require($cfg['file'].'modules/tender/config.inc.php');
		require_once($cfg['file'].'modules/procure/class/procure.class.php');
		require_once($cfg['file'].'modules/procure/class/procure_update.class.php');
		require_once($cfg['file'].'modules/tender/class/tender_update.class.php');
		$new_update = new tender_update;
		$orginfo = $xml_params['organisationinfo'][0]; 
		if($orginfo['classification'] == "1" && $user['classification'] == "3") {
			$subcat = $new_update->search_supplier_sub($orginfo['organisationid'],"",$cfg,$conn);
			if(empty($subcat)) {
				require($cfg['file'].'modules/tender/language/'.$user['language'].'/tender.php');
				$add['prename'] = $lang['notendercategories'];
				$add['name'] = $lang['clickherefortendercat'];
				$add['frame'] = "main";
				$add['module'] = "tender";
				$add['function'] = "show_category";
				$xml_params['reminder'][] = $add;
				unset($add);
			}
		}
	}
}
?>