<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Post invitation
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// administrator is requesting tender on behalf of user
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// user
$required[1]['classification'] = "2";
$required[1]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif (!$cfg['tender']['enable']) {
	// e54 - Tender module is disabled
	$xml = $new_xml->xml_generator("tender","error","e54",$xml_params,$user,$cfg);
} else {
	// include procurement module config
	require($cfg['file'].'modules/procure/config.inc.php');
	// load required classes
	require($cfg['file'].'modules/area/class/area.class.php');
	require($cfg['file'].'modules/category/class/category.class.php');
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_request.class.php');
	require($cfg['file'].'modules/tender/class/tender_request.class.php');
	require($cfg['file'].'modules/report/class/report.class.php');
	$new_request = new tender_request;
	// determine if authorised user
	if ($new_request->check_subscriber_info($params,$user,$cfg,$conn)) {
		// parse users name and surname
		$xml_params['subscriber'][0]['name'] = $new_request->subscriber['name']; 
		$xml_params['subscriber'][0]['surname'] = $new_request->subscriber['surname'];
		$xml_params['subscriber'][0]['usersid'] = $new_request->subscriber['id'];
		// determine if claim number exists already
		if($params['procure']['rfq_number'] && $params['procure']['rfq_number'] != "Automatically generated") {
			// check if administrator
			if($user['classification'] != "3") {
				// set organisation
				$rfq_search['searchinfo']['organisationid'] = $user['organisation'];	
			}
			$rfq_search['searchinfo']['rfqnumber'] = $params['procure']['rfq_number'];
			// instantiate object
			$new_report = new report;
			// get organisations
			$rfq_exists = $new_report->rfqsearch($rfq_search,$cfg,$conn);
			if ($rfq_exists) {
				$xml_params['rfq_exists'] = "TRUE";
			}
		}
		// set default transport
		if(!$params['procure']['transport']) {
			$params['procure']['transport'] = $cfg['tender']['transport']['default'];
		}
		$xml_params['today'] = date("Y-m-d");
		$xml_params['hour'] = "12";
		$xml_params['min'] = "00";

		// set passed tender variables
		$xml_params['procure'][] = $params['procure'];
		// set errors 
		if ($params['error']) {
			$errors = $params['error'];
		}
		$organisation = $new_request->subscriber['organisation'];
		$categories = $new_request->category_available("",$params['procure']['area'],"1",$cfg,$conn);
		if($cfg['procure']['supplier']['require'] && empty($categories)) {
			// No categories or sub categories could be found with the current suppliers on your panel
			$errors[] = "1015";
			// instantiate the error class
			$xml = $new_xml->xml_generator("tender","error",$errors,$xml_params,$user,$cfg);
		} else {
			// get generic products
			$xml_params['product'] = $new_request->get_generic_products($user,$cfg,$conn);
			if($cfg['tender']['date']) {
				$xml_params['tenderdate'] = "1";
			} else {
				$xml_params['tenderdate'] = "0";
			}
			$xml_params['tenderduration'] = $cfg['time']['default'];
			if($cfg['tender']['collect']) {
				$xml_params['collect'] = "1";
			} else {
				$xml_params['collect'] = "0";
			}
			// Show RFQ Number and Reference
			$xml_params['rfq_number_done'] = "1";
			$xml_params['rfq_reference_done'] = "1";
			$xml = $new_xml->xml_generator("tender","post_invitation",$errors,$xml_params,$user,$cfg);
		}
	} else {
		// Unauthorised
		$xml = $new_xml->xml_generator("tender","error",$new_request->error,$xml_params,$user,$cfg);
	}
}
?>