<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Product
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// administrator is requesting tender on behalf of user
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// user
$required[1]['classification'] = "2";
$required[1]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif (!$cfg['tender']['enable']) {
	// e54 - Tender module is disabled
	$xml = $new_xml->xml_generator("tender","error","e54",$xml_params,$user,$cfg);
} else {
	// include procurement module config
	require($cfg['file'].'modules/procure/config.inc.php');
	// load required files
	require($cfg['file'].'modules/category/class/category.class.php');
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_request.class.php');
	require($cfg['file'].'modules/tender/class/tender_request.class.php');
	// instantiate object
	$new_user = new user;
	$new_request = new tender_request;
	$new_category = new category;
	// determine if authorised user
	if ($new_request->check_subscriber_info($params,$user,$cfg,$conn)) {
		// set some parameters
		$xml_params['tenderquantity'] = $cfg['tender']['quantity'];
		$xml_params['tenderbudget'] = $cfg['tender']['budget'];
		// set any errors
		if ($params['error']) {
			// set errors 
			$errors = $params['error'];
		}
		$xml_params['product_sel'] = $params['product'];
		// determine product
		$filename = $cfg['file']."/modules/tender/language/".$user['language']."/".$params['product'].".xml";
		if ($params['product'] != 'product' && $params['product'] && file_exists($filename)) {
			$good = $new_request->get_product_template($filename,$xml_params,$user,$cfg,$conn);
		}
		if(!$good) {
			// check if suppliers are needed to create tender
			if ($cfg['procure']['supplier']['required']) {
				$xml_params['category'] = $new_request->category_available("",$params['procure']['area'],"1",$cfg,$conn);	
				$xml_params['subcategory'] = $new_request->category_sub_available("",$params['procure']['area'],"1",$cfg,$conn);
			} else {
				$xml_params['category'] = $new_category->search("",$cfg,$conn);	
				$xml_params['subcategory'] = $new_category->search_sub("",$cfg,$conn);
			}
			$xml_params['brand'] = $new_category->search_brand(array(),$cfg,$conn);
			// populate commodities
			if ($cfg['tender']['commodity']) {
				// get the commodity fields
				$xml_params['commodity'][0] = $new_request->get_commodity_template($user,$cfg);
			}
		}
		// get generic products
		$xml_params['product'] = $new_request->get_generic_products($user,$cfg,$conn,$xml_params['product_name']);
		// generate xml
		if(!$template) {
			if(!$xml_params['procure']) {
				$xml_params['procure'] = array();
			}
			// default values
			if(!$xml_params['procure'][0]['quote'] && !$errors) {
				$xml_params['procure'][0]['quote'] = "0.00";
			}
			if(!$xml_params['procure'][0]['budget']&& !$errors) {
				$xml_params['procure'][0]['budget'] = "0.00";
			}
			if(!$xml_params['procure'][0]['quantity']&& !$errors) {
				$xml_params['procure'][0]['quantity'] = "1";
			}
			$xml = $new_xml->xml_generator("tender","product",$errors,$xml_params,$user,$cfg);
		} else {
			$xml = $new_xml->xml_generator("tender",$template,$errors,$xml_params,$user,$cfg);
		}
	} else {
		// Unauthorised
		$xml = $new_xml->xml_generator("tender","error",$new_request->error,$xml_params,$user,$cfg);
	}
}
?>