<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Proses email
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// load settings
require($cfg['file'].'modules/procure/config.inc.php');
require($cfg['file'].'modules/tender/config.inc.php');
if($cfg['tender']['enable']) {
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_close.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_response.class.php');
	require_once($cfg['file'].'modules/tender/class/tender_close.class.php');
	require_once($cfg['file'].'modules/tender/class/tender_response.class.php');
	require($cfg['file'].'modules/generic/language/'.$cfg['language'].'/error.php');
	require($cfg['file'].'modules/tender/language/'.$cfg['language'].'/request.php');
	if(is_array($new_email->response['tender'])) {
		foreach($new_email->response['tender'] as $value) {
			// parse the email into its various sections
			$new_response = new tender_response;
			$parse_email = $new_response->parse_email_info($value,$cfg,$conn);
			// if email could not be prosessed correctly send to support
			$message['type'] = $lang['emailtendertype'];
			$message['subject'] = $value['subject'];
			if (!$parse_email) {
				// log the error
				$message['text'] = wordwrap($lang[351]." ".$value['messageid']); 
				$message['class'] = "error";
				$new_error = new error;
				$new_error->log("POP","critical",$message['text'],$cfg);
			} else {
				$message['text'] = wordwrap($lang['tenderproses']); 
				$message['class'] = "success";
			}
			$params['message'][] = $message;
		}
	}
	// trigger the closing
	$new_close = new tender_close($cfg,$conn);
	$new_close->close($cfg,$conn);
	$params['message'] = array_merge($params['message'],$new_close->response['message']);
}
?>