<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Show category
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "all";
$required[0]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif (!$cfg['tender']['enable']) {
	// e54 - Tender module is disabled
	$xml = $new_xml->xml_generator("tender","error","e54",$xml_params,$user,$cfg);
} else {
	// include files
	require($cfg['file'].'modules/generic/class/file.class.php');
	require($cfg['file'].'modules/category/class/category.class.php');
	require($cfg['file'].'modules/procure/config.inc.php');
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_update.class.php');
	require_once($cfg['file'].'modules/tender/class/tender_update.class.php');
	$new_category = new category;
	$new_update = new tender_update;
	$new_file = new file;
	if(!$params['organisationid']) {
		$params['organisationid'] = $user['organisation'];
	}
	// get categories
	$xml_params['category'] =$new_category->search($params,$cfg,$conn);
	// get subcategorys
	$xml_params['subcategory'] =$new_category->search_sub($params,$cfg,$conn);
	// get selected subcategorys
	$xml_params['selectedsubcategory'] = $new_update->search_supplier_sub($params['organisationid'],"",$cfg,$conn);
	// check if editable 
	if($user['classification'] == "3" || 
	  ($user['permission'] == "2" && $user['classification'] == "1" && $user['organisation'] == $params['organisationid'])) {
	 	$xml_params['editable'] = "1";
	} else {
		$xml_params['editable'] = "0";
	} 
	if(empty($new_category->error) && $params['change'] && $xml_params['editable']) {
		if($params['check']) {
			$check = $params['check'];
		} else {
			$check = array();
		}
		$old_check = array();
		if (is_array($xml_params['selectedsubcategory'])) {
			foreach($xml_params['selectedsubcategory'] as $selectedsubcategory) {
				$old_check[$selectedsubcategory['subcategoryid']] = $selectedsubcategory['subcategorysupplierid'];
			}
		}
		
		// was not checked but is now checked
		foreach($check as $key => $value) {
			if(!$old_check[$key]) {
				if($new_update->create_category_sub_supplier($key,$params['organisationid'],$user['id'],$cfg,$conn)) {
					$xml_params['updated'] = "1";
				}
			}
		}
		
		// was checked but is now not checked
		foreach($old_check as $key => $value) {
			if(!$check[$key]) {
				if($new_update->delete_category_sub_supplier($value,$user['id'],$cfg,$conn)) {
					$xml_params['updated'] = "1";
				}
			}
		}
		// get selected subcategorys again
		$xml_params['selectedsubcategory'] = $new_update->search_supplier_sub($params['organisationid'],"",$cfg,$conn);
		
		// look for organisation setup links
		$xml_params['organisationinfo'][0]['classification'] = "1";
		$xml_params['organisationinfo'][0]['organisationid'] = $params['organisationid'];
		$new_file->link_api_find("organisation","setup",$xml_params,$user,$cfg,$conn);
	}
	$xml_params['organisationid']	= $params['organisationid'];
	// generate xml
	$xml = $new_xml->xml_generator("tender","show_category",$new_category->error,$xml_params,$user,$cfg);
}
?>