<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Close tender
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// administrator is requesting tender on behalf of user
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// subscriber
$required[1]['classification'] = "2";
$required[1]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} elseif (!$cfg['tender']['enable']) {
	// e54 - Tender module is disabled
	$xml = $new_xml->xml_generator("tender","error","e54",$xml_params,$user,$cfg);
} else {
	// determine if requested by administrator
	if ($user['classification'] == "3" && $params['usersid']) {
		$display['id'] = $params['usersid'];
		// get the users information
		$new_user = new user;
		$subscriber_information = $new_user->get_profile($params['usersid'],$cfg,$conn);
		$xml_params['subscriber_organisation_id'] = $subscriber_information['organisationid'];
		$display['classification'] = "2";
		$display['permission'] = "1";
	} else {
		$display = $user;
	}
	// load required files
	require($cfg['file'].'modules/procure/config.inc.php');
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_update.class.php');
	require_once($cfg['file'].'modules/tender/class/tender_update.class.php');
	// instantiate object
	$xml_params['localdisplay'] = $cfg['local']['display'];
	$new_update = new tender_update;
	if ($params['startdate'] && $params['enddate']) {
		$searchinfo['startdate'] = $params['startdate'];
		$searchinfo['enddate'] = $params['enddate'];
	}
	$xml_params['opentenders'] = $new_update->get_tender_for_subscriber("tender",$searchinfo,"4",$display,$cfg,$conn);
	$xml = $new_xml->xml_generator("tender","subscriber_close",$new_update->error,$xml_params,$user,$cfg);
}
?>