<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Show supplier
* @package TenderSystem
* @subpackage organisation
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// or
$required[1]['classification'] = "2";
$required[1]['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else{
	// load required files
	require($cfg['file'].'modules/category/class/category.class.php');
	require($cfg['file'].'modules/area/class/area.class.php');
	require($cfg['file'].'modules/procure/config.inc.php');
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_update.class.php');
	require_once($cfg['file'].'modules/tender/class/tender_update.class.php');
	if($params['searchinfo']) {
		// instantiate object
		$new_organisation = new tender_update;
		// get organisations
		$xml_params['organisation'] = $new_organisation->supplier_search($params,$cfg,$conn);
		// generate xml
		$xml = $new_xml->xml_generator("organisation","search",$new_organisation->error,$xml_params,$user,$cfg);
	} else {
		if($user['classification'] != "3") {
			$params['organisationid'] = $user['organisation'];
		}
		// instantiate object
		$new_category = new category;
		// get categories
		$xml_params['category'] = $new_category->search($params,$cfg,$conn);
		// get sub-categories
		$xml_params['subcategory'] = $new_category->search_sub($params,$cfg,$conn);
		// instantiate object
		$new_area = new area;
		// get categories
		$xml_params['state'] = $new_area->search_state($params,$cfg,$conn);
		// get sub-categories
		$xml_params['area'] = $new_area->search($params,$cfg,$conn);
		$xml_params['organisationid']	= $params['organisationid'];
		// generate xml 
		$xml = $new_xml->xml_generator("tender","supplier_search",$params['error'],$xml_params,$user,$cfg);
	}
}

?>