<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Supplier search
* @package TenderSystem
* @subpackage report
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = "all";
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if ($authorised) {
	// instantiate object
	require_once($cfg['file'].'modules/procure/class/procure.class.php');
	require_once($cfg['file'].'modules/procure/class/procure_approve.class.php');
	require_once($cfg['file'].'modules/tender/class/tender_approve.class.php');
	$new_approve_tender = new tender_approve;
	// get organisations
	$supplier = $new_approve_tender->get_tender_suppliers($params,$cfg,$conn);
	if($supplier) {
		$l = 0;
		for($k = 0; $k < sizeof($supplier); $k++) {
			// check if supplier supplies any of the items
			$sqlstr = "SELECT DISTINCT ~tender_item.id, ~tender_item.brand, ~tender_item.model, ";
			$sqlstr.= "~tender_item.description, ~tender_item.classification, ~tender_item.quote,   ";
			$sqlstr.= "~tender_item.budget,   ";
			$sqlstr.= "~category_sub.name AS category_sub ";
			$sqlstr.= "FROM ~tender_item, ~organisation,";
			$sqlstr.= "~category_supplier, ~category, ~category_sub ";
			$sqlstr.= "WHERE ~organisation.id = ".$supplier[$k]['supplierid']." ";
			$sqlstr.= "AND ~organisation.status = '1' ";
			$sqlstr.= "AND ~tender_item.status = '1' ";
			$sqlstr.= "AND ~organisation.id = ~category_supplier.supplier ";
			$sqlstr.= "AND ~category_supplier.status = '1' ";
			$sqlstr.= "AND ~tender_item.tender = '".$params['searchinfo']['tenderid']."' ";
			$sqlstr.= "AND ~category_sub.category = ~category.id "; 
			if(is_array($params['searchinfo']['category'])) {
				if(count($params['searchinfo']['category']) > 1) {
					$sqlstr.= "AND ( ~category.id = ".$params['searchinfo']['category'][0]." ";
					for($i = 1; $i < count($params['searchinfo']['category']); $i++) {
						$sqlstr.= "OR ~category.id = ".$params['searchinfo']['category'][$i]." ";
					}
					$sqlstr.= ") ";
				} elseif(count($params['searchinfo']['category']) == 1) {
					$sqlstr.= "AND ~category.id = ".$params['searchinfo']['category'][0]." ";
				}
			}
			if(is_array($params['searchinfo']['subcategory'])) {
				if(count($params['searchinfo']['subcategory']) > 1) {
					$sqlstr.= "AND ( ~category_supplier.category_sub = ".$params['searchinfo']['subcategory'][0]." ";
					for($i = 1; $i < count($params['searchinfo']['category']); $i++) {
						$sqlstr.= "OR ~category_supplier.category_sub = ".$params['searchinfo']['subcategory'][$i]." ";
					}
					$sqlstr.= ") ";
				} elseif(count($params['searchinfo']['subcategory']) == 1) {
					$sqlstr.= "AND ~category_supplier.category_sub = ".$params['searchinfo']['subcategory'][0]." ";
				}
			}
	
			$new_database = new database;
			$new_database->parse_sql($sqlstr,$cfg);
			// execute the query
	 		$items = $conn->GetAssoc($sqlstr);
	       	if ($conn->ErrorMsg()) {
				// instantiate the error class and log
				$new_error = new error;
				$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg()." SQL:".$sqlstr;
				$new_error->log("SQL","critical",$error_text,$cfg);
				// set the response error
				$this->error[] = "1065";
				// response
				return FALSE;
	       	}	
	      	//include if supplies any item
			if ($items) {
				$xml_params['supplier'][$l] = $supplier[$k];
				$l++;			
			} 
		}
	}
}
// generate xml
$xml = $new_xml->xml_generator("tender","suppliersearch",$new_user->error,$xml_params,$user,$cfg);
?>