<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Settings class
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class tender_settings extends settings {
	// user paramaters
	var $settings;
	var $user;
	var $error;
	
	/**
	 * Constructor, set the valid settings
	 * 
	 */
	function tender_settings() {
		// determine which display types to include
		$this->settings = array(
			'tenderenable'					=> "['tender']['enable']",
			'tendervaliditystatus'			=> "['tender']['validity']['status']",
			'tendervaliditydefault'			=> "['tender']['validity']['default']",
			'tendervalidityminimum'			=> "['tender']['validity']['minimum']",
			'tendervaliditymaximum'			=> "['tender']['validity']['maximum']",
			'tenderquantity'				=> "['tender']['quantity']",
			'tendercommodity'				=> "['tender']['commodity']",
			'tenderbudget'					=> "['tender']['budget']",
			'tenderexcess'					=> "['tender']['excess']",
			'tendersalvage'					=> "['tender']['salvage']",
			'tendercollect'					=> "['tender']['collect']",
			'tenderdate'					=> "['tender']['date']",
			'timedefault'					=> "['time']['default']",
			'timemax'						=> "['time']['max']",
			'tendervalidityall'				=> "['tender']['validity']['all']",
			'tendercloseauto'				=> "['tender']['close']['auto']",
			'tenderclosetime'				=> "['tender']['close']['time']",
			'tenderquotetime'				=> "['tender']['quote']['time']",
			'tenderexpireddefault'			=> "['tender']['expired']['default']",
			'tendercloseagent'				=> "['tender']['close']['agent']",
			'tendertransportdefault'		=> "['tender']['transport']['default']",
			'timeincrement'					=> "['time']['increment']",
			'tendersuppliersearchmenu'		=> "['tender']['supplier']['search']['menu']",
			'tenderreportnoquotes'			=> "['tender']['report']['noquotes']",
			'tenderawardcash' 				=> "['tender']['award']['cash']",
			'tenderawardnontendersupplier'	=> "['tender']['award']['nontendersupplier']",
			'tenderawardinvalidate'			=> "['tender']['award']['invalidate']",
			'tenderawardtoself'				=> "['tender']['award']['awardtoself']",
			'tendersmslimit'				=> "['tender']['smslimit']"
		);
	}
}
?>