<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Approve class
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class tender_approve extends procure_approve {
	// set paramaters
	var $user;
	var $tender;
	var $requester;
	var $deliver;
	var $supplier;
	var $agent;
	var $response;
	var $error;
	
	function tender_approve() {
		// allow to work on php5
		$this->error = array();
	}
	
	/**
	 * Set tender status to open and send out request emails
	 * 
	 * @param array tender The Tender infromation
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param boolean TRUE on success or FALSE on error  
	 */
	function approve_tender($tender,$cfg,$conn) {
		// validate paramaters
		$this->tender = $tender;
		if (!$this->tender['classification']) {
			//set to default
			$this->tender['classification'] = "tender";
		}
		if (!$this->tender['tenderid']) {
			$this->error[] = "259";
		}
		if (!$this->tender['rfq_number']) {
			$this->error[] = "33";
		}
		if (!$this->tender['rfq_reference']) {
			$this->error[] = "34";
		}
		if (!$this->tender['area']) {
			$this->error[] = "36";
		}
		if(!$this->tender['tenderitem']) {
			$this->error[] = "343";
		}
		if (!empty($this->error)) {
			// error in Approve Class
			$this->error[] = "318";
			// response
			return FALSE;
		} 
		$new_request = new tender_request;
		//set reponse fields
		$this->tender['id'] = $this->tender['tenderid'];
		$new_request->response = $new_request->tender = $this->tender;
		//set excluded suppliers id
		if($tender['supplier_select']) {
			$excluded_supplierids = array_keys($tender['supplier_select']);
			$new_request->tender['excluded'] = $excluded_supplierids;  
		} 	
		// not items
		unset($new_request->response['tenderitem']);
		unset($new_request->response['item']);  
		unset($new_request->tender['tenderitem']); 
		// set requester - positions may change
		$new_request->requester = $this->get_tender_requestor($this->tender['tenderid'],$cfg,$conn);
		$new_request->subscriber = $this->get_tender_subscriber($this->tender['tenderid'],$cfg,$conn);
		if(!$new_request->requester || !$new_request->subscriber){
			// error in Approve Class
			$this->error[] = "318";
			// response
			return FALSE;
		}
		$new_request->set_language("tender",$cfg,$conn);
		// calculate closing time
		$new_request->calculate_closure($cfg);
		$this->tender['closing']['date'] = $new_request->tender['closing']['date']; 
		$this->tender['closing']['time'] = $new_request->tender['closing']['time']; 
		// get the state and area
		$new_request->get_area_info($cfg,$conn);
		// change the tender items
		if (!$this->change_tender_info($cfg,$conn)) {
			if(!empty($new_request->error)) {
				$this->error = array_merge($this->error,$new_request->error);	
			}
			// error in Approve Class
			$this->error[] = "318";
			$conn->CompleteTrans(FALSE);
			// response
			return FALSE;
		}
		// initiate the items
		if (!$this->update_items($cfg,$conn)) {
			if(!empty($new_request->error)) {
				$this->error = array_merge($this->error,$new_request->error);	
			}
			// error in Approve Class
			$this->error[] = "318";
			$conn->CompleteTrans(FALSE);
			// response
			return FALSE;
		}
		// process tender
		$new_request->process_tender($cfg,$conn);
		$this->response = $new_request->response;
		if(!empty($new_request->error)) {
			$this->error = array_merge($this->error,$new_request->error);	
		}
		if (!empty($this->error)) {
			// error in Approve Class
			$this->error[] = "318";
			// response
			return FALSE;
		}
		// check if should close if all quoted
		if($cfg['tender']['close']['auto']) {
			$new_request->check_tender_closure($cfg,$conn);
		}
		// response
		return TRUE;
	}
	
	/**
	 * updates all the items of the tender
	 *
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param boolean TRUE on success or FALSE on error  
	 */
	function update_items($cfg,$conn) {
		// loop through every item and validate and upload
		foreach ($this->tender['tenderitem'] as $key => $value) {
			// set db array
			$info['update']['brand'] = $value['brand'];
			$info['update']['model'] = $value['model'];
			$info['update']['description'] = $value['description'];
			$info['update']['quote'] = $value['quote'];
			$info['update']['budget'] = $value['budget'];
			if(is_numeric($value['status'])) {
				$info['update']['status'] = $value['status'];
			}
			$info['where'] = "id = ".$key;
			// update item
			if($this->update_tender_item($info['update'],$info['where'],$cfg,$conn)) {
				$this->tender['item'][] = $this->get_item_info($key,$cfg,$conn);	
			}
			unset($info);
		}
		// response
		return TRUE;
	}
	
	/**
	 * changes information of a tender
	 *
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param boolean TRUE on success or FALSE on error  
	 */
	function change_tender_info($cfg,$conn) {
		$info['update']['area'] = $this->tender['area'];
		$info['update']['rfq_number'] = $this->tender['rfq_number'];
		$info['update']['rfq_reference'] = $this->tender['rfq_reference'];
		$info['update']['close_date'] = $this->tender['closing']['date'];
		$info['update']['close_time'] = $this->tender['closing']['time'];
		$info['where'] = "id = ".$this->tender['tenderid'];
		$this->update_tender($info['update'],$info['where'],$cfg,$conn);
		if(!empty($new_tender->error)) {
			$this->error = 	$new_tender->error;	
			// response
			return FALSE;
		}
		$this->response['id'] =  $this->tender['id'] = $this->tender['tenderid'];
		return TRUE;
	}
	
	function get_item_info($id,$cfg,$conn) {
		$sqlstr = "SELECT * "; 
		// FROM
		$sqlstr.= "FROM ~tender_item ";
		// WHERE
		$sqlstr.= "WHERE ~tender_item.id = ".$id;
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$row = $conn->GetRow($sqlstr);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $row;
	}
	
	/**
	 * Get all suppliers that quote in a certain area and for a certain company
	 * 
	 * @param integer area AREA ID
	 * @param integer company Company's Organisation ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param array   
	 */
	function get_tender_suppliers($params,$cfg,$conn) {
		// determine if area id is present
		if (!$params['searchinfo']['area']) {
			// no area could be found
			$this->error[] = "36";
			// Error in Agent class 
			$this->error[] = "311";
			return FALSE;
		}
		$sqlstr.= "SELECT DISTINCT ~organisation.id AS supplierid, ~organisation.name "; 
		$sqlstr.= "FROM ~organisation, ~organisation_branch, ~area_supplier, ~organisation_supplier "; 
		$sqlstr.= "WHERE ~organisation.status = '1' ";
		$sqlstr.= "AND ~organisation.id = ~organisation_branch.organisation ";
		$sqlstr.= "AND ~organisation_branch.status = '1' ";
		$sqlstr.= "AND ~organisation.id = ~area_supplier.supplier "; 
		$sqlstr.= "AND ~organisation.id = ~organisation_supplier.supplier "; 
		$sqlstr.= "AND ~organisation_supplier.organisation = '".$params['searchinfo']['organisationid']."' ";
		$sqlstr.= "AND ~area_supplier.status = '1' "; 
		$sqlstr.= "AND ~organisation_supplier.status = '1' "; 
		$sqlstr.= "AND ts_area_supplier.area = '".$params['searchinfo']['area']."' ";		
		$sqlstr.= "ORDER BY ~organisation.id ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		// execute the query
 		$all = $conn->GetAll($sqlstr);
       	if ($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// set the response error
			$this->error[] = "1065";
			// response
			return FALSE;
       	}
		// return user info
		return $all;
	}	
}
?>