<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* API Config settings 
* @package TenderSystem
* @subpackage tender
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// 	Enable or Disable Tender Module
$cfg['tender']['enable'] = TRUE;
// Whether or not valid Tender Items will be auto Inserted
$cfg['tender']['validity']['status'] = TRUE;
// Whether or not to valid items only if all the items can be inserted
$cfg['tender']['validity']['all'] = TRUE;
// default validity period that Tender Items will remain valid
$cfg['tender']['validity']['default'] = '14';
// 	minimum validity period that Tender Items will remain valid
$cfg['tender']['validity']['minimum'] = '2';
// 	maximum validity period that Tender Items will remain valid
$cfg['tender']['validity']['maximum'] = '30';
// Wether or not Tenders closing time is changed if all suppliers have quoted
$cfg['tender']['close']['auto'] = TRUE;
// If above setting is True, How much seconds open time must remain
$cfg['tender']['close']['time'] = '0';
// How to influence Tender Time on Tender Quoting
// 0 - will do nothing
// ! - will increase tender time (EG !100 increase by 100 seconds)
// ^ - will decrease tender time (EG ^100 decrease by 100 seconds)
// # - will set tender closing time (EG #100 set Tender Closing time to 100 seconds from current time)
$cfg['tender']['quote']['time'] = '0';
// Whether or Not to use Expired Tender Quote Prices as the default value for new Tender Items
$cfg['tender']['expired']['default'] = TRUE;
// Whether or Not a Tender Closing Report must be sent to agents
$cfg['tender']['close']['agent'] = TRUE;
// Default Transport setting for Tenders
$cfg['tender']['transport']['default'] = 'd';
// If Transport Tender Items can be sent alone
// $cfg['tender']['transport']['alone'] = '1';
// wether or not quantity option is available when creating tender invitations
$cfg['tender']['quantity'] = TRUE;
// Include the commodity dropdown option
$cfg['tender']['commodity'] = FALSE;
// 	Include the budget value in the tender description
$cfg['tender']['budget'] = TRUE;
//	wether or not collection option displayed when requesting Tenders
$cfg['tender']['collect'] = TRUE;
//	wether or not subsribers may select the closing time
$cfg['tender']['date'] = TRUE;
// Maximum days a tender may be open
$cfg['tender']['maximum'] = '365';
// default Tender Open Time in minutes
$cfg['time']['default'] = '120';
// Maximum Tender Open Time in minutes
$cfg['time']['max'] = '240';
// Tender Open Time increment minutes
$cfg['time']['increment'] = '15';
// Tender Open Time close within minutes
$cfg['time']['within'] = '30';
//	wether or not excess must be displayed when awarding Tender Items
$cfg['tender']['excess'] = FALSE;
//	wether or not collect salvage option offered on awarding on Tender Items
$cfg['tender']['salvage'] = FALSE;
//	wether or not to show no quotes in subscriber report
$cfg['tender']['report']['noquotes'] = TRUE;
// wether or not show tender supplier search for subscribers
$cfg['tender']['supplier']['search']['menu'] = TRUE;
// wether or not show cash settlement option
$cfg['tender']['award']['cash'] = TRUE;
// wether or not show nontender supplier option
$cfg['tender']['award']['nontendersupplier'] = FALSE;
// wether or not show invalidate option
$cfg['tender']['award']['invalidate'] = TRUE;
// set client information to current user
$cfg['tender']['award']['awardtoself'] = FALSE;
// limit for the number of rfq sms's to send out    
$cfg['tender']['smslimit'] = '1';
?>